/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.teiid.designer.ui.UiConstants;

public class DelegatableAction
extends Action
implements ISelectionListener {
    private IActionDelegate delegate;
    private IWorkbenchWindow window;
    private static final String MISSING_WINDOW = UiConstants.Util.getString("DelegatableAction.WorkbenchWindowIsNullMessage", new Object[0]);

    public DelegatableAction(IActionDelegate delegate) {
        super(null, 0);
        this.delegate = delegate;
        this.init();
    }

    public DelegatableAction(IActionDelegate delegate, IWorkbenchWindow window) {
        super(null, 0);
        this.delegate = delegate;
        this.window = window;
        this.init();
    }

    public void init() {
        if (this.delegate instanceof IWorkbenchWindowActionDelegate) {
            ((IWorkbenchWindowActionDelegate)this.delegate).init(this.getWorkbenchWindow());
        }
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        if (this.window == null) {
            throw new IllegalStateException(MISSING_WINDOW);
        }
        return this.window;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        this.selectionChanged(sel);
    }

    public void selectionChanged(ISelection selection) {
        if (selection == null) {
            selection = StructuredSelection.EMPTY;
        }
        this.delegate.selectionChanged((IAction)this, selection);
    }

    public void run() {
        this.delegate.run((IAction)this);
    }
}

