/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.notification.util.DefaultIgnorableNotificationSource;
import org.teiid.designer.core.refactor.ModelResourceCollectorVisitor;
import org.teiid.designer.core.refactor.RefactorResourceEvent;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.DelegatableAction;
import org.teiid.designer.ui.actions.DeleteEObjectAction;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.actions.AbstractAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.refactor.delete.DeleteResourceActionDelegate;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DeleteAction
extends AbstractAction
implements UiConstants {
    private DelegatableAction deleteResourceAction;
    private AbstractAction deleteEObjectAction;
    private Action delegateAction;
    private boolean initialised = false;

    public DeleteAction() {
        super((AbstractUiPlugin)UiPlugin.getDefault());
        ISharedImages imgs = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
    }

    private List allSelectedAndContainedModelFiles(List selectedResources) {
        ArrayList<IResource> allSelectedAndContainedModelFiles = Collections.EMPTY_LIST;
        int size = selectedResources.size();
        int i = 0;
        while (i < size) {
            Object obj = selectedResources.get(i);
            if (obj instanceof IResource) {
                if (allSelectedAndContainedModelFiles.isEmpty()) {
                    allSelectedAndContainedModelFiles = new ArrayList<IResource>();
                }
                IResource iRes = (IResource)obj;
                if (!(obj instanceof IFolder) && ModelUtilities.isModelFile(iRes)) {
                    if (!allSelectedAndContainedModelFiles.contains(iRes)) {
                        allSelectedAndContainedModelFiles.add(iRes);
                    }
                } else if (obj instanceof IFolder || obj instanceof IProject) {
                    Collection folderModels = this.getContainedModelFiles(obj);
                    Iterator iter = folderModels.iterator();
                    IResource nextRes = null;
                    while (iter.hasNext()) {
                        nextRes = (IResource)iter.next();
                        if (allSelectedAndContainedModelFiles.contains(nextRes)) continue;
                        allSelectedAndContainedModelFiles.add(nextRes);
                    }
                }
            }
            ++i;
        }
        return allSelectedAndContainedModelFiles;
    }

    private void appendDependentModelFiles(Collection affectedResources, Collection allAffectedResources, Collection targetedResources, Collection selectedObjects) {
        Iterator iter = affectedResources.iterator();
        IResource mr = null;
        while (iter.hasNext()) {
            mr = (IResource)iter.next();
            if (targetedResources.contains(mr) || allAffectedResources.contains(mr) || this.isUnderSelectedObjects(mr, selectedObjects)) continue;
            allAffectedResources.add(mr);
        }
    }

    private boolean closeFile(IFile theFile) {
        IEditorPart editor;
        boolean result = true;
        ModelResource model = null;
        if (ModelUtilities.isModelFile((IResource)theFile)) {
            try {
                model = ModelUtil.getModelResource((IFile)theFile, (boolean)false);
                if (model != null) {
                    IEditorReference editorRef;
                    if (model.isLoaded()) {
                        if (ModelEditorManager.isOpen(theFile)) {
                            if (!ModelEditorManager.isOpenAndInitialized(theFile)) {
                                ModelEditorManager.close(theFile, false);
                            }
                        } else {
                            editorRef = ModelEditorManager.getEditorReferenceForFile(theFile);
                            if (editorRef != null) {
                                ModelEditorManager.removeEditorReference(editorRef);
                            }
                        }
                    } else {
                        editorRef = ModelEditorManager.getEditorReferenceForFile(theFile);
                        if (editorRef != null) {
                            ModelEditorManager.removeEditorReference(editorRef);
                        }
                    }
                }
            }
            catch (ModelWorkspaceException theException) {
                Util.log((Throwable)theException);
                result = false;
            }
            if (result) {
                try {
                    if (model != null) {
                        this.closeModel(model);
                    }
                }
                catch (ModelWorkspaceException theException) {
                    Util.log((Throwable)theException);
                    result = false;
                }
            }
        } else if (ModelUtil.isVdbArchiveFile((IResource)theFile) && (editor = UiUtil.getEditorForFile((IFile)theFile, (boolean)false)) != null) {
            if (editor.isDirty()) {
                String title = UiConstants.Util.getString("DeleteResourceAction.pendingChangesTitle", new Object[0]);
                String message = UiConstants.Util.getString("DeleteResourceAction.pendingChangesMessage", (Object)theFile.getName());
                result = MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message);
            }
            if (result) {
                UiUtil.close((IFile)theFile, (boolean)false);
            }
        }
        return result;
    }

    private boolean closeFolder(IFolder theFolder) {
        boolean result = true;
        try {
            IResource[] kids = theFolder.members();
            if (kids.length > 0) {
                int i = 0;
                while (i < kids.length) {
                    if (!this.closeResource(kids[i])) {
                        result = false;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException theException) {
            Util.log((Throwable)theException);
            result = false;
        }
        return result;
    }

    private void closeModel(ModelResource modelResource) throws ModelWorkspaceException {
        ModelResourceEvent event = new ModelResourceEvent(modelResource, 2, (Object)this);
        UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
        if (modelResource.isOpen() && modelResource.isLoaded()) {
            modelResource.getEmfResource().setModified(false);
            modelResource.close();
            event = new ModelResourceEvent(modelResource, 3, (Object)this);
            UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
        }
    }

    private boolean closeProject(IProject theProject) {
        boolean result = true;
        try {
            IResource[] kids = theProject.members();
            if (kids.length > 0) {
                int i = 0;
                while (i < kids.length) {
                    if (!this.closeResource(kids[i])) {
                        result = false;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException theException) {
            Util.log((Throwable)theException);
            result = false;
        }
        return result;
    }

    private boolean closeResource(IResource theResource) {
        boolean result = true;
        if (ModelerCore.hasModelNature((IProject)theResource.getProject())) {
            if (theResource instanceof IProject) {
                result = this.closeProject((IProject)theResource);
            } else if (theResource instanceof IFolder) {
                result = this.closeFolder((IFolder)theResource);
            } else if (theResource instanceof IFile) {
                result = this.closeFile((IFile)theResource);
            }
        }
        return result;
    }

    private void closeResources(List resources) {
        List modifiedResources;
        block16: {
            boolean userOK = true;
            modifiedResources = ModelBuildUtil.getModifiedResources();
            boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Closing Resources for Delete", (Object)new DefaultIgnorableNotificationSource((Object)this));
            boolean succeeded = false;
            try {
                try {
                    int size = resources.size();
                    int i = 0;
                    while (i < size && userOK) {
                        Object obj = resources.get(i);
                        if (obj instanceof IResource) {
                            userOK = this.closeResource((IResource)obj);
                        }
                        ++i;
                    }
                    succeeded = true;
                }
                catch (Exception err) {
                    String msg = Util.getString("DeleteResourceAction.closeResources", new Object[0]);
                    this.getPluginUtils().log(4, (Throwable)err, msg);
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                throw throwable;
            }
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        ModelBuildUtil.setModifiedResources((List)modifiedResources);
    }

    protected Container doGetContainer() {
        try {
            return ModelerCore.getModelContainer();
        }
        catch (CoreException err) {
            String message = Util.getString("DeleteResourceAction.doGetContainerProblemMessage", new Object[0]);
            UiConstants.Util.log(4, (Throwable)err, message);
            return null;
        }
    }

    protected void doRun() {
        this.initDelegateActions();
        this.delegateAction.run();
    }

    private Collection getContainedModelFiles(Object folderOrProject) {
        ArrayList<IResource> containedModelFiles;
        block10: {
            ModelResourceCollectorVisitor visitor;
            block9: {
                containedModelFiles = Collections.EMPTY_LIST;
                visitor = new ModelResourceCollectorVisitor();
                if (!(folderOrProject instanceof IFolder)) break block9;
                IProject project = ((IFolder)folderOrProject).getProject();
                if (project == null) break block10;
                if (project.isOpen() && ModelerCore.hasModelNature((IProject)project)) {
                    try {
                        ((IFolder)folderOrProject).accept((IResourceVisitor)visitor);
                    }
                    catch (CoreException e) {
                        UiConstants.Util.log((Throwable)e);
                    }
                }
                List pResources = visitor.getResources();
                containedModelFiles = new ArrayList<IResource>(pResources.size());
                Iterator iter = pResources.iterator();
                IResource nextRes = null;
                while (iter.hasNext()) {
                    nextRes = (IResource)iter.next();
                    if (!ModelUtilities.isModelFile(nextRes)) continue;
                    containedModelFiles.add(nextRes);
                }
                break block10;
            }
            if (folderOrProject instanceof IProject) {
                IProject project = (IProject)folderOrProject;
                if (project.isOpen() && ModelerCore.hasModelNature((IProject)project)) {
                    try {
                        project.accept((IResourceVisitor)visitor);
                    }
                    catch (CoreException e) {
                        UiConstants.Util.log((Throwable)e);
                    }
                }
                List pResources = visitor.getResources();
                containedModelFiles = new ArrayList(pResources.size());
                Iterator iter = pResources.iterator();
                IResource nextRes = null;
                while (iter.hasNext()) {
                    nextRes = (IResource)iter.next();
                    if (!ModelUtilities.isModelFile(nextRes)) continue;
                    containedModelFiles.add(nextRes);
                }
            }
        }
        return containedModelFiles;
    }

    protected Shell getShell() {
        return UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }

    protected void initDelegateActions() {
        if (this.initialised) {
            return;
        }
        this.deleteResourceAction = new DelegatableAction((IActionDelegate)new DeleteResourceActionDelegate(), UiUtil.getWorkbenchWindow());
        this.deleteEObjectAction = new DeleteEObjectAction();
        this.delegateAction = this.deleteResourceAction;
        this.initialised = true;
    }

    private boolean isOkToCloseFile(IFile theFile) {
        IEditorPart editor;
        boolean result = true;
        ModelResource model = null;
        if (ModelUtilities.isModelFile((IResource)theFile)) {
            try {
                model = ModelUtil.getModelResource((IFile)theFile, (boolean)false);
                if (model != null && model.isLoaded() && model.getEmfResource().isModified()) {
                    String title = UiConstants.Util.getString("DeleteResourceAction.pendingChangesTitle", new Object[0]);
                    String message = UiConstants.Util.getString("DeleteResourceAction.pendingChangesMessage", (Object)theFile.getName());
                    result = MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message);
                }
            }
            catch (ModelWorkspaceException theException) {
                Util.log((Throwable)theException);
                result = false;
            }
        } else if (ModelUtil.isVdbArchiveFile((IResource)theFile) && (editor = UiUtil.getEditorForFile((IFile)theFile, (boolean)false)) != null && editor.isDirty()) {
            String title = UiConstants.Util.getString("DeleteResourceAction.pendingChangesTitle", new Object[0]);
            String message = UiConstants.Util.getString("DeleteResourceAction.pendingChangesMessage", (Object)theFile.getName());
            result = MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message);
        }
        return result;
    }

    private boolean isOkToCloseFolder(IFolder theFolder) {
        boolean result = true;
        try {
            IResource[] kids = theFolder.members();
            if (kids.length > 0) {
                int i = 0;
                while (i < kids.length) {
                    if (!this.isOkToCloseResource(kids[i])) {
                        result = false;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException theException) {
            Util.log((Throwable)theException);
            result = false;
        }
        return result;
    }

    private boolean isOkToCloseProject(IProject theProject) {
        boolean result = true;
        try {
            IResource[] kids = theProject.members();
            if (kids.length > 0) {
                int i = 0;
                while (i < kids.length) {
                    if (!this.isOkToCloseResource(kids[i])) {
                        result = false;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException theException) {
            Util.log((Throwable)theException);
            result = false;
        }
        return result;
    }

    private boolean isOkToCloseResource(IResource theResource) {
        boolean result = true;
        if (ModelerCore.hasModelNature((IProject)theResource.getProject())) {
            if (theResource instanceof IProject) {
                result = this.isOkToCloseProject((IProject)theResource);
            } else if (theResource instanceof IFolder) {
                result = this.isOkToCloseFolder((IFolder)theResource);
            } else if (theResource instanceof IFile) {
                result = this.isOkToCloseFile((IFile)theResource);
            }
        }
        return result;
    }

    private boolean isOkToCloseResources(List resources) {
        boolean userOK;
        block11: {
            userOK = true;
            boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Confirming Close Resources", (Object)new DefaultIgnorableNotificationSource((Object)this));
            boolean succeeded = false;
            try {
                try {
                    int size = resources.size();
                    int i = 0;
                    while (i < size && userOK) {
                        Object obj = resources.get(i);
                        if (obj instanceof IResource) {
                            userOK = this.isOkToCloseResource((IResource)obj);
                        }
                        ++i;
                    }
                    succeeded = true;
                }
                catch (Exception err) {
                    String msg = UiConstants.Util.getString("DeleteResourceAction.confirmingCloseResources", new Object[0]);
                    UiConstants.Util.log(4, (Throwable)err, msg);
                    if (!started) break block11;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block11;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return userOK;
    }

    private boolean isUnderSelectedObjects(IResource dependentResource, Collection selectedObjects) {
        Iterator iter = selectedObjects.iterator();
        while (iter.hasNext()) {
            if (!dependentResource.getProject().equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    private boolean isValidSelection() {
        if (SelectionUtilities.isMixedObjectTypes((ISelection)this.getSelection())) {
            return false;
        }
        List selectedObjects = this.getSelectedObjects();
        for (Object nextObj : selectedObjects) {
            if (nextObj instanceof IProject) {
                String projName = ((IProject)nextObj).getName();
                if (!ModelerCore.isReservedProjectName((String)projName)) continue;
                return false;
            }
            if (!(nextObj instanceof IFile)) continue;
            IFile file = (IFile)nextObj;
            if (file.getFileExtension() != null && file.getFileExtension().equalsIgnoreCase("project")) {
                return false;
            }
            if (!file.getName().equalsIgnoreCase("FunctionDefinitions.xmi")) continue;
            return false;
        }
        return true;
    }

    private void notifyDeleted(IPath deletedResourcePath) {
        ((ModelerCore)ModelerCore.getPlugin()).notifyRefactored(new RefactorResourceEvent(null, 2, (Object)this, deletedResourcePath));
    }

    private void setEnablement() {
        if (!this.isValidSelection()) {
            this.setEnabled(false);
            return;
        }
        if (this.deleteResourceAction.isEnabled()) {
            this.delegateAction = this.deleteResourceAction;
            this.setEnabled(true);
        } else if (this.deleteEObjectAction != null && this.deleteEObjectAction.isEnabled()) {
            this.delegateAction = this.deleteEObjectAction;
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        this.initDelegateActions();
        super.selectionChanged(thePart, theSelection);
        if (this.deleteEObjectAction != null) {
            this.deleteEObjectAction.selectionChanged(thePart, theSelection);
        }
        this.deleteResourceAction.selectionChanged(thePart, theSelection);
        this.setEnablement();
    }

    public void selectionChanged(SelectionChangedEvent theEvent) {
        this.initDelegateActions();
        super.selectionChanged(theEvent);
        if (this.deleteEObjectAction != null) {
            this.deleteEObjectAction.selectionChanged(theEvent);
        }
        this.deleteResourceAction.selectionChanged(theEvent.getSelection());
        this.setEnablement();
    }

    void validateDependentResources(Collection modelIResources, IProgressMonitor theMontitor) {
        block10: {
            if (!modelIResources.isEmpty()) {
                boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Validate Dependent Resources", (Object)new DefaultIgnorableNotificationSource((Object)this));
                boolean succeeded = false;
                try {
                    try {
                        ModelBuildUtil.validateResources((IProgressMonitor)theMontitor, (Collection)modelIResources, (Container)this.doGetContainer(), (boolean)false);
                        succeeded = true;
                    }
                    catch (Exception err) {
                        String msg = Util.getString("DeleteResourceAction.validateDependentResources", new Object[0]);
                        this.getPluginUtils().log(4, (Throwable)err, msg);
                        if (!started) break block10;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                            break block10;
                        }
                        ModelerCore.rollbackTxn();
                    }
                }
                finally {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    private boolean warnUserAboutDependants(Collection dependentResources) {
        String title = Util.getString("DeleteResourceAction.confirmDependenciesTitle", new Object[0]);
        String msg = Util.getString("DeleteResourceAction.confirmDependenciesMessage", new Object[0]);
        ArrayList<IPath> resourceList = new ArrayList<IPath>(dependentResources.size());
        Iterator iter = dependentResources.iterator();
        while (iter.hasNext()) {
            IPath shortPath = ((IResource)iter.next()).getFullPath().makeRelative();
            resourceList.add(shortPath);
        }
        return ListMessageDialog.openWarningQuestion((Shell)this.getShell(), (String)title, null, (String)msg, resourceList, null);
    }

    private class DeleteFinishedJobListener
    extends JobChangeAdapter {
        private final CountDownLatch latch;
        Collection deletedModelPaths;

        public DeleteFinishedJobListener(CountDownLatch latch, Collection deletedModelPaths) {
            this.latch = latch;
            this.deletedModelPaths = new ArrayList(deletedModelPaths);
        }

        public void done(IJobChangeEvent event) {
            this.latch.countDown();
            if (this.latch.getCount() == 0L) {
                for (Object path : this.deletedModelPaths) {
                    DeleteAction.this.notifyDeleted((IPath)path);
                }
            }
        }
    }
}

