/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.teiid.designer.core.refactor.RefactorCommand;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ModelObjectAction;
import org.teiid.designer.ui.actions.TransactionSettings;
import org.teiid.designer.ui.actions.workers.DeleteWorker;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.refactor.RefactorCommandProcessorDialog;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DeleteEObjectAction
extends ModelObjectAction {
    private DeleteWorker worker;
    private static final String CANNOT_UNDO_TITLE = "DeleteAction.cannotUndoTitle";
    private static final String CANNOT_UNDO_MSG = "DeleteAction.cannotUndoMsg";
    private static final String READ_ONLY_DEPENDENCIES_TITLE = "DeleteAction.readOnlyDependenciesTitle";
    private static final String READ_ONLY_DEPENDENCIES_MSG = "DeleteAction.readOnlyDependenciesMsg";
    private static final String MODIFY_DEPENDENCIES_TITLE = "DeleteAction.modifyDependenciesTitle";
    private static final String MODIFY_DEPENDENCIES_MSG = "DeleteAction.modifyDependenciesMsg";
    private static final String FIND_RESOURCE_ERROR_MSG = "DeleteAction.findResourceErrorMsg";

    public DeleteEObjectAction() {
        super(UiPlugin.getDefault());
        ISharedImages imgs = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(imgs.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.worker = new DeleteWorker(true);
        this.setActionWorker(this.worker);
    }

    @Override
    public void doRun() {
        this.worker.createObjectDeleteCommand();
        boolean bContinue = UiUtil.saveDirtyEditors(null, (ISaveableFilter)this.getResourcesFilter(), (boolean)true);
        if (bContinue) {
            super.doRun();
            if (this.worker.getObjectDeleteCommand().getPostExecuteMessages() != null && this.worker.getObjectDeleteCommand().getPostExecuteMessages().size() > 0) {
                RefactorCommandProcessorDialog rcpdDialog = new RefactorCommandProcessorDialog(this.getShell(), (RefactorCommand)this.worker.getObjectDeleteCommand());
                rcpdDialog.open();
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)UiConstants.Util.getString("DeleteAction.operationCanceledDialogTitle", new Object[0]), (String)UiConstants.Util.getString("DeleteAction.operationCanceledDialogMessage", new Object[0]));
        }
    }

    private Shell getShell() {
        return UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }

    private ISaveableFilter getResourcesFilter() {
        final HashSet<ModelResource> ignoredResources = new HashSet<ModelResource>();
        ignoredResources.addAll(this.worker.getObjectDeleteCommand().getDependentResources());
        ModelResource mrTemp = null;
        for (EObject modelObject : this.worker.getSelectedEObjects()) {
            mrTemp = ModelUtilities.getModelResourceForModelObject(modelObject);
            if (ignoredResources.contains(mrTemp)) continue;
            ignoredResources.add(mrTemp);
        }
        ISaveableFilter filter = new ISaveableFilter(){

            public boolean select(Saveable saveable, IWorkbenchPart[] containingParts) {
                ModelResource model;
                IEditorInput input;
                if (containingParts != null && containingParts.length != 0 && containingParts[0] instanceof IEditorPart && (input = ((IEditorPart)containingParts[0]).getEditorInput()) instanceof IFileEditorInput && (model = ModelUtilities.getModelResourceForIFile(((IFileEditorInput)input).getFile(), false)) != null) {
                    return !ignoredResources.contains(model);
                }
                return false;
            }
        };
        return filter;
    }

    @Override
    protected boolean preRun() {
        this.worker.setSelectedObjects();
        if (!this.resourceDependencyCheckOK()) {
            return false;
        }
        TransactionSettings ts = this.getTransactionSettings();
        this.worker.setTransactionSettings(ts);
        this.worker.initTransactionSettings();
        if (!ts.isUndoable()) {
            String sTitle = UiConstants.Util.getString(CANNOT_UNDO_TITLE, new Object[0]);
            String sMsg = UiConstants.Util.getString(CANNOT_UNDO_MSG, new Object[0]);
            boolean bDoAnyway = MessageDialog.openQuestion((Shell)this.getShell(), (String)sTitle, (String)sMsg);
            if (!bDoAnyway) {
                return false;
            }
        }
        if (this.requiresEditorForRun()) {
            boolean okToContinue = false;
            try {
                okToContinue = this.openEditorsForDependentModels();
            }
            catch (ModelWorkspaceException theException) {
                UiConstants.Util.log(4, theException.getMessage());
            }
            if (!okToContinue) {
                return false;
            }
            IWorkbenchPart activePart = null;
            Object cachedSelection = this.worker.getSelection();
            if (this.worker.getFocusedObject() != null) {
                if (!ModelEditorManager.isOpen(this.worker.getFocusedObject())) {
                    activePart = UiPlugin.getDefault().getCurrentWorkbenchWindow().getPartService().getActivePart();
                    if (this.worker.getModelResource() != null) {
                        ModelEditorManager.activate(this.worker.getModelResource(), true);
                    } else {
                        ModelEditorManager.open(this.worker.getFocusedObject(), true);
                    }
                }
            } else if (this.worker.getModelResource() != null) {
                activePart = UiPlugin.getDefault().getCurrentWorkbenchWindow().getPartService().getActivePart();
                ModelEditorManager.activate(this.worker.getModelResource(), true);
            }
            if (activePart != null) {
                activePart.setFocus();
            }
            this.worker.selectionChanged(cachedSelection);
        }
        return true;
    }

    @Override
    protected void postRun() {
        this.worker.selectionChanged(this.getSelection());
        this.worker.setTransactionSettings(null);
        super.postRun();
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }

    private boolean resourceDependencyCheckOK() {
        boolean isOkToDelete = true;
        List<EObject> eObjects = this.worker.getSelectedEObjects();
        ArrayList readOnlyDependencies = new ArrayList(this.getReadOnlyDependentResources(eObjects));
        if (!readOnlyDependencies.isEmpty()) {
            String sTitle = UiConstants.Util.getString(READ_ONLY_DEPENDENCIES_TITLE, new Object[0]);
            String sMsg = UiConstants.Util.getString(READ_ONLY_DEPENDENCIES_MSG, new Object[0]);
            ArrayList<IPath> resourceList = new ArrayList<IPath>(readOnlyDependencies.size());
            Iterator iter = readOnlyDependencies.iterator();
            while (iter.hasNext()) {
                IPath shortPath = ((IResource)iter.next()).getFullPath().makeRelative();
                resourceList.add(shortPath);
            }
            ListMessageDialog.openWarning((Shell)this.getShell(), (String)sTitle, null, (String)sMsg, resourceList, null);
            isOkToDelete = false;
        }
        return isOkToDelete;
    }

    private Collection getReadOnlyDependentResources(List<EObject> eObjects) {
        Collection<IFile> allDependentModelFiles = this.getAllDependentResources(eObjects);
        HashSet<IResource> visitedResources = new HashSet<IResource>();
        HashSet<IResource> readOnlyResources = new HashSet<IResource>();
        for (IResource iResource : allDependentModelFiles) {
            if (ModelUtilities.isVdbFile(iResource) || visitedResources.contains(iResource)) continue;
            visitedResources.add(iResource);
            if (!iResource.getResourceAttributes().isReadOnly()) continue;
            readOnlyResources.add(iResource);
        }
        return readOnlyResources;
    }

    private Collection<IFile> getAllDependentResources(List<EObject> eObjects) {
        HashSet<IResource> resourcesToDelete = new HashSet<IResource>();
        HashSet<IFile> dependentResources = new HashSet<IFile>();
        ModelResource mr = null;
        try {
            for (EObject eObject : eObjects) {
                mr = ModelUtilities.getModelResourceForModelObject(eObject);
                if (mr == null) continue;
                IResource objectResource = mr.getCorrespondingResource();
                resourcesToDelete.add(objectResource);
                Collection dependents = WorkspaceResourceFinderUtil.getResourcesThatUse((IResource)objectResource, (int)0);
                for (IFile dependent : dependents) {
                    if (ModelUtilities.isVdbFile((IResource)dependent)) continue;
                    dependentResources.add(dependent);
                }
            }
        }
        catch (ModelWorkspaceException err) {
            UiConstants.Util.log(4, (Throwable)err, UiConstants.Util.getString(FIND_RESOURCE_ERROR_MSG, mr));
        }
        dependentResources.removeAll(resourcesToDelete);
        return dependentResources;
    }

    private boolean openEditorsForDependentModels() throws ModelWorkspaceException {
        boolean okToDelete = true;
        List<EObject> eObjects = this.worker.getSelectedEObjects();
        Collection<IFile> allDepResources = this.getAllDependentResources(eObjects);
        if (!allDepResources.isEmpty()) {
            String sTitle = UiConstants.Util.getString(MODIFY_DEPENDENCIES_TITLE, new Object[0]);
            String sMsg = UiConstants.Util.getString(MODIFY_DEPENDENCIES_MSG, new Object[0]);
            ArrayList<IPath> resourceList = new ArrayList<IPath>(allDepResources.size());
            Iterator<IFile> iter = allDepResources.iterator();
            while (iter.hasNext()) {
                IPath shortPath = ((IResource)iter.next()).getFullPath().makeRelative();
                resourceList.add(shortPath);
            }
            okToDelete = ListMessageDialog.openWarningQuestion((Shell)this.getShell(), (String)sTitle, null, (String)sMsg, resourceList, null);
            if (okToDelete) {
                for (IFile nextRes : allDepResources) {
                    if (ModelEditorManager.isOpen(nextRes)) continue;
                    ModelEditorManager.activate(nextRes, true);
                }
            }
        }
        if (okToDelete) {
            ModelResource mr2 = null;
            HashSet<ModelResource> eObjectResources = new HashSet<ModelResource>(eObjects.size());
            for (EObject eObject : eObjects) {
                mr2 = ModelUtilities.getModelResourceForModelObject(eObject);
                eObjectResources.add(mr2);
            }
            for (ModelResource mr2 : eObjectResources) {
                if (mr2 == null || ModelEditorManager.isOpen((IFile)mr2.getCorrespondingResource())) continue;
                ModelEditorManager.activate(mr2, true, true);
            }
        }
        return okToDelete;
    }
}

