/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StructuredSelection;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.actions.IPasteSpecialContributor;
import org.teiid.designer.ui.actions.PasteSpecialAction;
import org.teiid.designer.ui.actions.workers.CloneWorker;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.DiagramHelperManager;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public final class DesignerUiPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!this.isModelProjectObject(receiver)) {
            return false;
        }
        if (Tests.CLONE_ALLOWED.toString().equals(property)) {
            return this.isCloneAllowed(receiver);
        }
        if (Tests.EDITABLE_OBJECT.toString().equals(property)) {
            return this.isEditableObject(receiver);
        }
        if (Tests.MODEL_PROJECT_OBJECT.toString().equals(property)) {
            return this.isModelProjectObject(receiver);
        }
        if (Tests.PASTE_SPECIAL_ALLOWED.toString().equals(property)) {
            return this.isPasteSpecialAllowed(receiver);
        }
        if (Tests.READONLY_MODEL_OBJECT.toString().equals(property)) {
            return this.isReadOnlyModelObject(receiver);
        }
        if (Tests.RENAME_ALLOWED.toString().equals(property)) {
            return this.isRenameAllowed(receiver);
        }
        assert (false) : "Did not test all properties";
        return false;
    }

    private boolean isCloneAllowed(Object receiver) {
        StructuredSelection selection = null;
        if (receiver instanceof List) {
            List items = (List)receiver;
            if (items.isEmpty()) {
                return false;
            }
            selection = new StructuredSelection(items);
        } else {
            selection = new StructuredSelection(receiver);
        }
        CloneWorker cloneWorker = new CloneWorker(true);
        return cloneWorker.selectionChanged(selection);
    }

    private boolean isEditableObject(Object receiver) {
        assert (receiver instanceof EObject) : "Receiver is not an EObject. Check handler's enabledWhen logic in plugin.xml.";
        return ModelEditorManager.canEdit((EObject)receiver);
    }

    private boolean isModelProjectObject(Object receiver) {
        if (receiver instanceof IFile) {
            return ModelUtilities.isModelFile((IResource)((IFile)receiver));
        }
        if (receiver instanceof EObject) {
            return ModelerCore.getModelWorkspace().findModelResource((EObject)receiver) != null;
        }
        return false;
    }

    private boolean isPasteSpecialAllowed(Object receiver) {
        for (IPasteSpecialContributor contributor : PasteSpecialAction.getPasteSpecialContributors()) {
            if (!contributor.canPaste()) continue;
            return true;
        }
        return false;
    }

    private boolean isReadOnlyModelObject(Object receiver) {
        if (receiver instanceof EObject) {
            return ModelObjectUtilities.isReadOnly((EObject)receiver);
        }
        assert (false) : "Receiver is not an EObject. Check handler's enabledWhen logic in plugin.xml";
        return false;
    }

    private boolean isRenameAllowed(Object receiver) {
        assert (receiver instanceof EObject) : "Receiver is not an EObject. Check handler's enabledWhen logic in plugin.xml.";
        EObject eObj = (EObject)receiver;
        if (this.isReadOnlyModelObject(eObj)) {
            return false;
        }
        if (eObj instanceof Diagram) {
            return DiagramHelperManager.canRename((Diagram)eObj);
        }
        if (eObj instanceof ModelImport) {
            return false;
        }
        return ModelerCore.getModelEditor().hasName(eObj);
    }

    private static enum Tests {
        CLONE_ALLOWED,
        EDITABLE_OBJECT,
        MODEL_PROJECT_OBJECT,
        READONLY_MODEL_OBJECT,
        RENAME_ALLOWED,
        PASTE_SPECIAL_ALLOWED;

    }
}

