/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.wizards.GenerateXsdWizard;

public class GenerateXsdSchemaAction
extends ActionDelegate
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private ISelection selection;

    public void selectionChanged(IAction action, ISelection theSelection) {
        this.selection = theSelection;
        action.setEnabled(this.isValidSelection());
    }

    public void run(IAction action) {
        final GenerateXsdWizard wizard = new GenerateXsdWizard();
        wizard.init(UiPlugin.getDefault().getCurrentWorkbenchWindow().getWorkbench(), (IStructuredSelection)this.selection);
        WizardDialog dialog = new WizardDialog(wizard.getShell(), (IWizard)wizard);
        int rc = dialog.open();
        if (rc != 1) {
            MultiStatus result = wizard.getResult();
            int severity = result.getSeverity();
            if (severity == 4) {
                String errTitle = UiConstants.Util.getString("GenerateXsdSchemaAction.errTitle", new Object[0]);
                String err = UiConstants.Util.getString("GenerateXsdSchemaAction.errFinish", new Object[0]);
                ErrorDialog.openError((Shell)wizard.getShell(), (String)errTitle, (String)err, (IStatus)result);
            } else if (severity == 2) {
                String warnTitle = UiConstants.Util.getString("GenerateXsdSchemaAction.warnTitle", new Object[0]);
                String warn = UiConstants.Util.getString("GenerateXsdSchemaAction.warnFinish", new Object[0]);
                ErrorDialog.openError((Shell)wizard.getShell(), (String)warnTitle, (String)warn, (IStatus)result);
            } else {
                final String okTitle = UiConstants.Util.getString("GenerateXsdSchemaAction.successTitle", new Object[0]);
                final String ok = UiConstants.Util.getString("GenerateXsdSchemaAction.successFinish", new Object[0]);
                ArrayList<String> msgs = new ArrayList<String>(result.getChildren().length);
                int i = 0;
                while (i < result.getChildren().length) {
                    msgs.add(result.getChildren()[i].getMessage());
                    ++i;
                }
                final ArrayList<String> messgs = msgs;
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ListMessageDialog.openInformation((Shell)wizard.getShell(), (String)okTitle, null, (String)ok, (List)messgs, null);
                    }
                });
            }
        }
    }

    private boolean isValidSelection() {
        boolean isValid = true;
        if (SelectionUtilities.isEmptySelection((ISelection)this.selection)) {
            isValid = false;
        }
        if (isValid) {
            List objs = SelectionUtilities.getSelectedObjects((ISelection)this.selection);
            Iterator selections = objs.iterator();
            while (selections.hasNext() && isValid) {
                Object next = selections.next();
                if (next instanceof Table) {
                    isValid = true;
                } else if (next instanceof Procedure) {
                    isValid = true;
                } else if (next instanceof IFile) {
                    ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)((IFile)next));
                    if (modelResource != null) {
                        try {
                            isValid = ModelUtilities.isRelationalModel(modelResource);
                        }
                        catch (ModelWorkspaceException err) {
                            UiConstants.Util.log((Throwable)err);
                            isValid = false;
                        }
                    } else {
                        isValid = false;
                    }
                } else {
                    isValid = false;
                }
                if (!isValid) break;
            }
        }
        return isValid;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void init(IViewPart view) {
    }
}

