/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.AbstractModelerAction;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.actions.IActionWorker;
import org.teiid.designer.ui.common.actions.WorkerProblem;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public abstract class ModelObjectAction
extends AbstractModelerAction {
    private IActionWorker actionWorker;

    public ModelObjectAction(AbstractUiPlugin thePlugin) {
        super(thePlugin);
    }

    public ModelObjectAction(AbstractUiPlugin thePlugin, int theStyle) {
        super(thePlugin, theStyle);
    }

    protected void doRun() {
        if (this.actionWorker != null) {
            if (this.actionWorker.execute()) {
                if (this.actionWorker.getEnableAfterExecute()) {
                    this.setEnabled(this.actionWorker.setEnabledState());
                }
            } else if (this.actionWorker.getWorkerProblem() != null) {
                WorkerProblem problem = this.actionWorker.getWorkerProblem();
                Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)problem.getTitle(), (String)problem.getMessage());
            }
        }
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        if (this.actionWorker != null && ModelUtilities.isAllModelProjectMembers(theSelection)) {
            this.setEnabled(this.actionWorker.selectionChanged((Object)theSelection));
        } else if (this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    protected boolean isReadOnly() {
        boolean isreadonly;
        block4: {
            block5: {
                isreadonly = true;
                List allEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
                if (allEObjects.isEmpty()) break block5;
                isreadonly = false;
                Iterator iter = allEObjects.iterator();
                while (iter.hasNext()) {
                    if (!ModelObjectUtilities.isReadOnly((EObject)iter.next())) continue;
                    isreadonly = true;
                    break block4;
                }
                break block4;
            }
            List selectedObjs = SelectionUtilities.getSelectedObjects((ISelection)this.getSelection());
            if (selectedObjs.isEmpty()) break block4;
            isreadonly = false;
            int size = selectedObjs.size();
            int i = 0;
            while (i < size) {
                Object obj = selectedObjs.get(i);
                if (obj instanceof IResource && ModelUtil.isIResourceReadOnly((IResource)((IResource)obj))) {
                    isreadonly = true;
                    break;
                }
                if (!(obj instanceof IResource)) {
                    isreadonly = true;
                    break;
                }
                ++i;
            }
        }
        return isreadonly;
    }

    protected boolean areEObjectsSelected() {
        return !SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()).isEmpty();
    }

    protected boolean isEObjectSelected() {
        ISelection sel = this.getSelection();
        return SelectionUtilities.isSingleSelection((ISelection)sel) && SelectionUtilities.getSelectedEObject((ISelection)sel) != null;
    }

    protected abstract boolean requiresEditorForRun();

    @Override
    protected boolean preRun() {
        EObject eObject;
        ModelResource mr;
        List allSelectedEObjects;
        if (this.requiresEditorForRun() && (allSelectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection())) != null && !allSelectedEObjects.isEmpty() && (mr = ModelUtilities.getModelResourceForModelObject(eObject = (EObject)allSelectedEObjects.get(0))) != null) {
            ModelEditorManager.activate(mr, true, true);
        }
        return true;
    }

    protected boolean canLegallyEditResource() {
        boolean canEdit = false;
        List allEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
        if (allEObjects != null && !allEObjects.isEmpty()) {
            canEdit = true;
        } else {
            List selectedObjs = SelectionUtilities.getSelectedObjects((ISelection)this.getSelection());
            if (!selectedObjs.isEmpty()) {
                canEdit = true;
                int size = selectedObjs.size();
                int i = 0;
                while (i < size) {
                    block8: {
                        Object obj = selectedObjs.get(i);
                        if (obj instanceof IResource && ModelUtilities.isModelFile((IResource)obj)) {
                            try {
                                if (ModelUtil.getModelResource((IFile)((IFile)obj), (boolean)false) == null) {
                                    canEdit = false;
                                }
                                break block8;
                            }
                            catch (ModelWorkspaceException theException) {
                                canEdit = false;
                                this.getPluginUtils().log((Throwable)theException);
                            }
                            break;
                        }
                        canEdit = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        return canEdit;
    }

    public IActionWorker getActionWorker() {
        return this.actionWorker;
    }

    public void setActionWorker(IActionWorker actionWorker) {
        this.actionWorker = actionWorker;
    }
}

