/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.util.ModelStatisticsVisitor;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.util.PrimaryMetamodelStatisticsVisitor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.viewsupport.ModelStatisticsDialog;

public class ModelStatisticsReporter {
    private IFile modelFile;

    public ModelStatisticsReporter(IFile iFile) {
        this.modelFile = iFile;
    }

    public void show() {
        PrimaryMetamodelStatisticsVisitor visitor = new PrimaryMetamodelStatisticsVisitor();
        ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)visitor, 1);
        Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
        try {
            ModelResource resource = ModelUtil.getModelResource((IFile)this.modelFile, (boolean)true);
            if (resource != null) {
                processor.walk(resource, 2);
                ModelStatisticsDialog dialog = new ModelStatisticsDialog(shell, (ModelStatisticsVisitor)visitor, resource);
                dialog.open();
            }
        }
        catch (Exception e) {
            UiConstants.Util.log((Throwable)e);
            String title = UiConstants.Util.getString("ModelStatisticsAction.errorTitle", new Object[0]);
            String message = UiConstants.Util.getString("ModelStatisticsAction.errorMessage", new Object[0]);
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }
}

