/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.PluginUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.association.AssociationDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.jdbc.JdbcImportSettings;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.BookmarkAction;
import org.teiid.designer.ui.actions.CopyAction;
import org.teiid.designer.ui.actions.CopyFullNameAction;
import org.teiid.designer.ui.actions.CopyNameAction;
import org.teiid.designer.ui.actions.CutAction;
import org.teiid.designer.ui.actions.DeleteAction;
import org.teiid.designer.ui.actions.FindAction;
import org.teiid.designer.ui.actions.IModelObjectActionContributor;
import org.teiid.designer.ui.actions.IModelerActionConstants;
import org.teiid.designer.ui.actions.IModelerRcpActionIds;
import org.teiid.designer.ui.actions.INewChildAction;
import org.teiid.designer.ui.actions.INewSiblingAction;
import org.teiid.designer.ui.actions.ModelResourceActionManager;
import org.teiid.designer.ui.actions.ModelerActionBarIdManager;
import org.teiid.designer.ui.actions.ModelerGlobalActionsMap;
import org.teiid.designer.ui.actions.ModelerSpecialActionManager;
import org.teiid.designer.ui.actions.NewAssociationAction;
import org.teiid.designer.ui.actions.NewChildAction;
import org.teiid.designer.ui.actions.NewSiblingAction;
import org.teiid.designer.ui.actions.PasteAction;
import org.teiid.designer.ui.actions.PrintAction;
import org.teiid.designer.ui.actions.RenameAction;
import org.teiid.designer.ui.actions.SelectAllAction;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.actions.AbstractActionService;
import org.teiid.designer.ui.common.actions.GlobalActionsMap;
import org.teiid.designer.ui.common.actions.IActionConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.IEditorActionExporter;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.MultiPageModelEditor;
import org.teiid.designer.ui.product.IModelerProductContexts;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public final class ModelerActionService
extends AbstractActionService
implements IModelerActionConstants,
UiConstants.ExtensionPoints.ModelObjectActionContributor,
IModelerRcpActionIds,
IModelerProductContexts {
    public static final String PREFIX = "ModelerActionService.";
    public static final String MODELING_LABEL = UiConstants.Util.getString("ModelerSpecialActionManager.specialLabel", new Object[0]);
    private static final List ECLIPSE_GLOBAL_ACTION_IDS = Arrays.asList(IActionConstants.EclipseGlobalActions.ALL_ACTIONS);
    private static final List MAPPED_ACTION_IDS;
    private List modelObjectContributors;
    private ModelerGlobalActionsMap defaultActionsMap;
    private PluginUtil utils;
    private INewChildAction[] newChildExtensions;
    private INewSiblingAction[] newSiblingExtensions;

    static {
        String[] ACTION_CLASSES = new String[]{CutAction.class.getName(), CopyAction.class.getName(), PasteAction.class.getName(), PrintAction.class.getName(), DeleteAction.class.getName(), FindAction.class.getName(), SelectAllAction.class.getName(), BookmarkAction.class.getName(), RenameAction.class.getName()};
        MAPPED_ACTION_IDS = Arrays.asList(ACTION_CLASSES);
    }

    public ModelerActionService(IWorkbenchPage page) {
        this(UiPlugin.getDefault(), UiPlugin.getDefault().getPluginUtil(), page);
    }

    public ModelerActionService(AbstractUiPlugin plugin, PluginUtil utility, IWorkbenchPage page) {
        super(plugin, page);
        this.utils = utility;
        ModelerSpecialActionManager.wireActionsForSelection(this);
    }

    public void addNotifyChangedListener(INotifyChangedListener theListener) {
        ModelUtilities.addNotifyChangedListener(theListener);
    }

    public void contributePermanentActionsToContextMenu(IMenuManager theMenuMgr, ISelection theSelection) {
        List contributors = this.getModelObjectActionContributors();
        int size = contributors.size();
        int i = 0;
        while (i < size) {
            IModelObjectActionContributor contributor = (IModelObjectActionContributor)this.modelObjectContributors.get(i);
            contributor.contributeToContextMenu(theMenuMgr, theSelection);
            ++i;
        }
    }

    public void contributeToContextMenu(IMenuManager theMenuMgr, GlobalActionsMap theActionsMap, ISelection theSelection) {
        GlobalActionsMap actionsMap = theActionsMap == null ? new ModelerGlobalActionsMap() : theActionsMap;
        theMenuMgr.add((IContributionItem)new GroupMarker("insertStart"));
        theMenuMgr.add((IContributionItem)this.getInsertChildMenu(theSelection));
        theMenuMgr.add((IContributionItem)this.getInsertSiblingMenu(theSelection));
        theMenuMgr.add((IContributionItem)this.getCreateAssociationMenu(theSelection));
        MenuManager modelingActionMenu = this.getModelingActionMenu(theSelection);
        if (modelingActionMenu != null && modelingActionMenu.getItems().length > 0) {
            theMenuMgr.add((IContributionItem)modelingActionMenu);
        }
        theMenuMgr.add((IContributionItem)new GroupMarker("insertEnd"));
        theMenuMgr.add((IContributionItem)new Separator());
        theMenuMgr.add((IContributionItem)new GroupMarker("cutStart"));
        theMenuMgr.add(this.getAction(IActionConstants.EclipseGlobalActions.CUT, actionsMap));
        theMenuMgr.add(this.getAction(IActionConstants.EclipseGlobalActions.COPY, actionsMap));
        theMenuMgr.add(this.getAction(IActionConstants.EclipseGlobalActions.PASTE, actionsMap));
        theMenuMgr.add(this.getAction(IModelerActionConstants.ModelerGlobalActions.CLONE, actionsMap));
        MenuManager copyNameMenu = this.getCopyNameSubMenu(theSelection);
        if (!copyNameMenu.isEmpty()) {
            theMenuMgr.add((IContributionItem)copyNameMenu);
        }
        theMenuMgr.add((IContributionItem)new GroupMarker("cutEnd"));
        theMenuMgr.add((IContributionItem)new Separator());
        theMenuMgr.add((IContributionItem)new GroupMarker("deleteStart"));
        theMenuMgr.add(this.getAction(IActionConstants.EclipseGlobalActions.DELETE, actionsMap));
        theMenuMgr.add(this.getAction(IActionConstants.EclipseGlobalActions.RENAME, actionsMap));
        theMenuMgr.add((IContributionItem)new GroupMarker("deleteEnd"));
        theMenuMgr.add((IContributionItem)new Separator());
        theMenuMgr.add((IContributionItem)new GroupMarker("openStart"));
        theMenuMgr.add(this.getAction(IModelerActionConstants.ModelerGlobalActions.OPEN, actionsMap));
        theMenuMgr.add(this.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT, actionsMap));
        theMenuMgr.add((IContributionItem)new GroupMarker("openEnd"));
        theMenuMgr.add((IContributionItem)new Separator());
        this.contributePermanentActionsToContextMenu(theMenuMgr, theSelection);
        theMenuMgr.add((IContributionItem)new Separator("additions"));
    }

    public IMenuManager getEditMenu() {
        IMenuManager menuMgr = this.getActionBars().getMenuManager();
        return menuMgr.findMenuUsingPath(ModelerActionBarIdManager.getEditMenuId());
    }

    public IMenuManager getValidateMenu() {
        IMenuManager menuMgr = this.getActionBars().getMenuManager();
        return menuMgr.findMenuUsingPath(ModelerActionBarIdManager.getValidateMenuId());
    }

    public IMenuManager getFileMenu() {
        IMenuManager menuMgr = this.getActionBars().getMenuManager();
        return menuMgr.findMenuUsingPath(ModelerActionBarIdManager.getFileMenuId());
    }

    private boolean failedInsertChildPreconditions(ISelection theSelection) {
        boolean result;
        boolean bl = result = theSelection == null || theSelection.isEmpty() || SelectionUtilities.isMultiSelection((ISelection)theSelection);
        if (!result) {
            Object obj = SelectionUtilities.getSelectedObject((ISelection)theSelection);
            if (obj instanceof ItemProvider) {
                obj = ((ItemProvider)obj).getParent();
            }
            if (obj instanceof IResource && ModelUtilities.isModelFile((IResource)obj)) {
                result = false;
            } else if (obj instanceof Diagram) {
                result = true;
            } else if (obj instanceof EObject) {
                result = false;
                if (obj instanceof ModelImport || obj instanceof JdbcSource || obj instanceof JdbcImportSettings) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    private boolean failedInsertSiblingPreconditions(ISelection theSelection) {
        EObject eObj;
        boolean failed = false;
        boolean bl = failed = theSelection == null || theSelection.isEmpty();
        if (!failed) {
            if (SelectionUtilities.isMultiSelection((ISelection)theSelection)) {
                failed = !SelectionUtilities.isAllEObjects((ISelection)theSelection) || !ModelObjectUtilities.shareCommonParent(SelectionUtilities.getSelectedEObjects((ISelection)theSelection));
            } else {
                boolean bl2 = failed = SelectionUtilities.getSelectedEObject((ISelection)theSelection) == null;
            }
        }
        if (!failed && (eObj = SelectionUtilities.getSelectedEObject((ISelection)theSelection)) != null) {
            if (eObj instanceof Diagram) {
                Diagram diagram = (Diagram)SelectionUtilities.getSelectedEObject((ISelection)theSelection);
                EObject target = diagram.getTarget();
                if (target == null || target instanceof ModelAnnotation) {
                    failed = true;
                }
            } else if (eObj instanceof ModelImport || eObj instanceof JdbcSource || eObj instanceof JdbcImportSettings) {
                failed = true;
            }
        }
        return failed;
    }

    private boolean failedCreateAssociationPreconditions(ISelection theSelection) {
        boolean result;
        boolean bl = result = theSelection == null || theSelection.isEmpty() || SelectionUtilities.isSingleSelection((ISelection)theSelection);
        if (!result) {
            List objects = SelectionUtilities.getSelectedObjects((ISelection)theSelection);
            for (Object obj : objects) {
                if (obj instanceof IResource && !ModelUtilities.isModelFile((IResource)obj)) {
                    result = true;
                    break;
                }
                if (obj instanceof Diagram) {
                    result = true;
                    continue;
                }
                if (obj instanceof EObject) {
                    result = false;
                    continue;
                }
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean failedRefactorPreconditions(ISelection theSelection) {
        if (theSelection == null || theSelection.isEmpty()) {
            return true;
        }
        List resourceObjects = SelectionUtilities.getSelectedIResourceObjects((ISelection)theSelection);
        IProject project = null;
        for (Object obj : resourceObjects) {
            if (!(obj instanceof IResource)) {
                return true;
            }
            IResource resource = (IResource)obj;
            if (project == null) {
                project = resource.getProject();
                continue;
            }
            if (project.equals((Object)resource.getProject())) continue;
            return true;
        }
        return false;
    }

    public IAction getAction(String theActionId) throws CoreException {
        return super.getAction(this.getActionId(theActionId));
    }

    public String getActionId(String theKey) {
        String result = theKey;
        if (GlobalActionsMap.isEclipseGlobalAction((String)theKey)) {
            int index = ECLIPSE_GLOBAL_ACTION_IDS.indexOf(theKey);
            result = (String)MAPPED_ACTION_IDS.get(index);
        }
        return result;
    }

    public IAction getDefaultAction(String theActionId) {
        return this.defaultActionsMap.getAction(theActionId);
    }

    public MenuManager getInsertChildMenu(ISelection theSelection) {
        MenuManager menu;
        block21: {
            menu = new MenuManager(this.utils.getString("ModelerActionService.NewChildMenu.title", new Object[0]), ModelerActionBarIdManager.getInsertChildMenuId());
            if (this.failedInsertChildPreconditions(theSelection)) {
                menu.add((IAction)new NewChildAction());
            } else {
                Object obj = SelectionUtilities.getSelectedObject((ISelection)theSelection);
                try {
                    Collection descriptors = null;
                    if (obj instanceof ItemProvider) {
                        obj = ((ItemProvider)obj).getParent();
                    }
                    if (obj instanceof EObject) {
                        boolean isReadOnly = ModelObjectUtilities.isReadOnly((EObject)obj);
                        descriptors = ModelerCore.getModelEditor().getNewChildCommands((EObject)obj);
                        if (descriptors == null || descriptors.isEmpty()) {
                            menu.add((IAction)new NewChildAction());
                        } else {
                            HashMap<String, NewChildAction> actionMap = new HashMap<String, NewChildAction>();
                            Iterator<Object> iter = descriptors.iterator();
                            while (iter.hasNext()) {
                                NewChildAction action = new NewChildAction((EObject)obj, (Command)iter.next());
                                actionMap.put(action.getText(), action);
                                action.selectionChanged(this.getWorkbenchWindow().getPartService().getActivePart(), theSelection);
                                action.setEnabled(!isReadOnly);
                            }
                            TreeSet set = new TreeSet(actionMap.keySet());
                            iter = set.iterator();
                            while (iter.hasNext()) {
                                menu.add((IAction)actionMap.get(iter.next()));
                            }
                            int i = 0;
                            while (i < this.getNewChildExtensions().length) {
                                INewChildAction action = this.getNewChildExtensions()[i];
                                if (action.canCreateChild((EObject)obj)) {
                                    menu.add((IAction)action);
                                    action.setEnabled(!isReadOnly);
                                }
                                ++i;
                            }
                        }
                        break block21;
                    }
                    if (!(obj instanceof IFile)) break block21;
                    try {
                        ModelResource modelResource = ModelUtil.getModelResource((IFile)((IFile)obj), (boolean)false);
                        if (modelResource != null && !modelResource.hasErrors()) {
                            Resource resource = modelResource.getEmfResource();
                            descriptors = ModelerCore.getModelEditor().getNewRootObjectCommands(resource);
                            boolean isReadOnly = ModelUtil.isIResourceReadOnly((IResource)((IResource)obj));
                            boolean addedExtension = false;
                            HashMap<String, NewChildAction> actionMap = new HashMap<String, NewChildAction>();
                            for (Command nextCommand : descriptors) {
                                if (nextCommand.getLabel().equalsIgnoreCase("schema") || nextCommand.getLabel().equalsIgnoreCase("catalog")) continue;
                                NewChildAction action = new NewChildAction(resource, nextCommand);
                                actionMap.put(action.getText(), action);
                                action.selectionChanged(this.getWorkbenchWindow().getPartService().getActivePart(), theSelection);
                                action.setEnabled(!isReadOnly);
                            }
                            TreeSet set = new TreeSet(actionMap.keySet());
                            Iterator<Object> iter = set.iterator();
                            while (iter.hasNext()) {
                                menu.add((IAction)actionMap.get(iter.next()));
                            }
                            int i = 0;
                            while (i < this.getNewChildExtensions().length) {
                                INewChildAction action = this.getNewChildExtensions()[i];
                                if (i == 0) {
                                    menu.add((IContributionItem)new Separator());
                                }
                                if (action.canCreateChild((IFile)obj)) {
                                    addedExtension = true;
                                    menu.add((IAction)action);
                                    action.setEnabled(!isReadOnly);
                                }
                                ++i;
                            }
                            if (descriptors.isEmpty() && !addedExtension) {
                                menu.add((IAction)new NewChildAction());
                            }
                            break block21;
                        }
                        menu.add((IAction)new NewChildAction());
                    }
                    catch (ModelWorkspaceException theException) {
                        this.utils.log(4, (Throwable)theException, this.utils.getString("ModelerActionService.NewChildMenu.problem", new Object[]{theSelection}));
                    }
                }
                catch (ModelerCoreException theException) {
                    this.utils.log(4, (Throwable)theException, this.utils.getString("ModelerActionService.NewChildMenu.problem", new Object[]{theSelection}));
                }
            }
        }
        return menu;
    }

    public MenuManager getInsertSiblingMenu(ISelection theSelection) {
        MenuManager menu = new MenuManager(this.utils.getString("ModelerActionService.NewSiblingMenu.title", new Object[0]), ModelerActionBarIdManager.getInsertSiblingMenuId());
        if (this.failedInsertSiblingPreconditions(theSelection)) {
            menu.add((IAction)new NewSiblingAction());
        } else {
            List eObjects = SelectionUtilities.getSelectedEObjects((ISelection)theSelection);
            EObject eObj = (EObject)eObjects.get(0);
            if (eObj instanceof Diagram) {
                eObj = ((Diagram)eObj).getTarget();
            }
            boolean isReadOnly = ModelObjectUtilities.isReadOnly(eObj);
            try {
                Collection commands = ModelerCore.getModelEditor().getNewSiblingCommands(eObj);
                boolean addedExtension = false;
                if (commands != null) {
                    HashMap<String, NewSiblingAction> actionMap = new HashMap<String, NewSiblingAction>();
                    for (Command cmd : commands) {
                        NewSiblingAction action = new NewSiblingAction(eObj, cmd);
                        actionMap.put(action.getText(), action);
                        action.selectionChanged(this.getWorkbenchWindow().getPartService().getActivePart(), theSelection);
                        action.setEnabled(!isReadOnly);
                    }
                    TreeSet set = new TreeSet(actionMap.keySet());
                    Iterator<Object> iter = set.iterator();
                    while (iter.hasNext()) {
                        menu.add((IAction)actionMap.get(iter.next()));
                    }
                }
                int i = 0;
                while (i < this.getNewSiblingExtensions().length) {
                    INewSiblingAction action = this.getNewSiblingExtensions()[i];
                    if (action.canCreateSibling(eObj)) {
                        if (i == 0) {
                            menu.add((IContributionItem)new Separator());
                        }
                        menu.add((IAction)action);
                        addedExtension = true;
                        action.setEnabled(!isReadOnly);
                    }
                    ++i;
                }
                if (commands.isEmpty() && !addedExtension) {
                    menu.add((IAction)new NewSiblingAction());
                }
            }
            catch (ModelerCoreException theException) {
                this.utils.log(4, (Throwable)theException, this.utils.getString("ModelerActionService.NewSiblingMenu.problem", new Object[]{theSelection}));
            }
        }
        return menu;
    }

    public MenuManager getCreateAssociationMenu(ISelection theSelection) {
        MenuManager menu;
        block9: {
            menu = new MenuManager(this.utils.getString("ModelerActionService.NewAssociationMenu.title", new Object[0]), ModelerActionBarIdManager.getInsertAssociationMenuId());
            if (this.failedCreateAssociationPreconditions(theSelection)) {
                menu.add((IAction)new NewAssociationAction());
            } else {
                try {
                    List selectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)theSelection);
                    Collection descriptors = ModelerCore.getModelEditor().getNewAssociationDescriptors(selectedEObjects);
                    if (descriptors != null && !descriptors.isEmpty()) {
                        boolean isReadOnly = false;
                        Iterator iter = selectedEObjects.iterator();
                        while (iter.hasNext()) {
                            if (!ModelObjectUtilities.isReadOnly((EObject)iter.next())) continue;
                            isReadOnly = true;
                            break;
                        }
                        int index = 0;
                        for (AssociationDescriptor ad : descriptors) {
                            if (ad.isAmbiguous()) {
                                MenuManager submenu = new MenuManager(ad.getText());
                                String groupName = "associationSubmenuGroup" + index++;
                                menu.insert(0, (IContributionItem)new GroupMarker(groupName));
                                menu.appendToGroup(groupName, (IContributionItem)submenu);
                                AssociationDescriptor[] children = ad.getChildren();
                                int i = 0;
                                while (i < children.length) {
                                    NewAssociationAction action = new NewAssociationAction(children[i]);
                                    submenu.add((IAction)action);
                                    action.selectionChanged(this.getWorkbenchWindow().getPartService().getActivePart(), theSelection);
                                    ++i;
                                }
                                continue;
                            }
                            NewAssociationAction action = new NewAssociationAction(ad);
                            menu.add((IAction)action);
                            action.setEnabled(!isReadOnly);
                        }
                        break block9;
                    }
                    menu.add((IAction)new NewAssociationAction());
                }
                catch (ModelerCoreException theException) {
                    this.utils.log(4, (Throwable)theException, this.utils.getString("ModelerActionService.NewAssociationMenu.problem", new Object[]{theSelection}));
                }
            }
        }
        return menu;
    }

    private List getExportedActions(ISelection selection) {
        List<IAction> newActions;
        ModelObjectEditorPage moep;
        List<IAction> newActions2;
        ArrayList<IAction> expActions = new ArrayList<IAction>();
        IEditorPart editor = this.getWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof IEditorActionExporter && !(newActions2 = ((IEditorActionExporter)editor).getAdditionalModelingActions(selection)).isEmpty()) {
            expActions.addAll(newActions2);
        }
        if (editor instanceof MultiPageModelEditor && (moep = ((MultiPageModelEditor)editor).getActiveObjectEditor()) != null && !(newActions = moep.getAdditionalModelingActions(selection)).isEmpty()) {
            expActions.addAll(newActions);
        }
        return expActions;
    }

    public MenuManager getModelingActionMenu(ISelection theSelection) {
        List exportedActions;
        MenuManager menu = new MenuManager(MODELING_LABEL, ModelerActionBarIdManager.getModelingMenuId());
        MenuManager mosaMenu = ModelerSpecialActionManager.getModeObjectSpecialActionMenu(theSelection);
        if (mosaMenu != null && mosaMenu.getItems().length > 0) {
            IContributionItem[] items = mosaMenu.getItems();
            int i = 0;
            while (i < items.length) {
                menu.add(mosaMenu.getItems()[i]);
                ++i;
            }
            menu.add((IContributionItem)new Separator());
        }
        if (!(exportedActions = this.getExportedActions(theSelection)).isEmpty()) {
            int j = 0;
            while (j < exportedActions.size()) {
                Object nextItem = exportedActions.get(j);
                if (nextItem instanceof IAction) {
                    menu.add((IAction)nextItem);
                } else if (nextItem instanceof ActionContributionItem) {
                    menu.add((IContributionItem)((ActionContributionItem)nextItem));
                }
                ++j;
            }
            menu.add((IContributionItem)new Separator());
        }
        boolean foundModelActions = false;
        MenuManager mraMenu = ModelResourceActionManager.getModelResourceActionMenu(theSelection);
        if (mraMenu != null && mraMenu.getItems().length > 0) {
            IContributionItem[] items = mraMenu.getItems();
            int i = 0;
            while (i < items.length) {
                menu.add(mraMenu.getItems()[i]);
                foundModelActions = true;
                ++i;
            }
        }
        if (foundModelActions) {
            menu.add((IContributionItem)new Separator());
        }
        List contributors = this.getModelObjectActionContributors();
        boolean addedActions = false;
        int size = contributors.size();
        int i = 0;
        while (i < size) {
            IModelObjectActionContributor contributor = (IModelObjectActionContributor)this.modelObjectContributors.get(i);
            List<IAction> additionalActions = contributor.getAdditionalModelingActions(theSelection);
            if (!additionalActions.isEmpty()) {
                int j = 0;
                while (j < additionalActions.size()) {
                    if (!addedActions) {
                        addedActions = true;
                    }
                    menu.add(additionalActions.get(j));
                    ++j;
                }
            }
            ++i;
        }
        if (addedActions) {
            menu.add((IContributionItem)new Separator());
        }
        if (menu.isEmpty()) {
            menu.add((IAction)new NewChildAction());
        }
        return menu;
    }

    public MenuManager getCopyNameSubMenu(Object selection) {
        MenuManager menu = new MenuManager(this.utils.getString("ModelerActionService.copyNameSubMenu.title", new Object[0]));
        CopyFullNameAction action1 = new CopyFullNameAction();
        action1.getActionWorker().selectionChanged(selection);
        menu.add((IAction)action1);
        CopyNameAction action2 = new CopyNameAction();
        action1.getActionWorker().selectionChanged(selection);
        menu.add((IAction)action2);
        return menu;
    }

    public List getModelObjectActionContributors() {
        if (this.modelObjectContributors == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "modelObjectActionContributor");
            IExtension[] extensions = extensionPoint.getExtensions();
            if (extensions.length > 0) {
                this.modelObjectContributors = new ArrayList(extensions.length);
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    Object extension = null;
                    int j = 0;
                    while (j < elements.length) {
                        try {
                            extension = elements[j].createExecutableExtension("name");
                            if (extension instanceof IModelObjectActionContributor) {
                                this.modelObjectContributors.add(extension);
                            } else {
                                this.utils.log(4, this.utils.getString("ModelerActionService.wrongContributorClass", new Object[]{extension.getClass().getName()}));
                            }
                        }
                        catch (Exception theException) {
                            this.utils.log(4, (Throwable)theException, this.utils.getString("ModelerActionService.contributorProblem", new Object[]{elements[j].getAttribute("name")}));
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                this.modelObjectContributors = Collections.EMPTY_LIST;
            }
        }
        return this.modelObjectContributors;
    }

    public void initializeGlobalActions() {
        this.defaultActionsMap = new ModelerGlobalActionsMap();
        int i = 0;
        while (i < ModelerGlobalActionsMap.ALL_GLOBAL_ACTIONS.length) {
            String actionId = ModelerGlobalActionsMap.ALL_GLOBAL_ACTIONS[i];
            try {
                IAction action = this.getAction(actionId);
                this.defaultActionsMap.put(actionId, action);
            }
            catch (CoreException e) {
                String message = UiConstants.Util.getString("ModelerActionService.getActionErrorMessage", (Object)actionId);
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
    }

    protected void registerEventHandler(IAction theAction) {
        super.registerEventHandler(theAction);
        if (theAction instanceof INotifyChangedListener) {
            this.addNotifyChangedListener((INotifyChangedListener)theAction);
        }
    }

    public void registerDefaultGlobalActions(IActionBars bars) {
        for (Map.Entry entry : this.defaultActionsMap.entrySet()) {
            bars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
        }
    }

    public void removeNotifyChangedListener(INotifyChangedListener theListener) {
        ModelUtilities.removeNotifyChangedListener(theListener);
    }

    protected void unregisterEventHandler(IAction theAction) {
        super.unregisterEventHandler(theAction);
        if (theAction instanceof INotifyChangedListener) {
            this.removeNotifyChangedListener((INotifyChangedListener)theAction);
        }
    }

    private INewChildAction[] getNewChildExtensions() {
        if (this.newChildExtensions == null) {
            String id = "newChildAction";
            String classTag = "class";
            String className = "name";
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", id);
            IExtension[] extensions = extensionPoint.getExtensions();
            ArrayList<Object> actionList = new ArrayList<Object>();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                try {
                    int j = 0;
                    while (j < elements.length) {
                        Object action;
                        if (elements[j].getName().equals(classTag) && (action = elements[j].createExecutableExtension(className)) instanceof INewChildAction) {
                            actionList.add(action);
                        }
                        ++j;
                    }
                }
                catch (Exception e) {
                    String message = UiConstants.Util.getString("ModelerActionService.configurationErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                    UiConstants.Util.log(4, (Throwable)e, message);
                }
                ++i;
            }
            this.newChildExtensions = new INewChildAction[actionList.size()];
            i = 0;
            while (i < actionList.size()) {
                this.newChildExtensions[i] = (INewChildAction)actionList.get(i);
                ++i;
            }
        }
        return this.newChildExtensions;
    }

    private INewSiblingAction[] getNewSiblingExtensions() {
        if (this.newSiblingExtensions == null) {
            String id = "newSiblingAction";
            String classTag = "class";
            String className = "name";
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", id);
            IExtension[] extensions = extensionPoint.getExtensions();
            ArrayList<Object> actionList = new ArrayList<Object>();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                try {
                    int j = 0;
                    while (j < elements.length) {
                        Object action;
                        if (elements[j].getName().equals(classTag) && (action = elements[j].createExecutableExtension(className)) instanceof INewSiblingAction) {
                            actionList.add(action);
                        }
                        ++j;
                    }
                }
                catch (Exception e) {
                    String message = UiConstants.Util.getString("ModelerActionService.configurationErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                    UiConstants.Util.log(4, (Throwable)e, message);
                }
                ++i;
            }
            this.newSiblingExtensions = new INewSiblingAction[actionList.size()];
            i = 0;
            while (i < actionList.size()) {
                this.newSiblingExtensions[i] = (INewSiblingAction)actionList.get(i);
                ++i;
            }
        }
        return this.newSiblingExtensions;
    }
}

