/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ISelectionAction;
import org.teiid.designer.ui.actions.ModelerActionBarIdManager;
import org.teiid.designer.ui.actions.ModelerActionService;
import org.teiid.designer.ui.actions.SortableSelectionAction;
import org.teiid.designer.ui.product.IModelerProductContexts;

public abstract class ModelerSpecialActionManager {
    public static final String SPECIAL_LABEL = UiConstants.Util.getString("ModelerSpecialActionManager.specialLabel", new Object[0]);
    private static Collection actions;
    private static boolean actionsLoaded;

    static {
        actionsLoaded = false;
    }

    public static Collection getActions(Object selection) {
        if (!actionsLoaded) {
            ModelerSpecialActionManager.loadExtensions();
        }
        return actions;
    }

    private static void loadExtensions() {
        HashMap<String, Object> actionExtList = new HashMap<String, Object>();
        actionsLoaded = true;
        String id = "modelObjectSpecialAction";
        String actionTag = "specialAction";
        String className = "name";
        String labelTag = "label";
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", id);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                int j = 0;
                while (j < elements.length) {
                    if (elements[j].getName().equals(actionTag)) {
                        Object helper = elements[j].createExecutableExtension(className);
                        String actionID = elements[j].getAttribute(className);
                        String label = elements[j].getAttribute(labelTag);
                        ((Action)helper).setId(actionID);
                        if (label != null) {
                            ((Action)helper).setText(label);
                        }
                        actionExtList.put(elements[j].getAttribute(className), helper);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("ModelerSpecialActionManager.loadingExtensionsErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
        Object[] actionsArray = actionExtList.values().toArray();
        Arrays.sort(actionsArray);
        actions = new ArrayList(actionsArray.length);
        Set keys = actionExtList.keySet();
        int i2 = 0;
        while (i2 < actionsArray.length) {
            Object key2 = null;
            for (Object key2 : keys) {
                if (actionExtList.get(key2) != actionsArray[i2]) continue;
                actions.add(actionsArray[i2]);
                break;
            }
            ++i2;
        }
    }

    public static MenuManager getModeObjectSpecialActionMenu(ISelection theSelection) {
        MenuManager menu = new MenuManager(SPECIAL_LABEL, ModelerActionBarIdManager.getModelingMenuId());
        Collection modelResourceActions = ModelerSpecialActionManager.getActions(theSelection);
        Iterator iter = modelResourceActions.iterator();
        Action nextAction = null;
        while (iter.hasNext()) {
            nextAction = (Action)iter.next();
            if (!UiPlugin.getDefault().isProductContextValueSupported(IModelerProductContexts.Actions.MODEL_OBJECT_SPECIAL_ACTION_GROUP, nextAction.getClass().getName())) continue;
            if (nextAction instanceof ISelectionAction) {
                if (!((ISelectionAction)nextAction).isApplicable(theSelection)) continue;
                if (nextAction instanceof ISelectionListener) {
                    ((ISelectionListener)nextAction).selectionChanged(null, theSelection);
                }
                menu.add((IAction)nextAction);
                continue;
            }
            if (nextAction instanceof ISelectionListener) {
                ((ISelectionListener)nextAction).selectionChanged(null, theSelection);
            }
            menu.add((IAction)nextAction);
        }
        return menu;
    }

    public static void wireActionsForSelection(ModelerActionService service) {
        Collection specialActions = ModelerSpecialActionManager.getActions(null);
        Iterator iter = specialActions.iterator();
        Action nextAction = null;
        while (iter.hasNext()) {
            nextAction = (Action)iter.next();
            if (!(nextAction instanceof SortableSelectionAction) || !((SortableSelectionAction)nextAction).doWireForSelection()) continue;
            service.addWorkbenchSelectionListener((SortableSelectionAction)nextAction);
        }
    }

    public static SortableSelectionAction getAction(String actionId) {
        Collection specialActions = ModelerSpecialActionManager.getActions(null);
        Iterator iter = specialActions.iterator();
        Action nextAction = null;
        while (iter.hasNext()) {
            nextAction = (Action)iter.next();
            if (!(nextAction instanceof SortableSelectionAction) || nextAction.getId() == null || !nextAction.getId().equals(actionId)) continue;
            return (SortableSelectionAction)nextAction;
        }
        return null;
    }
}

