/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.actions.ActionDelegate;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ImportContainer;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class OrganizeImportsAction
extends ActionDelegate {
    private Resource resource;

    public void run(IAction action) {
        ModelResource modelResource = ModelerCore.getModelEditor().findModelResource(this.resource);
        if (modelResource != null) {
            try {
                ModelBuildUtil.rebuildImports((Resource)modelResource.getEmfResource(), (boolean)true);
            }
            catch (ModelWorkspaceException theException) {
                UiConstants.Util.log(4, (Throwable)theException, theException.getMessage());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        Object o = SelectionUtilities.getSelectedObject((ISelection)selection);
        if (o instanceof ImportContainer) {
            this.resource = ((ImportContainer)o).getResource();
            ModelResource mResource = ModelUtilities.getModelResource(this.resource, false);
            enable = !mResource.isReadOnly();
        }
        action.setEnabled(enable);
        action.setText(UiConstants.Util.getString("OrganizeImportsAction.label", new Object[0]));
    }
}

