/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.IRefreshContributor;
import org.teiid.designer.ui.actions.RefreshDescriptor;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class RefreshAction
implements IWorkbenchWindowActionDelegate,
UiConstants.ExtensionPoints.MetadataRefreshExtension {
    private ModelResource modelResource;
    private List extensionList;
    private List enabledExtensionList;

    public RefreshAction() {
        this.buildExtensionList();
    }

    private void determineEnablement(IAction theAction, ISelection theSelection) {
        boolean enable = false;
        this.modelResource = null;
        if (this.extensionList != null && !this.extensionList.isEmpty()) {
            this.enabledExtensionList.clear();
            if (SelectionUtilities.isSingleSelection((ISelection)theSelection)) {
                Object o = SelectionUtilities.getSelectedObject((ISelection)theSelection);
                if (o instanceof IFile && ModelUtilities.isModelFile((IResource)((IFile)o))) {
                    try {
                        this.modelResource = ModelUtil.getModelResource((IFile)((IFile)o), (boolean)false);
                    }
                    catch (ModelWorkspaceException e) {
                        UiConstants.Util.log((Throwable)e);
                    }
                }
                if (this.modelResource != null) {
                    for (IRefreshContributor action : this.extensionList) {
                        action.selectionChanged(theAction, theSelection);
                        if (!action.canRefresh()) continue;
                        enable = true;
                        this.enabledExtensionList.add(action);
                    }
                }
            }
        }
        theAction.setEnabled(enable);
    }

    private void buildExtensionList() {
        this.extensionList = new ArrayList();
        this.enabledExtensionList = new ArrayList(3);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "metadataRefresh");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = extensions.length - 1;
        while (i >= 0) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            Object extension = null;
            int j = 0;
            while (j < elements.length) {
                try {
                    extension = elements[j].createExecutableExtension("classname");
                    if (extension instanceof IRefreshContributor) {
                        IRefreshContributor action = (IRefreshContributor)extension;
                        String label = elements[j].getAttribute("label");
                        String description = elements[j].getAttribute("description");
                        this.extensionList.add(new RefreshDescriptor(action, label, description));
                    }
                }
                catch (Exception e) {
                    UiConstants.Util.log(4, (Throwable)e, e.getClass().getName());
                }
                ++j;
            }
            --i;
        }
    }

    public void init(IWorkbenchWindow window) {
        for (IRefreshContributor irc : this.extensionList) {
            irc.init(window);
        }
    }

    public void dispose() {
        for (IRefreshContributor irc : this.extensionList) {
            irc.dispose();
        }
    }

    public void run(IAction action) {
        if (this.enabledExtensionList.size() == 1) {
            ((IRefreshContributor)this.enabledExtensionList.get(0)).run(action);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.determineEnablement(action, selection);
    }
}

