/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.jdbc.relational.JdbcImporter;
import org.teiid.designer.jdbc.relational.ModelerJdbcRelationalConstants;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.IRefreshContributor;
import org.teiid.designer.ui.common.dialog.AbstractPasswordDialog;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class RefreshModelAction
implements IRefreshContributor,
ModelerJdbcRelationalConstants.Messages,
ModelUtil.Constants,
UiConstants {
    private IWorkbenchWindow wdw;
    ModelResource model;
    IStatus status;
    private boolean enable = false;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.wdw = window;
    }

    public void run(IAction action) {
        if (this.model != null) {
            try {
                if (this.model.getModelType().getValue() == ModelType.VIRTUAL) {
                    WidgetUtil.showError((String)MODEL_NOT_PHYSICAL_MESSAGE);
                    return;
                }
                if (!"http://www.metamatrix.com/metamodels/Relational".equals(this.model.getPrimaryMetamodelDescriptor().getNamespaceURI())) {
                    WidgetUtil.showError((String)MODEL_NOT_RELATIONAL_MESSAGE);
                    return;
                }
                Iterator iter = this.model.getAllRootEObjects().iterator();
                while (iter.hasNext()) {
                    if (!(iter.next() instanceof JdbcSource)) continue;
                    Shell sh = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
                    String allowsUpdate = ModelUtil.getModelAnnotationPropertyValue((ModelResource)this.model, (String)"jdbcConnection:allowAutoUpdate");
                    if (allowsUpdate != null && !allowsUpdate.isEmpty() && !Boolean.getBoolean(allowsUpdate)) {
                        String title = UiConstants.Util.getString("RefreshModelAction.updateNotAllowed.title", new Object[0]);
                        String message = UiConstants.Util.getString("RefreshModelAction.updateNotAllowed.msg", new Object[0]);
                        MessageDialog.openInformation((Shell)sh, (String)title, (String)message);
                        return;
                    }
                    new AbstractPasswordDialog(sh){

                        protected boolean isPasswordValid(String password) {
                            return RefreshModelAction.this.refresh(password);
                        }
                    }.open();
                    return;
                }
                new ImportResourcesAction(this.wdw).run();
            }
            catch (ModelWorkspaceException err) {
                Util.log((Throwable)err);
                WidgetUtil.showError((String)err.getLocalizedMessage());
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.determineEnablement(selection);
    }

    boolean refresh(final String password) {
        try {
            new ProgressMonitorDialog(this.wdw.getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    JdbcImporter importer = new JdbcImporter();
                    try {
                        try {
                            importer.setUpdatedModel(RefreshModelAction.this.model);
                            importer.connect(password, monitor);
                            importer.setUpdatedModelSettings();
                            IFile modelFile = (IFile)RefreshModelAction.this.model.getResource();
                            ModelEditorManager.activate(modelFile, true);
                            RefreshModelAction.this.status = importer.importModel(monitor);
                        }
                        catch (Throwable err) {
                            throw new InvocationTargetException(err);
                        }
                    }
                    finally {
                        try {
                            importer.disconnect();
                        }
                        catch (SQLException err) {
                            throw new InvocationTargetException(err);
                        }
                        monitor.done();
                    }
                }
            });
            if (!this.status.isOK()) {
                Util.log(this.status);
                WidgetUtil.showError((String)this.status.getMessage());
            }
            return this.status.getSeverity() != 4;
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                err = ((InvocationTargetException)err).getTargetException();
            }
            Util.log(err);
            WidgetUtil.showError((String)err.getLocalizedMessage());
            return false;
        }
    }

    private void determineEnablement(ISelection selection) {
        Object obj;
        this.model = null;
        this.enable = false;
        if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) != null) {
            try {
                this.model = ModelUtil.getModifiableModel((Object)obj);
                if (this.model != null && !ModelUtilities.isVirtual(this.model) && ModelUtilities.isRelationalModel(this.model) && ModelUtilities.hasJdbcSource(this.model)) {
                    this.enable = true;
                    return;
                }
            }
            catch (ModelWorkspaceException err) {
                Util.log((Throwable)err);
                WidgetUtil.showError((String)err.getLocalizedMessage());
            }
        }
    }

    @Override
    public boolean canRefresh() {
        return this.enable;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.determineEnablement(selection);
    }
}

