/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ModelObjectAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.viewsupport.DiagramHelperManager;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class RenameAction
extends ModelObjectAction
implements UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(RenameAction.class);
    String newName;
    private EAttribute nameAttr;

    static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    static String getString(String id, Object arg1, Object arg2) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[]{arg1, arg2});
    }

    static String getString(String id, Object parameter) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, parameter);
    }

    public RenameAction() {
        super(UiPlugin.getDefault());
    }

    @Override
    protected void doRun() {
        EObject obj = (EObject)this.getSelectedObject();
        String oldName = ModelerCore.getModelEditor().getName(obj);
        String fullObjectName = null;
        Object parent = ModelUtilities.getModelContentProvider().getParent((Object)obj);
        fullObjectName = parent instanceof EObject ? ModelerCore.getModelEditor().getModelRelativePathIncludingModel((EObject)parent).toString() : ModelerCore.getModelEditor().getModelName(obj);
        String objectType = obj.eClass().getName();
        RenameDialog dlg = new RenameDialog(Display.getDefault().getActiveShell(), fullObjectName, oldName, objectType);
        if (dlg.open() == 0) {
            ModelObjectUtilities.rename(obj, this.newName, this);
        }
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    public void selectionChanged(SelectionChangedEvent theEvent) {
        super.selectionChanged(theEvent);
        this.determineEnablement();
    }

    protected EAttribute getNameAttribute() {
        return this.nameAttr;
    }

    protected void determineEnablement() {
        EObject eObj;
        boolean enable = false;
        if (!this.isEmptySelection() && !this.isReadOnly() && this.canLegallyEditResource() && SelectionUtilities.isSingleSelection((ISelection)this.getSelection()) && (eObj = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection())) != null) {
            enable = eObj instanceof Diagram ? DiagramHelperManager.canRename((Diagram)eObj) : (eObj instanceof ModelImport ? false : ModelerCore.getModelEditor().hasName(eObj));
        }
        this.setEnabled(enable);
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }

    class RenameDialog
    extends TitleAreaDialog {
        String oldName;
        String fullPath;
        String type;
        StringNameValidator nameValidator;

        public RenameDialog(Shell parent, String fullPath, String originalName, String objectType) {
            super(parent);
            this.nameValidator = new StringNameValidator();
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.oldName = originalName;
            this.fullPath = fullPath;
            this.type = objectType;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(RenameAction.getString("dialogTitle"));
        }

        protected Control createDialogArea(Composite parent) {
            Composite outerPanel = (Composite)super.createDialogArea(parent);
            Composite innerPanel = new Composite(outerPanel, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            innerPanel.setLayout((Layout)gridLayout);
            innerPanel.setLayoutData((Object)new GridData(1808));
            this.setTitle(RenameAction.getString("subtitle", this.type, this.oldName));
            this.setMessage(RenameAction.getString("initialMessage"));
            WidgetFactory.createLabel((Composite)innerPanel, (String)RenameAction.getString("location"));
            WidgetFactory.createLabel((Composite)innerPanel, (String)this.fullPath);
            WidgetFactory.createLabel((Composite)innerPanel, (String)RenameAction.getString("nameLabel"));
            final Text nameText = WidgetFactory.createTextField((Composite)innerPanel, (int)768, (String)this.oldName);
            if (this.oldName != null) {
                nameText.setSelection(0, this.oldName.length());
            }
            nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    RenameDialog.this.handleModifyText(nameText);
                }
            });
            return innerPanel;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.getButton(0).setEnabled(false);
        }

        void handleModifyText(Text nameText) {
            RenameAction.this.newName = nameText.getText();
            this.validate();
        }

        public void validate() {
            IStatus status = Status.OK_STATUS;
            if (RenameAction.this.newName == null || RenameAction.this.newName.trim().length() == 0) {
                status = new Status(4, "org.teiid.designer.ui", RenameAction.getString("emptyNameErrorMessage"));
            } else {
                String errorMessage = this.nameValidator.checkValidName(RenameAction.this.newName);
                if (errorMessage != null && !errorMessage.isEmpty()) {
                    status = new Status(4, "org.teiid.designer.ui", errorMessage);
                }
            }
            if (status.isOK() && RenameAction.this.newName.equalsIgnoreCase(this.oldName)) {
                status = new Status(4, "org.teiid.designer.ui", RenameAction.getString("sameNameErrorMessage", RenameAction.this.newName));
            }
            if (status.getSeverity() == 4) {
                this.getButton(0).setEnabled(false);
                this.setErrorMessage(status.getMessage());
            } else {
                this.getButton(0).setEnabled(true);
                this.setErrorMessage(null);
                this.setMessage(RenameAction.getString("okMessage"));
            }
        }
    }
}

