/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlProcedureParameterAspect;
import org.teiid.designer.metamodels.relational.aspects.sql.ProcedureParameterAspect;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ModelObjectAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.DatatypeSelectionDialog;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class SetDatatypeAction
extends ModelObjectAction {
    private static final String STRING_STRING = "string";

    public SetDatatypeAction() {
        super(UiPlugin.getDefault());
    }

    @Override
    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        ArrayList selectedEObjects = new ArrayList(SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()));
        if (!selectedEObjects.isEmpty()) {
            this.showDialog(selectedEObjects);
        }
    }

    private void determineEnablement() {
        boolean enable = false;
        if (!SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()).isEmpty()) {
            enable = this.allSelectedAreSqlColumns(this.getSelection());
            if (!enable) {
                enable = this.allSelectedAreProcedureParameters(this.getSelection());
            }
            if (!enable) {
                enable = this.allSelectedAreXmlInputParameters(this.getSelection());
            }
        }
        this.setEnabled(enable);
    }

    private boolean allSelectedAreSqlColumns(ISelection selection) {
        boolean result = true;
        Iterator iter = SelectionUtilities.getSelectedEObjects((ISelection)selection).iterator();
        EObject nextEObj = null;
        MetamodelAspect mmAspect = null;
        while (iter.hasNext() && result) {
            nextEObj = (EObject)iter.next();
            if (ModelObjectUtilities.isReadOnly(nextEObj)) {
                result = false;
            }
            if (!result) continue;
            mmAspect = ModelObjectUtilities.getSqlAspect(nextEObj);
            if (mmAspect == null || !(mmAspect instanceof SqlColumnAspect)) {
                result = false;
                continue;
            }
            if (((SqlColumnAspect)mmAspect).canSetDatatype()) continue;
            result = false;
        }
        return result;
    }

    private boolean allSelectedAreProcedureParameters(ISelection selection) {
        boolean result = true;
        Iterator iter = SelectionUtilities.getSelectedEObjects((ISelection)selection).iterator();
        EObject nextEObj = null;
        MetamodelAspect mmAspect = null;
        while (iter.hasNext() && result) {
            nextEObj = (EObject)iter.next();
            if (ModelObjectUtilities.isReadOnly(nextEObj)) {
                result = false;
            }
            if (!result) continue;
            mmAspect = ModelObjectUtilities.getSqlAspect(nextEObj);
            if (mmAspect == null || !(mmAspect instanceof ProcedureParameterAspect)) {
                result = false;
                continue;
            }
            if (((ProcedureParameterAspect)mmAspect).canSetDatatype()) continue;
            result = false;
        }
        return result;
    }

    private boolean allSelectedAreXmlInputParameters(ISelection selection) {
        boolean result = true;
        Iterator iter = SelectionUtilities.getSelectedEObjects((ISelection)selection).iterator();
        EObject nextEObj = null;
        MetamodelAspect mmAspect = null;
        while (iter.hasNext() && result) {
            nextEObj = (EObject)iter.next();
            if (ModelObjectUtilities.isReadOnly(nextEObj)) {
                result = false;
            }
            if (!result || (mmAspect = ModelObjectUtilities.getSqlAspect(nextEObj)) != null) continue;
            result = false;
        }
        return result;
    }

    protected void showDialog(Collection theEObjects) {
        int length = 0;
        EObject eObj = (EObject)theEObjects.iterator().next();
        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        DatatypeSelectionDialog dialog = new DatatypeSelectionDialog(shell, eObj);
        boolean canSetLength = false;
        if (theEObjects.size() > 1) {
            dialog.setMultipleObjects(true);
        } else {
            dialog.setMultipleObjects(false);
        }
        MetamodelAspect mmAspect = ModelObjectUtilities.getSqlAspect(eObj);
        if (mmAspect instanceof SqlColumnAspect) {
            int status;
            SqlColumnAspect sqa = (SqlColumnAspect)mmAspect;
            EObject originalValue = sqa.getDatatype(eObj);
            Object[] selection = new Object[]{originalValue};
            dialog.setInitialSelections(selection);
            canSetLength = sqa.canSetLength();
            if (canSetLength) {
                int initialLength = sqa.getLength(eObj);
                if (initialLength >= 0) {
                    dialog.setInitialLength(initialLength);
                }
                dialog.setEditLength(true);
            }
            if ((status = dialog.open()) == 0) {
                Object newType = null;
                Object[] result = dialog.getResult();
                if (result.length > 0) {
                    if (canSetLength) {
                        length = dialog.getLength();
                    }
                    newType = result[0];
                }
                this.setDatatypesForSqlColumns(theEObjects, (EObject)newType, length, dialog.overrideAllLengths());
            }
        } else if (mmAspect instanceof SqlProcedureParameterAspect) {
            int status;
            SqlProcedureParameterAspect ppa = (SqlProcedureParameterAspect)mmAspect;
            EObject originalValue = ppa.getDatatype(eObj);
            Object[] selection = new Object[]{originalValue};
            dialog.setInitialSelections(selection);
            canSetLength = ppa.canSetLength();
            if (canSetLength) {
                int initialLength = ppa.getLength(eObj);
                if (initialLength >= 0) {
                    dialog.setInitialLength(initialLength);
                }
                dialog.setEditLength(true);
            }
            if ((status = dialog.open()) == 0) {
                Object newType = null;
                Object[] result = dialog.getResult();
                if (result.length > 0) {
                    if (canSetLength) {
                        length = dialog.getLength();
                    }
                    newType = result[0];
                }
                this.setDatatypesForProcedureParameters(theEObjects, (EObject)newType, length, dialog.overrideAllLengths());
            }
        }
    }

    private void setDatatypesForSqlColumns(Collection columns, EObject datatype, int theLength, boolean overrideAllLengths) {
        SqlColumnAspect columnAspect = null;
        EObject nextEObj = null;
        Iterator iter = columns.iterator();
        int length = 0;
        if (this.typeIsString(datatype)) {
            length = theLength;
        }
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Set Datatype For Columns", (Object)((Object)this));
        boolean succeeded = false;
        try {
            while (iter.hasNext()) {
                boolean hasLength;
                nextEObj = (EObject)iter.next();
                columnAspect = (SqlColumnAspect)AspectManager.getSqlAspect((EObject)nextEObj);
                boolean bl = hasLength = columnAspect.canSetLength() && columnAspect.getLength(nextEObj) > 0;
                if (columnAspect.canSetDatatype()) {
                    columnAspect.setDatatype(nextEObj, datatype);
                }
                if (overrideAllLengths && columnAspect.canSetLength()) {
                    columnAspect.setLength(nextEObj, length);
                    continue;
                }
                if (overrideAllLengths || hasLength || !columnAspect.canSetLength()) continue;
                columnAspect.setLength(nextEObj, length);
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private void setDatatypesForProcedureParameters(Collection columns, EObject datatype, int length, boolean overrideAllLengths) {
        SqlProcedureParameterAspect procedureAspect = null;
        EObject nextEObj = null;
        Iterator iter = columns.iterator();
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Set Datatype For Columns", (Object)((Object)this));
        boolean succeeded = false;
        try {
            while (iter.hasNext()) {
                boolean hasLength;
                nextEObj = (EObject)iter.next();
                procedureAspect = (SqlProcedureParameterAspect)AspectManager.getSqlAspect((EObject)nextEObj);
                boolean bl = hasLength = procedureAspect.canSetLength() && procedureAspect.getLength(nextEObj) > 0;
                if (procedureAspect.canSetDatatype()) {
                    procedureAspect.setDatatype(nextEObj, datatype);
                }
                if (overrideAllLengths && procedureAspect.canSetLength() && procedureAspect.canSetLength()) {
                    procedureAspect.setLength(nextEObj, length);
                    continue;
                }
                if (overrideAllLengths || hasLength) continue;
                procedureAspect.setLength(nextEObj, length);
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }

    private boolean typeIsString(Object type) {
        String simpleType;
        return type != null && type instanceof XSDSimpleTypeDefinition && (simpleType = ModelerCore.getWorkspaceDatatypeManager().getRuntimeTypeName((EObject)type)).equalsIgnoreCase(STRING_STRING);
    }
}

