/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.ui.actions.ISelectionAction;

public abstract class SortableSelectionAction
extends Action
implements ISelectionListener,
Comparable,
ISelectionAction,
ISelectionChangedListener {
    private boolean wireForSelection = false;
    private ISelection selection;

    public SortableSelectionAction() {
    }

    public SortableSelectionAction(String text, int style) {
        super(text, style);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        boolean enable = this.isValidSelection(selection);
        if (enable) {
            this.setSelection(selection);
        }
        this.setEnabled(enable);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection sel = event.getSelection();
        this.selectionChanged(null, sel);
    }

    @Override
    public boolean isApplicable(ISelection selection) {
        return true;
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    protected boolean isValidSelection(ISelection selection) {
        return !selection.isEmpty();
    }

    public String getSingleMenuText() {
        return this.getText();
    }

    protected void setWiredForSelection(boolean value) {
        this.wireForSelection = value;
    }

    public boolean doWireForSelection() {
        return this.wireForSelection;
    }

    public SortableSelectionAction getClone() {
        return null;
    }
}

