/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.AbstractModelerAction;
import org.teiid.designer.ui.common.print.IPrintable;
import org.teiid.designer.ui.common.table.TablePrinter;
import org.teiid.designer.ui.editors.ModelEditor;

public class TablePrintAction
extends AbstractModelerAction
implements UiConstants,
IPartListener {
    private static final String TOOLTIP = UiConstants.Util.getString("TablePrintAction.toolTip.text", new Object[0]);

    public TablePrintAction() {
        super(UiPlugin.getDefault());
        this.initialize();
    }

    public TablePrintAction(int theStyle) {
        super(UiPlugin.getDefault(), theStyle);
        this.initialize();
    }

    public void initialize() {
        this.addAsPartListener();
        this.setToolTipText(TOOLTIP);
    }

    protected void doRun() {
        Object oTable;
        IPrintable printable;
        ModelEditor editor = this.getActiveEditor();
        if (editor != null && (printable = (IPrintable)editor.getAdapter(IPrintable.class)) != null && (oTable = printable.getObject()) != null && oTable instanceof Table) {
            TablePrinter tpPrinter = new TablePrinter();
            tpPrinter.printTable((Table)oTable);
            this.setEnabled(true);
        }
    }

    private void addAsPartListener() {
        this.getPlugin().getCurrentWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        Object oViewer;
        IPrintable printable;
        boolean bResultState = false;
        ModelEditor editor = this.getActiveEditor();
        if (editor != null && thePart instanceof ModelEditor && editor instanceof ModelEditor && (printable = (IPrintable)editor.getAdapter(IPrintable.class)) != null && (oViewer = printable.getObject()) != null && oViewer instanceof Table) {
            bResultState = true;
        }
        this.setEnabled(bResultState);
    }

    public void setEnableState() {
        ModelEditor editor = this.getActiveEditor();
        if (editor != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.setEnableState();
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.setEnableState();
    }

    public void partClosed(IWorkbenchPart part) {
        this.setEnabled(false);
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.setEnabled(false);
    }

    public void partOpened(IWorkbenchPart part) {
        this.setEnableState();
    }
}

