/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.TextActionHandler;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.RenameAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.DatatypeUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class TreeViewerRenameAction
extends RenameAction {
    private TreeEditor treeEditor;
    Tree navigatorTree;
    private TreeViewer treeViewer;
    Text textEditor;
    Composite textEditorParent;
    private TextActionHandler textActionHandler;
    private TreeItem[] cachedSelection;
    EObject currentObject;
    boolean isSignificant = false;

    public void setTreeViewer(TreeViewer treeViewer, ILabelProvider labelProvider) {
        if (treeViewer != null) {
            this.treeViewer = treeViewer;
            this.navigatorTree = treeViewer.getTree();
            this.treeEditor = new TreeEditor(this.navigatorTree);
            this.navigatorTree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent theEvent) {
                    if (theEvent.button == 3 && TreeViewerRenameAction.this.isTextEditorActive()) {
                        TreeViewerRenameAction.this.saveChangesAndDispose((EObject)TreeViewerRenameAction.this.getSelectedObject());
                    }
                }
            });
        }
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
    }

    @Override
    public void doRun() {
        final EObject currentObject = (EObject)this.getSelectedObject();
        this.cachedSelection = this.navigatorTree.getSelection();
        if (currentObject != null || this.cachedSelection != null) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TreeViewerRenameAction.this.navigatorTree != null) {
                        TreeViewerRenameAction.this.isSignificant = true;
                        TreeViewerRenameAction.this.renameInline(currentObject);
                    } else {
                        RuntimeException e = new RuntimeException();
                        UiConstants.Util.log(4, (Throwable)e, "TreeViewerRenameAction doRun() called on a null Tree");
                    }
                }
            });
        }
    }

    public void doRun(final boolean generateUndo) {
        this.preRun();
        final EObject currentObject = (EObject)this.getSelectedObject();
        this.cachedSelection = this.navigatorTree.getSelection();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TreeViewerRenameAction.this.navigatorTree != null) {
                    TreeViewerRenameAction.this.isSignificant = generateUndo;
                    if (ModelerCore.getModelEditor().hasName(currentObject)) {
                        TreeViewerRenameAction.this.renameInline(currentObject);
                    }
                } else {
                    RuntimeException e = new RuntimeException();
                    UiConstants.Util.log(4, (Throwable)e, "TreeViewerRenameAction doRun() called on a null Tree");
                }
            }
        });
    }

    void renameInline(EObject eObject) {
        String name;
        EObject editingEObject = eObject;
        if (eObject == null || this.cachedSelection == null || this.cachedSelection.length != 1 || !(this.cachedSelection[0].getData() instanceof EObject) || eObject != (EObject)this.cachedSelection[0].getData()) {
            StructuredSelection selection;
            if (eObject != null && (this.cachedSelection == null || this.cachedSelection.length == 0)) {
                selection = new StructuredSelection((Object)eObject);
                this.treeViewer.setSelection((ISelection)selection);
                this.cachedSelection = this.navigatorTree.getSelection();
            } else if (eObject != null && this.cachedSelection.length == 1 && this.cachedSelection[0].getData() instanceof IFile) {
                selection = new StructuredSelection((Object)eObject);
                this.treeViewer.setSelection((ISelection)selection);
                this.cachedSelection = this.navigatorTree.getSelection();
            } else if (this.cachedSelection != null && this.cachedSelection[0] != null && (eObject == null || this.cachedSelection[0].getData() != eObject)) {
                selection = new StructuredSelection((Object)this.cachedSelection[0]);
                editingEObject = (EObject)this.cachedSelection[0].getData();
                this.treeViewer.setSelection((ISelection)selection);
            } else {
                return;
            }
        }
        if (this.textEditorParent == null) {
            this.createTextEditor(editingEObject);
        }
        if ((name = ModelerCore.getModelEditor().getName(editingEObject)) != null) {
            this.textEditor.setText(name);
        }
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    private void createTextEditor(final EObject eObj) {
        this.textEditorParent = this.createEditorParent();
        this.textEditorParent.setVisible(false);
        this.textEditorParent.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = TreeViewerRenameAction.this.textEditor.getSize();
                Point parentSize = TreeViewerRenameAction.this.textEditorParent.getSize();
                e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
            }
        });
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = TreeViewerRenameAction.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = TreeViewerRenameAction.this.textEditorParent.getSize();
                TreeViewerRenameAction.this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
                TreeViewerRenameAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        TreeViewerRenameAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        TreeViewerRenameAction.this.saveChangesAndDispose(eObj);
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                TreeViewerRenameAction.this.saveChangesAndDispose(eObj);
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
    }

    Composite createEditorParent() {
        Tree tree = this.navigatorTree;
        Composite result = new Composite((Composite)tree, 0);
        TreeItem[] selectedItems = this.cachedSelection;
        if (selectedItems.length > 0) {
            this.treeEditor.horizontalAlignment = 16384;
            this.treeEditor.grabHorizontal = true;
            this.treeEditor.setEditor((Control)result, selectedItems[0]);
        }
        return result;
    }

    void saveChangesAndDispose(EObject resource) {
        this.currentObject = resource;
        final String newName = this.textEditor.getText();
        Runnable query = new Runnable(){

            @Override
            public void run() {
                block16: {
                    String oldName;
                    TreeViewerRenameAction.this.disposeTextWidget();
                    if (TreeViewerRenameAction.this.currentObject != null && !newName.equals(oldName = ModelerCore.getModelEditor().getName(TreeViewerRenameAction.this.currentObject)) && TreeViewerRenameAction.this.currentObject != null) {
                        String undoLabel = UiConstants.Util.getString("RenameAction.undoLabel", (Object)oldName);
                        boolean started = ModelerCore.startTxn((boolean)TreeViewerRenameAction.this.isSignificant, (String)undoLabel, (Object)this);
                        boolean succeeded = false;
                        try {
                            try {
                                if (!DatatypeUtilities.renameSqlColumn(TreeViewerRenameAction.this.currentObject, newName) && newName.length() > 0) {
                                    ModelerCore.getModelEditor().rename(TreeViewerRenameAction.this.currentObject, newName);
                                }
                                succeeded = true;
                            }
                            catch (ModelerCoreException e) {
                                UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                                if (started) {
                                    if (succeeded) {
                                        ModelerCore.commitTxn();
                                    } else {
                                        ModelerCore.rollbackTxn();
                                    }
                                }
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            if (started) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            throw throwable;
                        }
                        if (started) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                }
                TreeViewerRenameAction.this.currentObject = null;
            }
        };
        this.navigatorTree.getShell().getDisplay().asyncExec(query);
    }

    boolean isTextEditorActive() {
        return this.textEditor != null;
    }

    void disposeTextWidget() {
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
        this.insureOpenEditor();
    }

    @Override
    protected boolean preRun() {
        EObject eObject;
        ModelResource mr;
        List allSelectedEObjects;
        if (this.requiresEditorForRun() && (allSelectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection())) != null && !allSelectedEObjects.isEmpty() && (mr = ModelUtilities.getModelResourceForModelObject(eObject = (EObject)allSelectedEObjects.get(0))) != null && !ModelEditorManager.isOpen(eObject)) {
            ModelEditorManager.activate(mr, true);
        }
        return true;
    }

    @Override
    protected boolean requiresEditorForRun() {
        return true;
    }

    private void insureOpenEditor() {
        EObject eObject;
        ModelResource mr;
        List allSelectedEObjects;
        if (this.requiresEditorForRun() && (allSelectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection())) != null && !allSelectedEObjects.isEmpty() && (mr = ModelUtilities.getModelResourceForModelObject(eObject = (EObject)allSelectedEObjects.get(0))) != null) {
            ModelEditorManager.open(eObject, true, 3);
        }
    }
}

