/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions.workers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.workers.ModelObjectWorker;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.DiagramHelperManager;
import org.teiid.designer.ui.viewsupport.ModelObjectEditHelperManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CloneWorker
extends ModelObjectWorker {
    private static final String PROBLEM = "CloneWorker.problem";
    private static final String UNDO_TEXT = "CloneWorker.undoText";
    private static final String PLURAL_UNDO_TEXT = "CloneWorker.pluralUndoText";
    private ModelResource modelResource;
    private boolean editorIsOpening = false;
    private EObject focusedObject;
    private ISelection tempSelection;

    public CloneWorker(boolean enableAfterExecute) {
        super(enableAfterExecute);
    }

    @Override
    public boolean setEnabledState() {
        boolean enable;
        block13: {
            ISelection iSelection;
            block14: {
                enable = false;
                Object selection = this.getSelection();
                if (!(selection instanceof ISelection) || (iSelection = (ISelection)selection).isEmpty() || this.isReadOnly() || !this.canLegallyEditResource()) break block13;
                if (!SelectionUtilities.isSingleSelection((ISelection)iSelection)) break block14;
                EObject o = SelectionUtilities.getSelectedEObject((ISelection)iSelection);
                if (o instanceof Diagram) {
                    enable = DiagramHelperManager.canClone((Diagram)o);
                } else if (o instanceof XmlDocument || o instanceof ModelImport) {
                    enable = false;
                } else {
                    boolean bl = enable = o != null && ModelObjectEditHelperManager.canClone(o);
                }
                if (!enable) break block13;
                this.focusedObject = o;
                this.modelResource = ModelUtilities.getModelResourceForModelObject(o);
                if (this.modelResource != null) {
                    EObject parent = this.focusedObject.eContainer();
                    if (parent != null) {
                        enable = ModelerCore.getModelEditor().isValidParent((Object)parent, o);
                    }
                } else {
                    enable = false;
                }
                if (enable) break block13;
                this.modelResource = null;
                break block13;
            }
            if (SelectionUtilities.isMultiSelection((ISelection)iSelection)) {
                List sourceEObjects = SelectionUtilities.getSelectedEObjects((ISelection)iSelection);
                enable = true;
                Iterator iter = sourceEObjects.iterator();
                while (iter.hasNext() && enable) {
                    Object o = iter.next();
                    enable = o instanceof Diagram ? DiagramHelperManager.canClone((Diagram)o) : (o instanceof XmlDocument || o instanceof ModelImport ? false : ModelObjectEditHelperManager.canClone(o));
                    if (!enable || this.tempSelection != null) continue;
                    this.focusedObject = (EObject)o;
                    this.modelResource = ModelUtilities.getModelResourceForModelObject((EObject)o);
                    if (this.modelResource != null) {
                        EObject parent = this.focusedObject.eContainer();
                        if (parent != null) {
                            enable = ModelerCore.getModelEditor().isValidParent((Object)parent, (EObject)o);
                        }
                    } else {
                        enable = false;
                    }
                    if (enable) continue;
                    this.modelResource = null;
                }
            }
        }
        if (!enable) {
            this.focusedObject = null;
            this.modelResource = null;
        }
        return enable;
    }

    @Override
    public boolean execute() {
        boolean successful = false;
        Object selection = this.getSelection();
        if (selection instanceof ISelection && this.canLegallyEditResource()) {
            ISelection iSelection = (ISelection)selection;
            String objectString = null;
            List lstObjs = SelectionUtilities.getSelectedEObjects((ISelection)iSelection);
            String description = null;
            if (lstObjs.size() == 1) {
                EObject obj = (EObject)lstObjs.get(0);
                objectString = ModelerCore.getModelEditor().getModelRelativePath(obj).toString();
                description = UiConstants.Util.getString(UNDO_TEXT, (Object)objectString);
            } else {
                objectString = "" + lstObjs.size();
                description = UiConstants.Util.getString(PLURAL_UNDO_TEXT, (Object)objectString);
            }
            boolean started = ModelerCore.startTxn((String)description, (Object)this);
            boolean succeeded = false;
            try {
                for (EObject obj : lstObjs) {
                    try {
                        ModelerCore.getModelEditor().clone(obj);
                    }
                    catch (ModelerCoreException theException) {
                        IPath path = ModelerCore.getModelEditor().getModelRelativePathIncludingModel(obj);
                        String msg = UiConstants.Util.getString(PROBLEM, (Object)path);
                        UiConstants.Util.log(4, (Throwable)theException, msg);
                    }
                }
                successful = true;
                succeeded = true;
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
            this.tempSelection = null;
            this.editorIsOpening = false;
            this.focusedObject = null;
            this.modelResource = null;
        }
        return successful;
    }

    public void setModelResource(ModelResource modelResource) {
        this.modelResource = modelResource;
    }

    public ISelection getTempSelection() {
        return this.tempSelection;
    }

    public void setTempSelection(ISelection tempSelection) {
        this.tempSelection = tempSelection;
    }

    public void setEditorIsOpening(boolean editorIsOpening) {
        this.editorIsOpening = editorIsOpening;
    }

    public boolean getEditorIsOpening() {
        return this.editorIsOpening;
    }

    public EObject getFocusedObject() {
        return this.focusedObject;
    }

    public ModelResource getModelResource() {
        return this.modelResource;
    }
}

