/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions.workers;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.actions.workers.ModelObjectWorker;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.SystemClipboardUtilities;
import org.teiid.designer.ui.viewsupport.ImportContainer;

public class CopyNameWorker
extends ModelObjectWorker {
    private static final char OLD_DELIM = '/';
    private static final char NEW_DELIM = '.';
    public static final int SHOW_JUST_NAME = 1;
    public static final int SHOW_FULLY_QUALIFIED_NAME = 2;
    private int iNameStyle = 2;

    public CopyNameWorker(boolean enableAfterExecute, int iNameStyle) {
        super(enableAfterExecute);
        if (iNameStyle == 1 || iNameStyle == 2) {
            this.iNameStyle = iNameStyle;
        }
    }

    @Override
    public boolean setEnabledState() {
        String sName;
        ISelection iSelection;
        boolean enable = false;
        Object selection = this.getSelection();
        if (selection instanceof ISelection && SelectionUtilities.isSingleSelection((ISelection)(iSelection = (ISelection)selection)) && (sName = this.formatName(iSelection)) != null && !sName.equals("")) {
            enable = true;
        }
        return enable;
    }

    @Override
    public boolean execute() {
        ISelection iSelection;
        boolean successful = false;
        Object selection = this.getSelection();
        if (selection instanceof ISelection && SelectionUtilities.isSingleSelection((ISelection)(iSelection = (ISelection)selection))) {
            String sName = this.formatName(iSelection);
            SystemClipboardUtilities.setContents((String)sName);
        }
        return successful;
    }

    protected String formatName(ISelection sel) {
        String sResultName = "";
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            Object elem = selection.getFirstElement();
            String sFullName = this.formatMessage(elem);
            sResultName = sFullName.replace('/', '.');
            if (this.iNameStyle == 1) {
                sResultName = this.parseNameFromFullName(sResultName);
            }
        }
        return sResultName;
    }

    protected String parseNameFromFullName(String sFullName) {
        String sName = "";
        int iLastDelim = sFullName.lastIndexOf(46);
        if (iLastDelim != -1) {
            sName = sFullName.substring(iLastDelim + 1);
        }
        return sName;
    }

    protected String formatMessage(Object oSel) {
        Object elem = oSel;
        if (elem instanceof EObject) {
            return this.formatEObjectMessage((EObject)elem);
        }
        if (elem instanceof IResource) {
            return this.formatResourceMessage((IResource)elem);
        }
        if (elem instanceof ImportContainer) {
            return ((ImportContainer)elem).toString();
        }
        return elem.getClass().getName();
    }

    public String formatEObjectMessage(EObject element) {
        String result = "";
        if (element instanceof ENamedElement) {
            return String.valueOf(result) + ((ENamedElement)element).getName();
        }
        result = String.valueOf(result) + ModelerCore.getModelEditor().getModelRelativePathIncludingModel(element, false);
        return result;
    }

    private String formatResourceMessage(IResource element) {
        return element.getName();
    }
}

