/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions.workers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.refactor.ObjectDeleteCommand;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.TransactionSettings;
import org.teiid.designer.ui.actions.workers.ModelObjectWorker;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.DiagramHelperManager;
import org.teiid.designer.ui.viewsupport.ModelObjectEditHelperManager;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DeleteWorker
extends ModelObjectWorker {
    private static final String UNDO_TEXT = "DeleteAction.undoText";
    private static final String PLURAL_UNDO_TEXT = "DeleteAction.pluralUndoText";
    private static final String DELETE_ONE_TITLE_KEY = "DeleteWorker.deleteOneTitle";
    private static final String DELETE_MANY_TITLE_KEY = "DeleteWorker.deleteManyTitle";
    private ModelResource modelResource;
    private EObject focusedObject;
    private IStatus status;
    private ObjectDeleteCommand odcDeleteCommand;
    private List<EObject> selectedObjects;

    public DeleteWorker(boolean enableAfterExecute) {
        super(enableAfterExecute);
    }

    @Override
    public boolean setEnabledState() {
        ISelection iSelection;
        boolean enable = false;
        Object selection = this.getSelection();
        boolean foundResource = false;
        if (selection instanceof ISelection && !(iSelection = (ISelection)selection).isEmpty() && !this.isReadOnly() && this.canLegallyEditResource() && SelectionUtilities.isAllEObjects((ISelection)iSelection)) {
            enable = true;
            Iterator iter = SelectionUtilities.getSelectedEObjects((ISelection)iSelection).iterator();
            while (iter.hasNext() && enable) {
                EObject obj = (EObject)iter.next();
                if (obj == null || ModelObjectUtilities.isReadOnly(obj)) {
                    enable = false;
                } else {
                    enable = obj instanceof Diagram ? DiagramHelperManager.canDelete((Diagram)obj) : ModelObjectEditHelperManager.canDelete(obj);
                    if (!foundResource && enable) {
                        this.focusedObject = obj;
                        foundResource = true;
                        this.modelResource = ModelUtilities.getModelResourceForModelObject(obj);
                    }
                }
                if (!enable) break;
            }
        }
        if (!enable) {
            this.modelResource = null;
            this.focusedObject = null;
        }
        if (UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage() != null) {
            IWorkbenchPart iWorkbenchPart = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().getActivePart();
        }
        return enable;
    }

    @Override
    public boolean execute() {
        boolean successful = false;
        Object selection = this.getSelection();
        if (selection instanceof ISelection && this.canStillDelete((ISelection)selection) && this.canLegallyEditResource()) {
            if (this.odcDeleteCommand == null) {
                this.createObjectDeleteCommand();
            }
            try {
                this.executeCommand(this.odcDeleteCommand, this.selectedObjects, this.getTransactionSettings());
            }
            finally {
                this.focusedObject = null;
                this.modelResource = null;
            }
        }
        return successful;
    }

    public boolean canStillDelete(ISelection iSelection) {
        boolean okToDelete = true;
        Iterator iter = SelectionUtilities.getSelectedEObjects((ISelection)iSelection).iterator();
        while (iter.hasNext() && okToDelete) {
            okToDelete = ModelObjectEditHelperManager.canDelete(iter.next());
        }
        return okToDelete;
    }

    public void createObjectDeleteCommand() {
        this.odcDeleteCommand = new ObjectDeleteCommand();
        this.odcDeleteCommand.setObjectsToDelete(this.selectedObjects);
    }

    public void setSelectedObjects() {
        ISelection selection = (ISelection)this.getSelection();
        this.selectedObjects = SelectionUtilities.getSelectedEObjects((ISelection)selection);
    }

    public List<EObject> getSelectedEObjects() {
        return this.selectedObjects;
    }

    private void executeCommand(final ObjectDeleteCommand odcDeleteCommand, List<EObject> eObjects, TransactionSettings ts) {
        block13: {
            if (odcDeleteCommand == null) {
                this.createObjectDeleteCommand();
            }
            String tempString = UiConstants.Util.getString(DELETE_ONE_TITLE_KEY, new Object[0]);
            if (eObjects.size() > 1) {
                tempString = UiConstants.Util.getString(DELETE_MANY_TITLE_KEY, (Object)eObjects.size());
            }
            final String deleteTitle = tempString;
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) {
                    if (monitor instanceof SubProgressMonitor) {
                        ((SubProgressMonitor)monitor).getWrappedProgressMonitor().setTaskName(deleteTitle);
                    }
                    monitor.beginTask("", 100);
                    monitor.worked(5);
                    IStatus status = odcDeleteCommand.execute(monitor);
                    DeleteWorker.this.setResult(status);
                }
            };
            ts.setSource(this);
            boolean started = ModelerCore.startTxn((boolean)ts.isSignificant(), (boolean)ts.isUndoable(), (String)ts.getDescription(), (Object)ts.getSource());
            boolean succeeded = false;
            try {
                try {
                    ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
                    progressDialog.run(true, true, (IRunnableWithProgress)operation);
                    if (!progressDialog.getProgressMonitor().isCanceled()) {
                        succeeded = true;
                    }
                    if (!this.getStatus().isOK()) {
                        UiConstants.Util.log(this.getStatus());
                    }
                }
                catch (Exception e) {
                    UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                    if (!started) break block13;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block13;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    void setResult(IStatus status) {
        this.status = status;
    }

    private IStatus getStatus() {
        return this.status;
    }

    public TransactionSettings initTransactionSettings() {
        TransactionSettings ts = this.getTransactionSettings();
        ts = this.processCanUndoDelete(ts);
        ts = this.processDescription(ts);
        return ts;
    }

    private TransactionSettings processDescription(TransactionSettings ts) {
        ts.setDescription(this.getUndoText());
        return ts;
    }

    private String getUndoText() {
        String description = null;
        if (this.selectedObjects.size() == 1) {
            EObject obj = this.selectedObjects.get(0);
            String path = ModelerCore.getModelEditor().getModelRelativePath(obj).toString();
            description = UiConstants.Util.getString(UNDO_TEXT, (Object)path);
        } else {
            description = UiConstants.Util.getString(PLURAL_UNDO_TEXT, (Object)this.selectedObjects.size());
        }
        return description;
    }

    private TransactionSettings processCanUndoDelete(TransactionSettings ts) {
        ISelection iSelection;
        boolean bCanUndoDelete = false;
        Object selection = this.getSelection();
        if (selection instanceof ISelection && !(iSelection = (ISelection)selection).isEmpty() && !this.isReadOnly() && this.canLegallyEditResource()) {
            if (SelectionUtilities.isSingleSelection((ISelection)iSelection)) {
                EObject o = SelectionUtilities.getSelectedEObject((ISelection)iSelection);
                bCanUndoDelete = o != null && ModelObjectEditHelperManager.canUndoCut(o);
            } else if (SelectionUtilities.isMultiSelection((ISelection)iSelection)) {
                List sourceEObjects = SelectionUtilities.getSelectedEObjects((ISelection)iSelection);
                bCanUndoDelete = true;
                if (sourceEObjects.size() > 0) {
                    bCanUndoDelete = ModelObjectEditHelperManager.canUndoCut(sourceEObjects);
                }
            }
            ts.setIsUndoable(bCanUndoDelete);
        }
        return ts;
    }

    public void setModelResource(ModelResource modelResource) {
        this.modelResource = modelResource;
    }

    public EObject getFocusedObject() {
        return this.focusedObject;
    }

    public ModelResource getModelResource() {
        return this.modelResource;
    }

    public ObjectDeleteCommand getObjectDeleteCommand() {
        return this.odcDeleteCommand;
    }
}

