/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions.workers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;

public class ExportTextToFileWorker {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(ExportTextToFileWorker.class);
    private static final String STAR_DOT_STAR = "*.*";
    private static final String EXPORT_PROBLEM = UiConstants.Util.getString("ExportTextToFileWorker.exportError", new Object[0]);
    private static final char PERIOD = '.';
    private String fileDialogTitle;
    private String defaultFileName;
    private String defaultFileExt;
    private String text;
    private String header;
    private String fileName;
    private String folder = "";

    public ExportTextToFileWorker() {
    }

    public ExportTextToFileWorker(String title, String defFileName, String defFileExt, String header, String text) {
        this.fileDialogTitle = title;
        this.defaultFileName = defFileName;
        this.defaultFileExt = defFileExt;
        this.text = text;
        this.header = header;
    }

    public boolean export() {
        boolean cancelled;
        block21: {
            this.folder = "";
            this.fileName = null;
            cancelled = false;
            Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            FileDialog dlg = new FileDialog(shell, 8192);
            dlg.setFilterExtensions(new String[]{STAR_DOT_STAR});
            dlg.setText(this.fileDialogTitle);
            dlg.setFileName(this.defaultFileName);
            String fileNameStr = dlg.open();
            if (fileNameStr != null && fileNameStr.indexOf(46) == -1) {
                fileNameStr = String.valueOf(fileNameStr) + '.' + this.defaultFileExt;
            }
            boolean overwrite = true;
            if (fileNameStr != null && new File(fileNameStr).exists()) {
                overwrite = MessageDialog.openConfirm((Shell)shell, (String)UiConstants.Util.getStringOrKey(String.valueOf(PREFIX) + "confirmOverwrite.title"), (String)UiConstants.Util.getStringOrKey(String.valueOf(PREFIX) + "confirmOverwrite.msg"));
            }
            if (fileNameStr != null && overwrite) {
                this.fileName = fileNameStr;
                this.folder = dlg.getFilterPath();
                FileWriter fw = null;
                BufferedWriter out = null;
                PrintWriter pw = null;
                try {
                    try {
                        fw = new FileWriter(fileNameStr);
                        out = new BufferedWriter(fw);
                        pw = new PrintWriter(out);
                        pw.write(this.getFullText());
                    }
                    catch (Exception e) {
                        String msg = EXPORT_PROBLEM;
                        UiConstants.Util.log(4, (Throwable)e, msg);
                        cancelled = true;
                        pw.close();
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            fw.close();
                        }
                        catch (IOException iOException) {}
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    pw.close();
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        fw.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                pw.close();
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            } else {
                cancelled = true;
            }
        }
        return cancelled;
    }

    private String getFullText() {
        int headerLength = this.header == null ? 0 : this.header.length();
        StringBuffer sb = new StringBuffer(this.text.length() + headerLength + 10);
        if (headerLength > 0) {
            sb.append(this.header).append('\n');
        }
        sb.append(this.text);
        return sb.toString();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFolder() {
        return this.folder;
    }
}

