/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions.workers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.TransactionSettings;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.actions.IActionWorker;
import org.teiid.designer.ui.common.actions.WorkerProblem;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelObjectWorker
implements IActionWorker {
    private Object currentSelection;
    private boolean enabled = false;
    private boolean enableAfterExecute = false;
    private WorkerProblem workerProblem;
    private Object workerSource;
    private TransactionSettings txnSettings;

    public ModelObjectWorker(boolean enableAfterExecute) {
        this.enableAfterExecute = enableAfterExecute;
    }

    public boolean setEnabledState() {
        return false;
    }

    public boolean execute() {
        return false;
    }

    protected boolean canLegallyEditResource() {
        boolean canEdit = false;
        if (this.currentSelection instanceof ISelection) {
            List allEObjects = SelectionUtilities.getSelectedEObjects((ISelection)((ISelection)this.currentSelection));
            if (allEObjects != null && !allEObjects.isEmpty()) {
                canEdit = true;
            } else {
                List selectedObjs = SelectionUtilities.getSelectedObjects((ISelection)((ISelection)this.currentSelection));
                if (!selectedObjs.isEmpty()) {
                    canEdit = true;
                    int size = selectedObjs.size();
                    int i = 0;
                    while (i < size) {
                        block9: {
                            Object obj = selectedObjs.get(i);
                            if (obj instanceof IResource && ModelUtilities.isModelFile((IResource)obj)) {
                                try {
                                    if (ModelUtil.getModelResource((IFile)((IFile)obj), (boolean)false) == null) {
                                        canEdit = false;
                                    }
                                    break block9;
                                }
                                catch (ModelWorkspaceException theException) {
                                    canEdit = false;
                                    UiConstants.Util.log((Throwable)theException);
                                }
                                break;
                            }
                            canEdit = false;
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
        return canEdit;
    }

    protected boolean isReadOnly() {
        boolean isreadonly;
        block4: {
            block5: {
                isreadonly = true;
                if (!(this.currentSelection instanceof ISelection)) break block4;
                List allEObjects = SelectionUtilities.getSelectedEObjects((ISelection)((ISelection)this.currentSelection));
                if (allEObjects.isEmpty()) break block5;
                isreadonly = false;
                Iterator iter = allEObjects.iterator();
                while (iter.hasNext()) {
                    if (!ModelObjectUtilities.isReadOnly((EObject)iter.next())) continue;
                    isreadonly = true;
                    break block4;
                }
                break block4;
            }
            List selectedObjs = SelectionUtilities.getSelectedObjects((ISelection)((ISelection)this.currentSelection));
            if (selectedObjs.isEmpty()) break block4;
            isreadonly = false;
            int size = selectedObjs.size();
            int i = 0;
            while (i < size) {
                Object obj = selectedObjs.get(i);
                if (obj != null && obj instanceof IResource && ((IResource)obj).getResourceAttributes() != null && ((IResource)obj).getResourceAttributes().isReadOnly()) {
                    isreadonly = true;
                    break;
                }
                if (obj != null && !(obj instanceof IResource)) {
                    isreadonly = true;
                    break;
                }
                ++i;
            }
        }
        return isreadonly;
    }

    public Object getSelection() {
        return this.currentSelection;
    }

    public boolean selectionChanged(Object selection) {
        this.currentSelection = selection;
        this.enabled = this.setEnabledState();
        return this.enabled;
    }

    public boolean getEnableAfterExecute() {
        return this.enableAfterExecute;
    }

    public WorkerProblem getWorkerProblem() {
        return this.workerProblem;
    }

    public void setWorkerProblem(WorkerProblem workerProblem) {
        this.workerProblem = workerProblem;
    }

    public Object getWorkerSource() {
        return this.workerSource;
    }

    public void setWorkerSource(Object workerSource) {
        this.workerSource = workerSource;
    }

    public void setTransactionSettings(TransactionSettings txnSettings) {
        this.txnSettings = txnSettings;
        if (this.txnSettings != null) {
            this.txnSettings.setSource(this);
        }
    }

    public TransactionSettings getTransactionSettings() {
        return this.txnSettings;
    }

    protected ModelEditor getActiveEditor() {
        IWorkbenchPage page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
        if (page == null && (page = AbstractUiPlugin.getLastValidPage()) == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof ModelEditor) {
            return (ModelEditor)editor;
        }
        return null;
    }
}

