/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.build;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IMarkerResolution;
import org.teiid.designer.ui.UiConstants;

public class ModelProjectConfigurationResolution
implements IMarkerResolution {
    public String getLabel() {
        return UiConstants.Util.getString("ModelProjectConfigurationResolution.label", new Object[0]);
    }

    public void run(IMarker marker) {
        IResource resource = marker.getResource();
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            try {
                IProjectDescription desc = project.getDescription();
                boolean foundVdbBuilder = false;
                ICommand[] iCommandArray = desc.getBuildSpec();
                int n = iCommandArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICommand com = iCommandArray[n2];
                    foundVdbBuilder = com.getBuilderName().equalsIgnoreCase("org.teiid.designer.vdb.ui.vdbBuilder");
                    if (foundVdbBuilder) break;
                    ++n2;
                }
                if (!foundVdbBuilder) {
                    ICommand cmd = desc.newCommand();
                    cmd.setBuilderName("org.teiid.designer.vdb.ui.vdbBuilder");
                    ICommand[] cmds = desc.getBuildSpec();
                    ICommand[] newCmds = new ICommand[cmds.length + 1];
                    System.arraycopy(cmds, 0, newCmds, 1, cmds.length);
                    newCmds[0] = cmd;
                    desc.setBuildSpec(newCmds);
                    project.setDescription(desc, null);
                    project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

