/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.editors;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorPage;

public class ModelEditorSelectionProvider
implements ISelectionProvider {
    private ModelEditor modelEditor;
    private ArrayList listeners = new ArrayList();
    private ISelection selection;
    ModelEditorPage sourcePage;
    private ISelectionChangedListener theSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent e) {
            if (ModelEditorSelectionProvider.this.isVisible(ModelEditorSelectionProvider.this.sourcePage)) {
                ModelEditorSelectionProvider.this.setSelection(e.getSelection());
            }
        }
    };

    public ModelEditorSelectionProvider(ModelEditor editor) {
        this.modelEditor = editor;
    }

    void setChangeEventsEnabled(boolean enable) {
    }

    public void setSourcePage(ModelEditorPage sourcePage) {
        ISelectionProvider sourceProvider;
        this.sourcePage = sourcePage;
        if (this.sourcePage != null && (sourceProvider = sourcePage.getModelObjectSelectionProvider()) != null) {
            sourceProvider.addSelectionChangedListener(this.theSelectionChangedListener);
        }
    }

    public ModelEditorPage getSourcePage() {
        return this.sourcePage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    public ISelection getSelection() {
        ISelectionProvider selectionProvider;
        if (this.sourcePage != null && this.isVisible(this.sourcePage) && (selectionProvider = this.sourcePage.getModelObjectSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return this.selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    public synchronized void setSelection(ISelection selection) {
        this.selection = selection;
        if (this.isActivePart()) {
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    public boolean isVisible(ModelEditorPage page) {
        return this.modelEditor.getCurrentPage() == page;
    }

    public void fireSelectionChanged(final SelectionChangedEvent event) {
        ArrayList copiedList = new ArrayList(this.listeners);
        final Iterator iter = copiedList.iterator();
        while (iter.hasNext()) {
            final ISelectionChangedListener l = (ISelectionChangedListener)iter.next();
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }

                public void handleException(Throwable e) {
                    super.handleException(e);
                    iter.remove();
                }
            });
        }
    }

    private boolean isActivePart() {
        return this.modelEditor.getEditorSite().getWorkbenchWindow().getPartService().getActivePart() == this.modelEditor;
    }
}

