/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.editors;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.refactor.ModelCopyCommand;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public class SaveAsDialog
extends ElementTreeSelectionDialog
implements UiConstants {
    private static final String TITLE = UiConstants.Util.getString("SaveAsDialog.title", new Object[0]);
    private static final String SELECT_MESSAGE = UiConstants.Util.getString("SaveAsDialog.message", new Object[0]);
    static final String FOLDER_MESSAGE = UiConstants.Util.getString("SaveAsDialog.folderOrProjectOnly", new Object[0]);
    static final String MODEL_PROJECT_MESSAGE = UiConstants.Util.getString("SaveAsDialog.notModelProject", new Object[0]);
    static final String CLOSED_PROJECT_MESSAGE = UiConstants.Util.getString("SaveAsDialog.closedProject", new Object[0]);
    static final String SAME_NAME_RESOURCE_IN_PROJECT_MESSAGE = UiConstants.Util.getString("SaveAsDialog.sameNameResourceInProject", new Object[0]);
    private static final String NAME_MESSAGE = UiConstants.Util.getString("SaveAsDialog.modelName", new Object[0]);
    private static final String EMPTY_STRING = "";
    private IResource resource;
    ModelCopyCommand command;
    Text fileNameText;

    public SaveAsDialog(Shell parent, ModelResource modelResource) {
        super(parent, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        this.init(modelResource);
    }

    private void init(ModelResource modelResource) {
        this.addFilter((ViewerFilter)new ModelingResourceFilter());
        this.command = new ModelCopyCommand();
        this.command.setModelToCopy(modelResource);
        this.resource = modelResource.getResource();
        this.setAllowMultiple(false);
        this.setTitle(TITLE);
        this.setMessage(SELECT_MESSAGE);
        super.setValidator((ISelectionStatusValidator)new SaveAsValidator());
        this.setInput(this.resource.getWorkspace().getRoot());
    }

    protected Control createDialogArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData panelData = new GridData(1808);
        panel.setLayoutData((Object)panelData);
        super.createDialogArea(panel);
        Label label = new Label(panel, 0);
        label.setText(NAME_MESSAGE);
        label.setFont(parent.getFont());
        this.fileNameText = WidgetFactory.createTextField((Composite)panel, (int)768, (String)this.getResourceName());
        GridData data = new GridData(768);
        data.heightHint = this.convertHeightInCharsToPixels(1);
        this.fileNameText.setLayoutData((Object)data);
        this.fileNameText.setText(this.getResourceName());
        label = new Label(panel, 0);
        label.setText(EMPTY_STRING);
        this.registerControls();
        return panel;
    }

    public void setValidator(ISelectionStatusValidator validator) {
    }

    public ModelCopyCommand getCommand() {
        return this.command;
    }

    protected IStatus setContainer(IContainer container) {
        this.command.setNewModelDestination(container, this.fileNameText.getText());
        return this.command.canExecute();
    }

    private String getResourceName() {
        return this.resource.getName().substring(0, this.resource.getName().indexOf(46));
    }

    private void registerControls() {
        this.fileNameText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
            }

            public void focusLost(FocusEvent event) {
                SaveAsDialog.this.updateOkButton();
            }
        });
        this.fileNameText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                SaveAsDialog.this.updateOkButton();
            }
        });
    }

    void updateOkButton() {
        this.updateOKStatus();
    }

    boolean isModelProject(IContainer container) {
        IProject project = container.getProject();
        if (project != null) {
            return ModelerCore.hasModelNature((IProject)project);
        }
        return false;
    }

    protected Label createMessageArea(Composite composite) {
        return super.createMessageArea(composite);
    }

    public class SaveAsValidator
    implements ISelectionStatusValidator {
        public IStatus validate(Object[] selection) {
            StringNameValidator validator;
            String msg;
            IStatus result = null;
            if (selection.length == 1 && selection[0] != null) {
                if (selection[0] instanceof IContainer) {
                    String currentName;
                    IContainer container = (IContainer)selection[0];
                    String newName = SaveAsDialog.this.fileNameText.getText();
                    if (StringUtilities.equals((String)newName, (String)(currentName = SaveAsDialog.this.resource.getProjectRelativePath().removeFileExtension().lastSegment())) && container.getProject() == SaveAsDialog.this.resource.getProject()) {
                        result = new Status(4, "org.teiid.designer.ui", 0, SAME_NAME_RESOURCE_IN_PROJECT_MESSAGE, null);
                    } else if (selection[0] instanceof IProject && !((IProject)selection[0]).isOpen()) {
                        result = new Status(4, "org.teiid.designer.ui", 0, CLOSED_PROJECT_MESSAGE, null);
                    } else if (SaveAsDialog.this.isModelProject((IContainer)selection[0])) {
                        result = SaveAsDialog.this.setContainer((IContainer)selection[0]);
                    } else {
                        SaveAsDialog.this.command.setNewModelDestination(null, SaveAsDialog.this.fileNameText.getText());
                        result = new Status(4, "org.teiid.designer.ui", 0, MODEL_PROJECT_MESSAGE, null);
                    }
                } else {
                    SaveAsDialog.this.command.setNewModelDestination(null, SaveAsDialog.this.fileNameText.getText());
                    result = new Status(4, "org.teiid.designer.ui", 0, FOLDER_MESSAGE, null);
                }
            } else {
                result = SaveAsDialog.this.setContainer(null);
            }
            if (result.getSeverity() == 4 && (msg = (validator = new StringNameValidator(null)).checkNameCharacters(SaveAsDialog.this.fileNameText.getText())) != null && msg.equals(result.getMessage())) {
                result = new StatusInfo("org.teiid.designer.ui", 4, Util.getString("SaveAsDialog.invalidCharacters", new Object[0]));
            }
            return result;
        }
    }
}

