/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.explorer;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.event.EventSourceException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.ResourceChangeUtilities;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.viewsupport.ExtendedModelObjectContentProvider;
import org.teiid.designer.ui.viewsupport.IExtendedModelObject;
import org.teiid.designer.ui.viewsupport.ImportContainer;
import org.teiid.designer.ui.viewsupport.ModelObjectContentProvider;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelExplorerContentProvider
extends WorkbenchContentProvider
implements UiConstants,
IPropertyChangeListener {
    private static final Object[] NO_CHILDREN = new Object[0];
    private boolean showModelContent = true;
    private boolean enableModelSorting = false;
    private boolean sortModelContent = false;
    private ModelObjectContentProvider modelProvider = ModelObjectContentProvider.getInstance();
    private boolean showImportStatements = true;
    private Map importContainerMap = new HashMap();
    private EventObjectListener modelListener;
    private IResourceChangeListener resourceListener;
    private IResourceDeltaVisitor deltaVisitor;
    private boolean keepProcessing = true;
    private ExtendedModelObjectContentProvider extendedContentProvider = new ExtendedModelObjectContentProvider();

    public ModelExplorerContentProvider() {
        this.deltaVisitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta theDelta) {
                return ModelExplorerContentProvider.this.handleDeltaVisit(theDelta);
            }
        };
        this.modelListener = new EventObjectListener(){

            public void processEvent(EventObject theEvent) {
                ModelExplorerContentProvider.this.handleModelEvents(theEvent);
            }
        };
        try {
            UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, this.modelListener);
        }
        catch (EventSourceException theException) {
            Util.log((Throwable)theException);
        }
        this.resourceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent theEvent) {
                ModelExplorerContentProvider.this.handleResourceEvent(theEvent);
            }
        };
        ModelerCore.getWorkspace().addResourceChangeListener(this.resourceListener);
        this.enableModelSorting = false;
        this.sortModelContent = this.getSortModelContentsPreferenceBooleanValue();
        UiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void setEnableModelSorting(boolean enableSort) {
        this.enableModelSorting = enableSort;
    }

    public boolean isModelSortingEnabled() {
        return this.enableModelSorting;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propStr = e.getProperty();
        if (propStr != null && propStr.equals("sortModelContents")) {
            this.sortModelContent = this.getSortModelContentsPreferenceBooleanValue();
        }
    }

    private boolean getSortModelContentsPreferenceBooleanValue() {
        boolean sortModelConents = false;
        String sortContentsStr = UiPlugin.getDefault().getPreferenceStore().getString("sortModelContents");
        if (sortContentsStr.equals("always")) {
            sortModelConents = true;
        } else if (sortContentsStr.equals("never")) {
            sortModelConents = false;
        }
        return sortModelConents;
    }

    void handleModelEvents(EventObject theEvent) {
        if (((ModelResourceEvent)theEvent).getType() == 2) {
            this.validateImportCache(((ModelResourceEvent)theEvent).getModelResource().getResource());
        }
    }

    void handleResourceEvent(IResourceChangeEvent theEvent) {
        this.keepProcessing = true;
        if (ResourceChangeUtilities.isPreClose((IResourceChangeEvent)theEvent) || ResourceChangeUtilities.isPreDelete((IResourceChangeEvent)theEvent)) {
            this.validateImportCache(theEvent.getResource());
            this.keepProcessing = false;
        } else {
            IResourceDelta delta = theEvent.getDelta();
            if (delta != null) {
                try {
                    delta.accept(this.deltaVisitor);
                }
                catch (CoreException theException) {
                    Util.log((Throwable)theException);
                }
            }
        }
    }

    private void validateImportCache(IResource theResource) {
        Iterator itr = this.importContainerMap.keySet().iterator();
        while (itr.hasNext()) {
            boolean remove = false;
            ModelAnnotation annotation = (ModelAnnotation)itr.next();
            if (annotation.eResource() == null) {
                remove = true;
            } else if (theResource != null) {
                ModelResource modelResource = ModelerCore.getModelEditor().findModelResource((EObject)annotation);
                if (modelResource == null) {
                    remove = true;
                } else {
                    IResource model = modelResource.getResource();
                    if (model == null) {
                        remove = true;
                    } else if (theResource instanceof IFile) {
                        remove = model.equals((Object)theResource);
                    } else if (theResource instanceof IProject) {
                        remove = model.getProject().equals((Object)theResource);
                    }
                }
            }
            if (!remove) continue;
            itr.remove();
        }
    }

    public boolean handleDeltaVisit(IResourceDelta theDelta) {
        if (this.keepProcessing && ResourceChangeUtilities.isRemoved((IResourceDelta)theDelta)) {
            boolean process = false;
            IResource resource = theDelta.getResource();
            if (resource == null) {
                process = true;
            } else if (ModelerCore.hasModelNature((IProject)resource.getProject())) {
                process = true;
            }
            if (process) {
                this.validateImportCache(null);
                this.keepProcessing = false;
            }
        }
        return this.keepProcessing;
    }

    public void dispose() {
        ModelerCore.getWorkspace().removeResourceChangeListener(this.resourceListener);
        try {
            UiPlugin.getDefault().getEventBroker().removeListener(ModelResourceEvent.class, this.modelListener);
        }
        catch (EventSourceException theException) {
            Util.log((Throwable)theException);
        }
        super.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] getChildren(Object parentElement) {
        Object[] children = NO_CHILDREN;
        try {
            IResource resource;
            if (parentElement instanceof EObject) {
                if (!this.enableModelSorting) return this.modelProvider.getChildren(parentElement);
                if (!this.sortModelContent) return this.modelProvider.getChildren(parentElement);
                return this.modelProvider.getSortedChildren(parentElement);
            }
            if (parentElement instanceof IProject) {
                if (!((IProject)parentElement).isOpen()) return NO_CHILDREN;
                return ((IProject)parentElement).members();
            }
            if (parentElement instanceof IResource && ModelUtilities.isModelFile(resource = (IResource)parentElement)) {
                try {
                    ModelResource modelResource = ModelUtil.getModelResource((IFile)((IFile)resource), (boolean)true);
                    if (!this.showModelContent) return NO_CHILDREN;
                    if (modelResource == null) return NO_CHILDREN;
                    children = this.enableModelSorting && this.sortModelContent ? this.modelProvider.getSortedChildren(modelResource) : this.modelProvider.getChildren(modelResource);
                    if (!this.showImportStatements) return children;
                    if (ModelUtil.isXsdFile((IResource)resource)) return children;
                    Object[] temp = children != null ? children : new Object[]{};
                    try {
                        ModelAnnotation annotation = modelResource.getModelAnnotation();
                        if (annotation == null) {
                            return temp;
                        }
                        children = new Object[temp.length + 1];
                        children[0] = this.getImportContainer(annotation);
                        int i = 0;
                        while (true) {
                            if (i >= temp.length) {
                                return children;
                            }
                            children[i + 1] = temp[i];
                            ++i;
                        }
                    }
                    catch (ModelWorkspaceException theException) {
                        if (modelResource.hasErrors()) return temp;
                        UiConstants.Util.log(4, (Throwable)theException, ((Object)((Object)theException)).getClass().getName());
                        return temp;
                    }
                    catch (Exception theException) {
                        UiConstants.Util.log(4, (Throwable)theException, theException.getClass().getName());
                        return temp;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (parentElement instanceof ImportContainer) {
                return ((ImportContainer)parentElement).getModelAnnotation().getModelImports().toArray();
            }
            if (parentElement instanceof IContainer) {
                return ((IContainer)parentElement).members();
            }
            if (!(parentElement instanceof IExtendedModelObject)) return children;
            return this.extendedContentProvider.getChildren(parentElement);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return children;
        }
    }

    private ImportContainer getImportContainer(ModelAnnotation theAnnotation) {
        ImportContainer result = (ImportContainer)this.importContainerMap.get(theAnnotation);
        if (result == null) {
            result = new ImportContainer(theAnnotation, theAnnotation.eResource());
            this.importContainerMap.put(theAnnotation, result);
        }
        return result;
    }

    public Object getParent(Object element) {
        Object parent = null;
        if (element instanceof ModelImport) {
            parent = ((ModelImport)element).eContainer();
            if (parent instanceof ModelAnnotation) {
                parent = this.getImportContainer((ModelAnnotation)parent);
            }
        } else {
            parent = element instanceof ImportContainer ? this.getParent(((ImportContainer)element).getModelAnnotation()) : (element instanceof EObject ? this.modelProvider.getParent(element) : (this.extendedContentProvider.getParent(element) != null ? this.extendedContentProvider.getParent(element) : super.getParent(element)));
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            if (ModelUtilities.isModelFile(resource)) {
                return this.showModelContent;
            }
        } else {
            if (element instanceof EObject) {
                return this.modelProvider.hasChildren(element);
            }
            if (element instanceof IExtendedModelObject) {
                return this.extendedContentProvider.hasChildren(element);
            }
        }
        return super.hasChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void setShowModelContent(boolean show) {
        this.showModelContent = show;
    }

    public void setShowImportStatements(boolean show) {
        this.showImportStatements = show;
    }
}

