/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.explorer;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.ui.views.navigator.NavigatorDragAdapter;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.util.EObjectTransfer;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelExplorerDragAdapter
extends NavigatorDragAdapter
implements UiConstants {
    protected ISelectionProvider selectionProvider;

    public ModelExplorerDragAdapter(ISelectionProvider theProvider) {
        super(theProvider);
        this.selectionProvider = theProvider;
    }

    public void dragStart(DragSourceEvent theEvent) {
        super.dragStart(theEvent);
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        EObjectTransfer.getInstance().setObject(null);
        if (!selection.isEmpty()) {
            theEvent.doit = true;
            theEvent.detail = 0;
            if (SelectionUtilities.isAllEObjects((ISelection)selection)) {
                ArrayList selectedEObjects = new ArrayList(SelectionUtilities.getSelectedEObjects((ISelection)selection));
                if (ModelEditorManager.getOpenResources().isEmpty()) {
                    theEvent.doit = false;
                }
                if (theEvent.doit) {
                    EObjectTransfer.getInstance().setObject(selectedEObjects);
                }
            } else {
                for (Object next : selection) {
                    if (next instanceof IResource && this.isInvalidDragSource((IResource)next)) {
                        theEvent.doit = false;
                    }
                    if (!theEvent.doit) break;
                }
            }
        }
    }

    public void dragFinished(DragSourceEvent theEvent) {
    }

    private boolean isInvalidDragSource(IResource theResource) {
        boolean result;
        block8: {
            result = false;
            if (theResource instanceof IFile) {
                if (ModelUtilities.isModelFile(theResource) || ModelUtil.isVdbArchiveFile((IResource)theResource) || ModelUtil.isXsdFile((IResource)theResource)) {
                    result = theResource.getProject() == null;
                }
            } else if (theResource instanceof IFolder) {
                try {
                    IResource[] contents = ((IFolder)theResource).members(false);
                    if (contents == null || contents.length <= 0) break block8;
                    int i = 0;
                    while (i < contents.length) {
                        if (this.isInvalidDragSource(contents[i])) {
                            result = true;
                            break;
                        }
                        ++i;
                    }
                }
                catch (CoreException theException) {
                    Util.log((Throwable)theException);
                }
            }
        }
        return result;
    }
}

