/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.explorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.views.navigator.NavigatorDropAdapter;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.widget.ListMessageDialog;

public class ModelExplorerDropAdapter
extends NavigatorDropAdapter {
    public ModelExplorerDropAdapter(StructuredViewer viewer) {
        super(viewer);
    }

    public void drop(DropTargetEvent event) {
        Object data = event.data;
        try {
            if (data instanceof IResource) {
                if (DotProjectUtils.getDotProjectCount((IResource)((IResource)data), (boolean)true, (boolean)false) > 0) {
                    ErrorDialog.openError((Shell)this.getViewer().getControl().getShell(), (String)UiConstants.Util.getString("ModelExplorerDropAdapter.dotProjectResourceDropErrorTitle", new Object[0]), (String)UiConstants.Util.getString("ModelExplorerDropAdapter.dotProjectResourceDropErrorMessage", new Object[0]), null);
                    event.detail = 0;
                } else {
                    this.performDrop(data);
                }
            } else {
                String[] files = (String[])data;
                ArrayList<String> projects = new ArrayList<String>();
                ArrayList<String> nonProjectFiles = new ArrayList<String>();
                ArrayList<String> invalidProjects = new ArrayList<String>();
                int i = 0;
                while (i < files.length) {
                    int projectCount = DotProjectUtils.getDotProjectCount((String)files[i], (boolean)true, (boolean)false);
                    if (projectCount == 1) {
                        if (DotProjectUtils.getDotProjectCount((String)files[i], (boolean)false, (boolean)false) == 1) {
                            if (files[i].indexOf(".project") > 0) {
                                invalidProjects.add(files[i]);
                            } else {
                                projects.add(files[i]);
                            }
                        }
                    } else if (projectCount == 0) {
                        nonProjectFiles.add(files[i]);
                    } else {
                        invalidProjects.add(files[i]);
                    }
                    ++i;
                }
                if (nonProjectFiles.size() > 0 && (projects.size() > 0 || invalidProjects.size() > 0)) {
                    MessageBox messageBox = new MessageBox(this.getViewer().getControl().getShell(), 196);
                    messageBox.setMessage(UiConstants.Util.getString("ModelExplorerDropAdapter.mixedDropQuestion", new Object[0]));
                    int rc = messageBox.open();
                    if (rc == 64) {
                        this.handleProjectImport(projects, invalidProjects);
                    } else {
                        event.detail = 0;
                    }
                } else if (nonProjectFiles.size() > 0) {
                    this.performDrop(nonProjectFiles.toArray(new String[0]));
                } else {
                    this.handleProjectImport(projects, invalidProjects);
                }
            }
        }
        catch (Exception exception) {
            event.detail = 0;
        }
    }

    private void handleProjectImport(ArrayList projects, ArrayList invalidProjects) {
        int i = 0;
        while (i < projects.size()) {
            this.createExistingProject((String)projects.get(i));
            ++i;
        }
        if (invalidProjects.size() > 0) {
            ListMessageDialog.openError((Shell)this.getViewer().getControl().getShell(), (String)UiConstants.Util.getString("ModelExplorerDropAdapter.invalidProjectErrorTitle", new Object[0]), null, (String)UiConstants.Util.getString("ModelExplorerDropAdapter.invalidProjectErrorMessage", new Object[0]), (List)invalidProjects, null);
        }
    }

    private void createExistingProject(String projectFolder) {
        try {
            final IProjectDescription description = ModelerCore.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(projectFolder) + "//.project"));
            final IProject project = ModelerCore.getWorkspace().getRoot().getProject(description.getName());
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    monitor.beginTask("", 2000);
                    project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
            };
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getViewer().getControl().getShell());
            dialog.run(true, true, (IRunnableWithProgress)op);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

