/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.favorites;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.event.EventSourceException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.IModelerCacheListener;
import org.teiid.designer.ui.ModelerCacheEvent;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.favorites.ModelerCacheEventManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public final class EObjectModelerCache
extends AbstractSet
implements UiConstants {
    private HashSet cache = new HashSet();
    private ModelerCacheEventManager eventMgr = new ModelerCacheEventManager(this);

    public EObjectModelerCache() {
        ModelUtilities.addNotifyChangedListener(this.eventMgr);
        ModelerCore.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.eventMgr);
        try {
            UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, (EventObjectListener)this.eventMgr);
        }
        catch (EventSourceException e) {
            UiConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    @Override
    public boolean add(Object theEObject) {
        CoreArgCheck.isNotNull((Object)theEObject);
        CoreArgCheck.isInstanceOf(EObject.class, (Object)theEObject);
        boolean result = this.cache.add(theEObject);
        if (result) {
            this.eventMgr.fireCacheEvent(new ModelerCacheEvent(0, theEObject));
        }
        return result;
    }

    @Override
    public boolean addAll(Collection theEObjects) {
        CoreArgCheck.isNotNull((Object)theEObjects);
        boolean result = false;
        if (!theEObjects.isEmpty()) {
            ArrayList addedObjs = new ArrayList(theEObjects.size());
            for (Object obj : theEObjects) {
                CoreArgCheck.isInstanceOf(EObject.class, obj);
                if (!this.cache.add(obj)) continue;
                addedObjs.add(obj);
                if (result) continue;
                result = true;
            }
            if (result) {
                this.eventMgr.fireCacheEvent(new ModelerCacheEvent(0, addedObjs));
            }
        }
        return result;
    }

    public void addCacheListener(IModelerCacheListener theListener) {
        this.eventMgr.addListener(theListener);
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.cache.clear();
            this.eventMgr.fireCacheEvent(ModelerCacheEvent.CLEAR_CACHE_EVENT);
        }
    }

    @Override
    public boolean contains(Object theEObject) {
        return this.cache.contains(theEObject);
    }

    public Collection getCachedDescendants(EObject theAncestor) {
        EList kids;
        HashSet<EObject> result = Collections.EMPTY_SET;
        if (!this.isEmpty() && (kids = theAncestor.eContents()) != null && !kids.isEmpty()) {
            int size = kids.size();
            int i = 0;
            while (i < size) {
                Collection temp;
                EObject kid = (EObject)kids.get(i);
                if (this.contains(kid)) {
                    if (result.isEmpty()) {
                        result = new HashSet<EObject>();
                    }
                    result.add(kid);
                }
                if (!(temp = this.getCachedDescendants(kid)).isEmpty()) {
                    if (result.isEmpty()) {
                        result = new HashSet();
                    }
                    result.addAll(temp);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return this.cache.iterator();
    }

    @Override
    public boolean remove(Object theEObject) {
        boolean result = this.cache.remove(theEObject);
        if (result) {
            this.eventMgr.fireCacheEvent(new ModelerCacheEvent(1, theEObject));
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection theEObjects) {
        CoreArgCheck.isNotNull((Object)theEObjects);
        boolean result = false;
        if (!theEObjects.isEmpty()) {
            ArrayList removedObjs = new ArrayList(theEObjects.size());
            for (Object obj : theEObjects) {
                if (!this.cache.remove(obj)) continue;
                removedObjs.add(obj);
                if (result) continue;
                result = true;
            }
            if (result) {
                this.eventMgr.fireCacheEvent(new ModelerCacheEvent(1, removedObjs));
            }
        }
        return result;
    }

    public void removeCacheListener(IModelerCacheListener theListener) {
        this.eventMgr.removeListener(theListener);
    }

    @Override
    public boolean retainAll(Collection theEObjects) {
        boolean result = false;
        if (!this.isEmpty()) {
            ArrayList removedObjs = new ArrayList();
            Iterator itr = this.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (theEObjects.contains(obj)) continue;
                itr.remove();
                removedObjs.add(obj);
                result = true;
            }
            if (result) {
                this.eventMgr.fireCacheEvent(new ModelerCacheEvent(1, removedObjs));
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Object[] toArray() {
        return this.cache.toArray();
    }

    @Override
    public Object[] toArray(Object[] theEObjects) {
        return this.cache.toArray(theEObjects);
    }
}

