/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.favorites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.IModelerCacheListener;
import org.teiid.designer.ui.ModelerCacheEvent;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.IModelObjectActionContributor;
import org.teiid.designer.ui.actions.ModelerActionService;
import org.teiid.designer.ui.common.actions.ExtendedMenuManager;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.OrderableViewerSorter;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.AbstractTableLabelProvider;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.favorites.EObjectModelerCache;
import org.teiid.designer.ui.properties.ModelObjectPropertySourceProvider;
import org.teiid.designer.ui.search.ModelObjectFinderDialog;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class FavoritesView
extends ViewPart
implements ISelectionProvider,
ISelectionListener,
IModelerCacheListener,
CoreStringUtil.Constants {
    private static final int NAME_COLUMN = 0;
    private static final int LOCATION_COLUMN = 1;
    private static final String ADD_TO_FAVORITES = "action.add.tooltip2";
    private ModelObjectPropertySourceProvider propertySourceProvider;
    ILabelProvider nameLabelProvider = ModelUtilities.getModelObjectLabelProvider();
    private ArrayList listenerList = new ArrayList();
    TableViewer tableViewer;
    private boolean controlCreated = false;
    private EObjectModelerCache eObjCache;
    ISelection externalSelection;
    private ModelerActionService actionService;
    EventObjectListener modelResourceListener;
    private Action clearAction;
    private Action openAction;
    private Action editAction;
    private Action addAction;
    private Action removeAction;
    private Action selectAllAction;
    private Action deselectAllAction;
    private Action findAction;

    private static String getString(String stringId) {
        return UiConstants.Util.getString("FavoritesView." + stringId, new Object[0]);
    }

    private static String getString(String stringId, Object value, Object value1) {
        if (value == null) {
            return FavoritesView.getString(stringId);
        }
        if (value1 == null) {
            return UiConstants.Util.getString("FavoritesView." + stringId, value);
        }
        return UiConstants.Util.getString("FavoritesView." + stringId, new Object[]{value, value1});
    }

    public void createPartControl(Composite parent) {
        this.controlCreated = true;
        this.initTableViewer(parent);
        ExtendedMenuManager popupMenuManager = new ExtendedMenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                FavoritesView.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Menu menu = popupMenuManager.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu((MenuManager)popupMenuManager, (ISelectionProvider)this.tableViewer);
        this.initActions();
        this.fillToolBar();
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.eObjCache = UiPlugin.getDefault().getEObjectCache();
        this.eObjCache.addCacheListener(this);
        this.tableViewer.setInput((Object)this);
        this.setActionsState();
        this.packTable();
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        ISelection selection = this.getSite().getWorkbenchWindow().getSelectionService().getSelection();
        if (selection != null) {
            this.selectionChanged((IWorkbenchPart)this, selection);
        }
    }

    public void initTableViewer(Composite parent) {
        this.tableViewer = WidgetFactory.createTableViewer((Composite)parent, (int)66306);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        WidgetFactory.createTableColumn((Table)table, (String)FavoritesView.getString("columns.name"));
        WidgetFactory.createTableColumn((Table)table, (String)FavoritesView.getString("columns.location"));
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return UiPlugin.getDefault().getEObjectCache().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AbstractTableLabelProvider(){

            public Image getColumnImage(Object element, int column) {
                if (column == 0) {
                    return FavoritesView.this.nameLabelProvider.getImage(element);
                }
                return null;
            }

            public String getColumnText(Object element, int column) {
                switch (column) {
                    case 0: {
                        return FavoritesView.this.nameLabelProvider.getText(element);
                    }
                    case 1: {
                        return ModelerCore.getModelEditor().getFullPathToParent((EObject)element).makeRelative().toString();
                    }
                }
                return "";
            }
        });
        this.tableViewer.setSorter((ViewerSorter)new OrderableViewerSorter());
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EObject eObj;
                if (SelectionUtilities.isSingleSelection((ISelection)event.getSelection()) && (eObj = SelectionUtilities.getSelectedEObject((ISelection)event.getSelection())) != null) {
                    ModelEditorManager.open(eObj, true);
                }
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FavoritesView.this.handleSelectionChanged(event.getSelection());
            }
        });
    }

    private ImageDescriptor getImageDescriptor(String imageId) {
        return UiPlugin.getDefault().getImageDescriptor(imageId);
    }

    private void initActions() {
        this.editAction = new Action(FavoritesView.getString("action.edit")){

            public void run() {
                EObject eObj;
                if (SelectionUtilities.isSingleSelection((ISelection)FavoritesView.this.getSelection()) && (eObj = SelectionUtilities.getSelectedEObject((ISelection)FavoritesView.this.getSelection())) != null) {
                    ModelEditorManager.edit(eObj);
                }
            }
        };
        this.editAction.setEnabled(false);
        this.openAction = new Action(FavoritesView.getString("action.open")){

            public void run() {
                EObject eObj;
                if (SelectionUtilities.isSingleSelection((ISelection)FavoritesView.this.getSelection()) && (eObj = SelectionUtilities.getSelectedEObject((ISelection)FavoritesView.this.getSelection())) != null) {
                    ModelEditorManager.open(eObj, true);
                }
            }
        };
        this.openAction.setEnabled(false);
        this.selectAllAction = new Action(FavoritesView.getString("action.selectAll")){

            public void run() {
                FavoritesView.this.tableViewer.getTable().selectAll();
            }
        };
        this.selectAllAction.setEnabled(false);
        this.deselectAllAction = new Action(FavoritesView.getString("action.deselectAll")){

            public void run() {
                FavoritesView.this.tableViewer.getTable().deselectAll();
            }
        };
        this.deselectAllAction.setEnabled(false);
        this.addAction = new Action(FavoritesView.getString("action.add")){

            public void run() {
                List addedObjs;
                if (FavoritesView.this.externalSelection != null && !(addedObjs = SelectionUtilities.getSelectedEObjects((ISelection)FavoritesView.this.externalSelection)).isEmpty()) {
                    UiPlugin.getDefault().getEObjectCache().addAll((Collection)addedObjs);
                }
            }
        };
        this.addAction.setImageDescriptor(this.getImageDescriptor("icons/full/cview16/add.gif"));
        this.addAction.setToolTipText(FavoritesView.getString("action.add.tooltip"));
        this.removeAction = new Action(FavoritesView.getString("action.remove")){

            public void run() {
                UiPlugin.getDefault().getEObjectCache().removeAll(FavoritesView.this.getSelectedEObjects());
            }
        };
        this.removeAction.setEnabled(false);
        this.removeAction.setImageDescriptor(this.getImageDescriptor("icons/full/cview16/remove.gif"));
        this.removeAction.setToolTipText(FavoritesView.getString("action.remove.tooltip"));
        this.clearAction = new Action(FavoritesView.getString("action.clear")){

            public void run() {
                UiPlugin.getDefault().getEObjectCache().clear();
            }
        };
        this.clearAction.setEnabled(false);
        this.clearAction.setImageDescriptor(this.getImageDescriptor("icons/full/cview16/clear.gif"));
        this.clearAction.setToolTipText(FavoritesView.getString("action.clear.tooltip"));
        this.findAction = new Action(FavoritesView.getString("action.find")){

            public void run() {
                Collection addedObjs = FavoritesView.this.findObjects();
                if (!addedObjs.isEmpty()) {
                    UiPlugin.getDefault().getEObjectCache().addAll(addedObjs);
                }
            }
        };
        this.findAction.setImageDescriptor(this.getImageDescriptor("icons/full/cview16/find_metadata.gif"));
        this.findAction.setToolTipText(FavoritesView.getString("action.find.tooltip"));
    }

    void setActionsState() {
        int nRows = this.tableViewer.getTable().getSelectionCount();
        boolean rowsSelected = nRows > 0;
        boolean allRowsSelected = nRows == this.tableViewer.getTable().getItems().length;
        boolean tableHasRows = this.tableViewer.getTable().getItems().length > 0;
        this.removeAction.setEnabled(rowsSelected);
        this.deselectAllAction.setEnabled(rowsSelected);
        this.selectAllAction.setEnabled(!allRowsSelected);
        this.clearAction.setEnabled(tableHasRows);
        boolean enableEdit = false;
        if (nRows == 1) {
            EObject eObj = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
            if (eObj != null) {
                enableEdit = ModelEditorManager.canEdit(eObj);
            }
            this.openAction.setEnabled(true);
        }
        this.editAction.setEnabled(enableEdit);
        this.setAddActionState((IWorkbenchPart)this);
    }

    private void setAddActionState(IWorkbenchPart part) {
        boolean enable = false;
        if (part != this) {
            if (this.externalSelection != null) {
                List selectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.externalSelection);
                if (!selectedEObjects.isEmpty()) {
                    int size = selectedEObjects.size();
                    String title = part.getTitle();
                    if (part instanceof ModelEditor) {
                        title = ((ModelEditor)part).getCurrentPage().getTitle();
                    }
                    String tString = FavoritesView.getString(ADD_TO_FAVORITES, Integer.toString(size), title);
                    enable = true;
                    this.addAction.setToolTipText(tString);
                }
            } else {
                this.addAction.setToolTipText(FavoritesView.getString("action.add.tooltip"));
            }
        }
        this.addAction.setEnabled(enable);
    }

    private void fillToolBar() {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IAction)this.findAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.addAction);
        tbm.add((IAction)this.removeAction);
        tbm.add((IAction)this.clearAction);
    }

    private void packTable() {
        WidgetUtil.pack((Table)this.tableViewer.getTable());
    }

    public void dispose() {
        this.eObjCache.removeCacheListener(this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.openAction);
        manager.add((IAction)this.editAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.selectAllAction);
        manager.add((IAction)this.deselectAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.findAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.removeAction);
        manager.add((IAction)this.clearAction);
        manager.add((IContributionItem)new Separator("additions"));
        this.contributePermanentActionsToContextMenu(manager);
    }

    public void setFocus() {
        if (this.controlCreated) {
            this.tableViewer.getControl().setFocus();
        }
    }

    void handleSelectionChanged(ISelection selection) {
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        this.setActionsState();
    }

    public void addItem(Object item) {
        this.addItems(new Object[]{item});
    }

    public void addItems(Object[] items) {
        if (items.length > 0) {
            this.tableViewer.add(items);
            this.setSelection((ISelection)new StructuredSelection(items));
        }
        this.setActionsState();
        this.packTable();
    }

    public void removeItems(Object[] items) {
        if (!this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.remove(items);
            this.setActionsState();
            this.packTable();
        }
    }

    public void removeAllItems() {
        this.tableViewer.refresh();
    }

    public void removeItem(Object item) {
        this.removeItems(new Object[]{item});
    }

    Collection getSelectedEObjects() {
        List selected = SelectionUtilities.getSelectedEObjects((ISelection)this.tableViewer.getSelection());
        if (selected == null || selected.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return selected;
    }

    Collection findObjects() {
        Object[] selectedEOList;
        Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
        ModelObjectFinderDialog dialog = new ModelObjectFinderDialog(shell);
        dialog.open();
        if (dialog.getReturnCode() == 0 && (selectedEOList = dialog.getResult()) != null && selectedEOList.length > 0) {
            ArrayList<Object> newList = new ArrayList<Object>(selectedEOList.length);
            int i = 0;
            while (i < selectedEOList.length) {
                newList.add(selectedEOList[i]);
                ++i;
            }
            return newList;
        }
        return Collections.EMPTY_LIST;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listenerList.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.tableViewer.setSelection(selection, true);
        this.setActionsState();
    }

    private void fireSelectionChanged(SelectionChangedEvent event) {
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            ((ISelectionChangedListener)iter.next()).selectionChanged(event);
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            if (this.propertySourceProvider == null) {
                this.propertySourceProvider = ModelUtilities.getPropertySourceProvider();
            }
            return this.propertySourceProvider.getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    @Override
    public void cacheChanged(final ModelerCacheEvent theEvent) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FavoritesView.this.tableViewer.getControl().isDisposed()) {
                    if (theEvent.isClear()) {
                        FavoritesView.this.removeAllItems();
                    } else if (theEvent.isAdd()) {
                        FavoritesView.this.addItems(theEvent.toArray());
                    } else if (theEvent.isDelete()) {
                        FavoritesView.this.removeItems(theEvent.toArray());
                    } else if (theEvent.isChange()) {
                        Object[] changedElements = theEvent.toArray();
                        FavoritesView.this.updateForChange(changedElements);
                    }
                    FavoritesView.this.setActionsState();
                }
            }
        });
    }

    void updateForChange(Object[] changedElements) {
        int i = 0;
        while (i < changedElements.length) {
            Object obj = changedElements[i];
            this.tableViewer.refresh(obj, true);
            ++i;
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != this) {
            this.externalSelection = selection;
            this.setAddActionState(part);
        }
    }

    public void contributePermanentActionsToContextMenu(IMenuManager theMenuMgr) {
        List contributors = this.getActionService().getModelObjectActionContributors();
        ISelection selection = this.getSelection();
        if (selection != null && !selection.isEmpty() || !SelectionUtilities.isSingleSelection((ISelection)selection)) {
            int size = contributors.size();
            int i = 0;
            while (i < size) {
                IModelObjectActionContributor contributor = (IModelObjectActionContributor)contributors.get(i);
                contributor.contributeToContextMenu(theMenuMgr, this.getSelection());
                ++i;
            }
        }
    }

    private ModelerActionService getActionService() {
        if (this.actionService == null) {
            this.actionService = (ModelerActionService)UiPlugin.getDefault().getActionService(this.getSite().getPage());
        }
        return this.actionService;
    }
}

