/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.filter;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.filter.StructuredViewerFilterer;

public class StructuredViewerDatatypeFilterer
extends StructuredViewerFilterer
implements IFilter {
    private static final String GROUP_TITLE = UiConstants.Util.getString("StructuredViewerDatatypeFilterer.title", new Object[0]);
    private static final String BUTTON_BUILTIN = UiConstants.Util.getString("StructuredViewerDatatypeFilterer.builtin", new Object[0]);
    private static final String BUTTON_USERDEF = UiConstants.Util.getString("StructuredViewerDatatypeFilterer.userdef", new Object[0]);
    Button bltBtn;
    Button usrBtn;
    boolean showUser = true;
    private boolean showSimple = true;
    boolean showBuiltin = true;

    public void setAllowSimple(boolean allow) {
        this.showSimple = allow;
        if (this.bltBtn != null) {
            this.updateFilter();
        }
    }

    @Override
    public Control addControl(Composite parent, FormToolkit ftk) {
        Group grp = new Group(parent, 0);
        if (ftk != null) {
            ftk.adapt((Composite)grp);
        }
        grp.setText(GROUP_TITLE);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        grp.setLayout((Layout)gl);
        this.bltBtn = this.createButton((Composite)grp, ftk, BUTTON_BUILTIN);
        this.bltBtn.setSelection(true);
        this.usrBtn = this.createButton((Composite)grp, ftk, BUTTON_USERDEF);
        this.usrBtn.setSelection(true);
        SelectionListener sl = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredViewerDatatypeFilterer.this.showUser = StructuredViewerDatatypeFilterer.this.usrBtn.getSelection();
                StructuredViewerDatatypeFilterer.this.showBuiltin = StructuredViewerDatatypeFilterer.this.bltBtn.getSelection();
                StructuredViewerDatatypeFilterer.this.scheduleUpdate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.bltBtn.addSelectionListener(sl);
        this.usrBtn.addSelectionListener(sl);
        this.updateFilter();
        return grp;
    }

    private Button createButton(Composite parent, FormToolkit ftk, String text) {
        Button btn;
        if (ftk != null) {
            btn = ftk.createButton(parent, text, 32);
        } else {
            btn = new Button(parent, 32);
            btn.setText(text);
        }
        return btn;
    }

    @Override
    protected ViewerFilter createViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return StructuredViewerDatatypeFilterer.this.select(element);
            }
        };
    }

    @Override
    protected IFilter createVirtualFilter() {
        return this;
    }

    public boolean select(Object toTest) {
        if (this.showBuiltin && this.showUser && this.showSimple) {
            return true;
        }
        if (!(this.showBuiltin || this.showUser || this.showSimple)) {
            return false;
        }
        XSDSimpleTypeDefinition std = (XSDSimpleTypeDefinition)toTest;
        boolean isBuiltin = ModelerCore.getBuiltInTypesManager().isBuiltInDatatype((EObject)std);
        if (isBuiltin) {
            return this.showBuiltin;
        }
        if (this.showUser) {
            return this.showSimple || ModelerCore.getDatatypeManager((EObject)std).isEnterpriseDatatype((EObject)std);
        }
        return false;
    }
}

