/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.filter;

import java.util.regex.Pattern;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.filter.StructuredViewerFilterer;

public class StructuredViewerTextFilterer
extends StructuredViewerFilterer
implements IFilter {
    public static final String DEFAULT_PROMPT = UiConstants.Util.getString("StructuredViewerTextFilterer.defaultPromptText", new Object[0]);
    public static final String DEFAULT_CLEAR = UiConstants.Util.getString("StructuredViewerTextFilterer.defaultClearButton", new Object[0]);
    private final String promptText;
    private final String clearText;
    private final Image clearIcon;
    private ILabelProvider lProvider;
    Text text;
    private Button clrBtn;
    Pattern filter;

    public StructuredViewerTextFilterer(String promptText, String clearText) {
        this(promptText, clearText, null, null);
    }

    public StructuredViewerTextFilterer(String promptText, String clearText, ILabelProvider labelProvider) {
        this(promptText, clearText, null, labelProvider);
    }

    public StructuredViewerTextFilterer(String promptText, String clearText, Image clearIcon) {
        this(promptText, clearText, clearIcon, null);
    }

    public StructuredViewerTextFilterer(String promptText, String clearText, Image clearIcon, ILabelProvider labelProvider) {
        this.promptText = promptText;
        this.clearText = clearText;
        this.clearIcon = clearIcon;
        this.lProvider = labelProvider;
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.lProvider = provider;
    }

    @Override
    public Control addControl(Composite parent, FormToolkit ftk) {
        Composite grp = ftk != null ? ftk.createComposite(parent) : new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        grp.setLayout((Layout)gl);
        if (ftk != null) {
            this.text = ftk.createText(grp, this.promptText, 2048);
        } else {
            this.text = new Text(grp, 2048);
            this.text.setText(this.promptText);
        }
        this.text.addModifyListener((ModifyListener)new MyModifyListener());
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).StructuredViewerTextFilterer.this.text.isDisposed()) {
                            (this).StructuredViewerTextFilterer.this.text.selectAll();
                        }
                    }
                });
            }

            public void focusLost(FocusEvent e) {
                StructuredViewerTextFilterer.this.text.clearSelection();
            }
        });
        this.text.setLayoutData((Object)new GridData(768));
        this.text.selectAll();
        if (ftk != null) {
            this.clrBtn = ftk.createButton(grp, this.clearText, 0);
        } else {
            this.clrBtn = new Button(grp, 0x800000);
            this.clrBtn.setText(this.clearText);
        }
        if (this.clearIcon != null) {
            this.clrBtn.setImage(this.clearIcon);
        }
        this.clrBtn.addSelectionListener((SelectionListener)new MyButtonListener());
        return grp;
    }

    @Override
    protected ViewerFilter createViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return StructuredViewerTextFilterer.this.select(element);
            }
        };
    }

    @Override
    protected IFilter createVirtualFilter() {
        return this;
    }

    public synchronized boolean select(Object toTest) {
        if (this.filter != null) {
            String itemValue = this.lProvider.getText(toTest);
            return this.filter.matcher(itemValue).matches();
        }
        return true;
    }

    final class MyButtonListener
    implements SelectionListener {
        MyButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            StructuredViewerTextFilterer.this.text.setText("");
            StructuredViewerTextFilterer.this.updateFilter();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    final class MyModifyListener
    implements ModifyListener {
        MyModifyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modifyText(ModifyEvent e) {
            String filterText = StructuredViewerTextFilterer.this.text.getText();
            StructuredViewerTextFilterer structuredViewerTextFilterer = StructuredViewerTextFilterer.this;
            synchronized (structuredViewerTextFilterer) {
                StructuredViewerTextFilterer.this.filter = filterText.length() > 0 ? CoreStringUtil.createPattern((String)(String.valueOf(filterText) + "*"), (boolean)false) : null;
            }
            StructuredViewerTextFilterer.this.scheduleUpdate();
        }
    }
}

