/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.forms;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.LinkedComponentSet;

public class ComponentCategory
implements Cloneable {
    private final String name;
    private final String id;
    private final String description;
    private final boolean userCollapsable;
    private List componentSets = new ArrayList();
    private Section section;
    private Composite sectionBody;
    private ScrolledForm formParent;
    private boolean visible = true;
    private boolean enabled = true;

    public ComponentCategory(String id, String name, String description, boolean userCollapsable) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.userCollapsable = userCollapsable;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUserCollapsable() {
        return this.userCollapsable;
    }

    public Composite addFormControl(final ScrolledForm parentForm, FormToolkit ftk) {
        this.formParent = parentForm;
        int containedCount = this.componentSets.size();
        if (this.name.length() > 0) {
            int sectionStyle = 256;
            if (containedCount > 0) {
                sectionStyle |= 0x40;
            }
            if (this.userCollapsable) {
                sectionStyle |= 2;
            }
            if (this.description.length() > 0) {
                sectionStyle |= 0x80;
            }
            this.section = ftk.createSection(parentForm.getBody(), sectionStyle);
            this.section.setText(this.name);
            this.section.setDescription(this.description);
            if (this.userCollapsable) {
                this.section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                    public void expansionStateChanged(ExpansionEvent e) {
                        parentForm.reflow(true);
                    }
                });
            }
            this.sectionBody = ftk.createComposite((Composite)this.section);
        } else {
            this.sectionBody = ftk.createComposite(parentForm.getBody());
        }
        int columns = 0;
        int i = 0;
        while (i < containedCount) {
            LinkedComponentSet lcs = (LinkedComponentSet)this.componentSets.get(i);
            int colCnt = lcs.getControlCount();
            if (colCnt > columns) {
                columns = colCnt;
            }
            ++i;
        }
        TableWrapLayout tl = new TableWrapLayout();
        tl.numColumns = columns;
        this.sectionBody.setLayout((Layout)tl);
        int i2 = 0;
        while (i2 < containedCount) {
            LinkedComponentSet lcs = (LinkedComponentSet)this.componentSets.get(i2);
            lcs.addFormControls(this.sectionBody, ftk, columns);
            lcs.setEditible(this.enabled);
            ++i2;
        }
        this.sectionBody.pack(true);
        if (this.section != null) {
            this.section.setClient((Control)this.sectionBody);
            this.section.pack(true);
            this.section.setVisible(this.visible);
            this.section.setExpanded(this.visible);
            return this.section;
        }
        return this.sectionBody;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            if (this.formParent != null && !this.formParent.isDisposed()) {
                if (this.section != null) {
                    this.section.setExpanded(visible);
                    this.section.setVisible(visible);
                } else {
                    this.sectionBody.setVisible(visible);
                }
                this.formParent.reflow(true);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        int i = 0;
        while (i < this.componentSets.size()) {
            LinkedComponentSet lcs = (LinkedComponentSet)this.componentSets.get(i);
            lcs.setEditible(enabled);
            ++i;
        }
    }

    public void addComponentSet(LinkedComponentSet lcs) {
        this.componentSets.add(lcs);
    }

    public List getComponentSets() {
        return this.componentSets;
    }

    public void setMonitor(ComponentSetMonitor mon) {
        for (LinkedComponentSet lcs : this.componentSets) {
            lcs.setMonitor(mon);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ComponentCategory cc = (ComponentCategory)super.clone();
        cc.componentSets = new ArrayList(cc.componentSets);
        int i = 0;
        while (i < cc.componentSets.size()) {
            LinkedComponentSet lcs = (LinkedComponentSet)cc.componentSets.get(i);
            cc.componentSets.set(i, lcs.cloneSet());
            ++i;
        }
        return cc;
    }

    public void reflowForm() {
        if (this.formParent != null) {
            this.formParent.reflow(true);
        }
    }
}

