/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.forms;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.LinkedComponentSet;
import org.teiid.designer.ui.forms.SimpleComponentSet;

public class MultiComponentSet
extends SimpleComponentSet {
    private final LinkedComponentSet[] sets;
    private final int orientation;
    private Composite holder;

    public MultiComponentSet(String id, LinkedComponentSet[] sets, int orientation) {
        super(id, null);
        this.sets = sets;
        this.orientation = orientation;
    }

    @Override
    protected void addControls(Composite parent, FormToolkit ftk) {
        int i;
        int totalColumns;
        if (this.orientation == 512) {
            totalColumns = 1;
            i = 0;
            while (i < this.sets.length) {
                int controlCount = this.sets[i].getControlCount();
                if (controlCount > totalColumns) {
                    totalColumns = controlCount;
                }
                ++i;
            }
        } else {
            totalColumns = 0;
            i = 0;
            while (i < this.sets.length) {
                totalColumns += this.sets[i].getControlCount();
                ++i;
            }
        }
        this.holder = ftk.createComposite(parent);
        if (this.orientation == 512) {
            this.holder.setLayout((Layout)new FillLayout(512));
        } else {
            TableWrapLayout twl = new TableWrapLayout();
            twl.numColumns = totalColumns;
            twl.bottomMargin = 0;
            twl.leftMargin = 0;
            twl.rightMargin = 0;
            twl.topMargin = 0;
            this.holder.setLayout((Layout)twl);
        }
        this.holder.setLayoutData((Object)new TableWrapData(256, 256, 1, 2));
        int i2 = 0;
        while (i2 < this.sets.length) {
            if (this.orientation == 512) {
                this.sets[i2].addFormControls(this.holder, ftk, totalColumns);
            } else {
                this.sets[i2].addFormControls(this.holder, ftk, this.sets[i2].getControlCount());
            }
            ++i2;
        }
        if (this.orientation == 512) {
            Control[] controls = this.holder.getChildren();
            int i3 = 0;
            while (i3 < controls.length) {
                Control c = controls[i3];
                c.setLayoutData(null);
                ++i3;
            }
        }
    }

    @Override
    protected void addMonitor(ComponentSetMonitor monitor) {
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].setMonitor(monitor);
            ++i;
        }
    }

    @Override
    protected void removeMonitor(ComponentSetMonitor monitor) {
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].setMonitor(null);
            ++i;
        }
    }

    @Override
    public boolean isUserSet() {
        int i = 0;
        while (i < this.sets.length) {
            if (this.sets[i].isUserSet()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setValue(Object o) {
        if (o != null && o.getClass().isArray()) {
            Object[] array = (Object[])o;
            int i = 0;
            while (i < this.sets.length) {
                this.sets[i].setValue(array[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.sets.length) {
                this.sets[i].setValue(o);
                ++i;
            }
        }
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].reset();
            ++i;
        }
    }

    @Override
    public void setEditible(boolean enabled) {
        super.setEditible(enabled);
        if (this.holder != null) {
            this.holder.setEnabled(true);
        }
        int i = 0;
        while (i < this.sets.length) {
            this.sets[i].setEditible(enabled);
            ++i;
        }
    }

    @Override
    public int getControlCount() {
        return 2;
    }

    @Override
    public Object clone() {
        LinkedComponentSet[] lcss = new LinkedComponentSet[this.sets.length];
        int i = 0;
        while (i < this.sets.length) {
            lcss[i] = this.sets[i].cloneSet();
            ++i;
        }
        MultiComponentSet mcs = new MultiComponentSet(this.getID(), lcss, this.orientation);
        return mcs;
    }
}

