/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.forms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.teiid.designer.ui.forms.ComponentCategory;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.LinkedComponentSet;

public abstract class SimpleComponentSet
implements LinkedComponentSet {
    protected static final Control[] EMPTY_CONTROL_ARRAY = new Control[0];
    private final String labelText;
    private final String myid;
    private ComponentSetMonitor monitor;
    private Label lbl;
    private Control[] ctrls;
    private ComponentCategory cat;

    public SimpleComponentSet(String id, String labelName) {
        this.myid = id;
        this.labelText = labelName;
    }

    protected abstract void addControls(Composite var1, FormToolkit var2);

    protected abstract void addMonitor(ComponentSetMonitor var1);

    protected abstract void removeMonitor(ComponentSetMonitor var1);

    @Override
    public String getID() {
        return this.myid;
    }

    @Override
    public ComponentCategory getCategory() {
        return this.cat;
    }

    public String getLabelText() {
        return this.labelText;
    }

    @Override
    public void setCategory(ComponentCategory category) {
        this.cat = category;
    }

    @Override
    public int getControlCount() {
        if (this.labelText == null) {
            return 1;
        }
        return 2;
    }

    @Override
    public void addFormControls(Composite parent, FormToolkit ftk, int totalColumns) {
        TableWrapData twd;
        Control[] beforeKids = parent.getChildren();
        if (this.labelText != null) {
            this.lbl = ftk.createLabel(parent, this.labelText);
            TableWrapData twd2 = new TableWrapData(8, 16);
            this.lbl.setLayoutData((Object)twd2);
        }
        this.addControls(parent, ftk);
        this.ctrls = SimpleComponentSet.getChildDifference(parent.getChildren(), beforeKids);
        int myColumns = 0;
        int i = 0;
        while (i < this.ctrls.length) {
            twd = (TableWrapData)this.ctrls[i].getLayoutData();
            myColumns = twd != null ? (myColumns += twd.colspan) : ++myColumns;
            ++i;
        }
        if (myColumns < totalColumns) {
            Label comp = ftk.createLabel(parent, null);
            twd = new TableWrapData();
            twd.colspan = totalColumns - myColumns;
            comp.setLayoutData((Object)twd);
        }
        this.reset();
    }

    public static Control[] getChildDifference(Control[] after, Control[] before) {
        ArrayList<Control> big = new ArrayList<Control>(after.length);
        big.addAll(Arrays.asList(after));
        List<Control> small = Arrays.asList(before);
        big.removeAll(small);
        return big.toArray(EMPTY_CONTROL_ARRAY);
    }

    @Override
    public void setEditible(boolean enabled) {
        if (this.lbl != null) {
            this.lbl.setEnabled(enabled);
        }
        if (this.ctrls != null) {
            int i = 0;
            while (i < this.ctrls.length) {
                this.ctrls[i].setEnabled(enabled);
                ++i;
            }
        }
    }

    @Override
    public void setMonitor(ComponentSetMonitor csl) {
        if (this.monitor != null && this.monitor != csl) {
            this.removeMonitor(this.monitor);
        }
        this.monitor = csl;
        if (this.monitor != null) {
            this.addMonitor(this.monitor);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public LinkedComponentSet cloneSet() {
        try {
            return (LinkedComponentSet)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

