/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.forms;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.teiid.designer.ui.forms.ComponentSetEvent;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.DialogProvider;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.ui.forms.SimpleComponentSet;

public class TextComponentSet
extends SimpleComponentSet {
    private final int mystyle;
    Text text;
    private String lastSetValue;
    private MyModifyListener modList;
    final DialogProvider provider;

    public TextComponentSet(String id, String labelName, int style) {
        this(id, labelName, style, null);
    }

    public TextComponentSet(String id, String labelName, int style, DialogProvider provider) {
        super(id, labelName);
        this.mystyle = style;
        this.provider = provider;
    }

    @Override
    protected void addControls(Composite parent, FormToolkit ftk) {
        this.init();
        this.text = ftk.createText(parent, null, this.mystyle);
        TableWrapData twd = new TableWrapData(256, 256);
        this.text.setLayoutData((Object)twd);
        if ((this.mystyle & 2) != 0) {
            twd.heightHint = 50;
        }
        this.text.addModifyListener((ModifyListener)this.modList);
        if (this.provider != null) {
            Button b = ftk.createButton(parent, this.provider.getLaunchButtonText(), 0);
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextComponentSet.this.provider.showDialog(TextComponentSet.this.text.getShell(), TextComponentSet.this.getValue());
                    if (!TextComponentSet.this.provider.wasCancelled()) {
                        TextComponentSet.this.setValue(TextComponentSet.this.provider.getValue());
                    }
                }
            });
            twd = new TableWrapData(2, 16);
            b.setLayoutData((Object)twd);
        }
    }

    private void init() {
        if (this.modList == null) {
            this.modList = new MyModifyListener();
        }
    }

    @Override
    public int getControlCount() {
        if (this.provider != null) {
            return 3;
        }
        return 2;
    }

    @Override
    public void setEditible(boolean enabled) {
        super.setEditible(enabled);
        if (this.text != null) {
            this.text.setEnabled(true);
            this.text.setEditable(enabled);
        }
    }

    @Override
    public void reset() {
        this.setValue(this.lastSetValue);
    }

    @Override
    public boolean isUserSet() {
        return !this.getValue().equals(this.lastSetValue);
    }

    @Override
    protected void addMonitor(ComponentSetMonitor monitor) {
        this.init();
        this.modList.mon = monitor;
    }

    @Override
    protected void removeMonitor(ComponentSetMonitor monitor) {
        this.init();
        this.modList.mon = null;
    }

    @Override
    public void setValue(Object o) {
        this.lastSetValue = o instanceof String ? (String)o : "";
        this.text.setText(this.lastSetValue);
    }

    public String getValue() {
        return this.text.getText();
    }

    class MyModifyListener
    implements ModifyListener {
        public ComponentSetMonitor mon;
        private String lastVal;

        MyModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            String newVal;
            if (this.mon != null && !FormUtil.safeEquals(newVal = TextComponentSet.this.getValue(), this.lastVal)) {
                this.mon.update(new ComponentSetEvent(TextComponentSet.this, false, newVal));
                this.lastVal = newVal;
            }
        }
    }
}

