/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.outline;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.actions.TreeViewerRenameAction;
import org.teiid.designer.ui.outline.ModelOutlineTreeViewer;
import org.teiid.designer.ui.outline.ModelOutlineTreeViewerDropAdapter;
import org.teiid.designer.ui.util.ModelObjectNotificationHelper;
import org.teiid.designer.ui.util.ModelObjectTreeViewerNotificationHandler;

public class ModelOutlineNotificationHandler
extends ModelObjectTreeViewerNotificationHandler {
    private ModelOutlineTreeViewer viewer;
    private IWorkbenchWindow window;
    TreeViewerRenameAction renameAction;

    public ModelOutlineNotificationHandler(ModelOutlineTreeViewer outlinePage) {
        super(outlinePage.getTree());
        this.viewer = outlinePage;
        this.window = this.viewer.getSite().getWorkbenchWindow();
        this.renameAction = new TreeViewerRenameAction();
        this.renameAction.setTreeViewer(outlinePage.getTree(), (ILabelProvider)outlinePage.getTree().getLabelProvider());
    }

    @Override
    protected ModelObjectNotificationHelper handleNotification(Notification notification) {
        ModelObjectNotificationHelper notHelp = super.handleNotification(notification);
        if (NotificationUtilities.getEObject((Notification)notification) instanceof ModelAnnotation && !this.getTreeViewer().getControl().isDisposed()) {
            this.getTreeViewer().refresh();
        }
        if (NotificationUtilities.isAdded((Notification)notification) && this.getTreeViewer() != null) {
            EObject child;
            Object[] children = NotificationUtilities.getAddedChildren((Notification)notification);
            if (children != null && children.length == 1 && !((child = children[0]) instanceof Diagram)) {
                this.getTreeViewer().expandToLevel((Object)children[0], 0);
                StructuredSelection selection = new StructuredSelection(children);
                this.getTreeViewer().setSelection((ISelection)selection);
                if (this.window.getActivePage().getActivePart() == this.viewer.getWorkbenchPart()) {
                    this.renameAction.selectionChanged(this.viewer.getWorkbenchPart(), (ISelection)selection);
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ModelOutlineNotificationHandler.this.renameAction.doRun(false);
                        }
                    });
                }
            }
        } else if (NotificationUtilities.isMoved((Notification)notification) && notification instanceof SourcedNotification && ((SourcedNotification)notification).getSource() instanceof ModelOutlineTreeViewerDropAdapter) {
            this.getTreeViewer().refresh();
        }
        return notHelp;
    }
}

