/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.runtime.registry.TeiidRuntimeRegistry;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.preferences.IGeneralPreferencePageContributor;

public class DefaultTeiidServerPreferenceContributor
implements IGeneralPreferencePageContributor,
UiConstants {
    private static final String PREF_ID = "defaultTeiidServerVersion";
    private static final String PREFIX = I18nUtil.getPropertyPrefix(DefaultTeiidServerPreferenceContributor.class);
    private Shell shell;
    private Combo versionCombo;

    @Override
    public void createPreferenceEditor(Composite parent) {
        this.shell = parent.getShell();
        Composite panel = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(panel);
        this.versionCombo = new Combo(panel, 4);
        this.versionCombo.setFont(JFaceResources.getDialogFont());
        this.versionCombo.setToolTipText(Util.getStringOrKey(String.valueOf(PREFIX) + "toolTip"));
        GridDataFactory.swtDefaults().grab(true, true).align(16384, 0x1000000).applyTo((Control)this.versionCombo);
        Label title = new Label(panel, 0);
        title.setText(Util.getStringOrKey(String.valueOf(PREFIX) + "title"));
        GridDataFactory.swtDefaults().grab(true, true).align(16384, 0x1000000).applyTo((Control)title);
        this.refresh();
    }

    @Override
    public String getName() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "name");
    }

    private IPreferenceStore getPreferenceStore() {
        return UiPlugin.getDefault().getPreferenceStore();
    }

    private String getPreferenceStoreValue(boolean defaultFlag) {
        IPreferenceStore prefStore = this.getPreferenceStore();
        String value = null;
        value = defaultFlag ? prefStore.getDefaultString(PREF_ID) : prefStore.getString(PREF_ID);
        if (StringUtilities.isEmpty((String)value)) {
            value = TeiidServerVersion.deriveUltimateDefaultServerVersion().toString();
        }
        return value;
    }

    @Override
    public String getToolTip() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "toolTip");
    }

    @Override
    public boolean performCancel() {
        return true;
    }

    @Override
    public boolean performDefaults() {
        this.update(this.getPreferenceStoreValue(true));
        return true;
    }

    private boolean hasOpenEditors() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                if (page.getEditorReferences().length > 0) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean performOk() {
        boolean changeVersion;
        String versionString = this.versionCombo.getText();
        TeiidServerVersion version = new TeiidServerVersion(versionString);
        if (versionString.equals(this.getPreferenceStoreValue(false))) {
            return true;
        }
        if (ModelerCore.getTeiidServerManager().getDefaultServer() == null && this.hasOpenEditors() && !(changeVersion = MessageDialog.openQuestion((Shell)this.shell, (String)Util.getStringOrKey(String.valueOf(PREFIX) + "versionChangeQuestionTitle"), (String)Util.getStringOrKey(String.valueOf(PREFIX) + "versionChangeQuestionMessage")))) {
            return false;
        }
        try {
            for (ITeiidServerVersion regVersion : TeiidRuntimeRegistry.getInstance().getSupportedVersions()) {
                if (!regVersion.compareTo((ITeiidServerVersion)version)) continue;
                this.getPreferenceStore().setValue(PREF_ID, regVersion.toString());
                return true;
            }
        }
        catch (Exception ex) {
            Util.log((Throwable)ex);
        }
        changeVersion = MessageDialog.openQuestion((Shell)this.shell, (String)Util.getStringOrKey(String.valueOf(PREFIX) + "unsupportedVersionQuestionTitle"), (String)Util.getStringOrKey(String.valueOf(PREFIX) + "unsupportedVersionQuestionMesssage"));
        if (changeVersion) {
            this.getPreferenceStore().setValue(PREF_ID, version.toString());
            return true;
        }
        return false;
    }

    @Override
    public void refresh() {
        this.update(this.getPreferenceStoreValue(false));
    }

    @Override
    public void setWorkbench(IWorkbench theWorkbench) {
    }

    /*
     * Unable to fully structure code
     */
    private void update(String value) {
        block4: {
            items = new ArrayList<String>();
            try {
                registeredServerVersions = TeiidRuntimeRegistry.getInstance().getSupportedVersions();
                for (ITeiidServerVersion version : registeredServerVersions) {
                    items.add(version.toString());
                }
                break block4;
            }
            catch (Exception ex) {
                DefaultTeiidServerPreferenceContributor.Util.log((Throwable)ex);
                var7_9 = ITeiidServerVersion.VersionID.values();
                var6_10 = var7_9.length;
                var5_6 = 0;
                ** while (var5_6 < var6_10)
            }
lbl-1000:
            // 1 sources

            {
                versionId = var7_9[var5_6];
                items.add(versionId.toString());
                ++var5_6;
                continue;
            }
        }
        Collections.sort(items, Collections.reverseOrder());
        this.versionCombo.setItems(items.toArray(new String[0]));
        this.versionCombo.setText(value);
    }
}

