/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.preferences;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.teiid.designer.core.ValidationDescriptor;
import org.teiid.designer.ui.preferences.ValidationPreferencePage;

class ValidationItem
extends Composite {
    private ValidationDescriptor descriptor;
    private String originalValue;
    private Combo choiceCombo;

    public ValidationItem(Composite parent, ValidationDescriptor vd) {
        super(parent, 0);
        this.descriptor = vd;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        layout.numColumns = 2;
        GridData thisGridData = new GridData(768);
        this.setLayoutData(thisGridData);
        Label itemNameLabel = new Label((Composite)this, 0);
        itemNameLabel.setText(this.descriptor.getPreferenceLabel());
        itemNameLabel.setToolTipText(this.descriptor.getPreferenceToolTip());
        GridData labelGridData = new GridData();
        labelGridData.grabExcessHorizontalSpace = true;
        itemNameLabel.setLayoutData((Object)labelGridData);
        this.choiceCombo = new Combo((Composite)this, 12);
        int i = 0;
        while (i < ValidationPreferencePage.VALUE_DISPLAY_NAMES.length) {
            this.choiceCombo.add(ValidationPreferencePage.VALUE_DISPLAY_NAMES[i]);
            ++i;
        }
        int index = ValidationPreferencePage.indexOfStoredValueName(this.originalValue);
        this.choiceCombo.select(index);
    }

    public void setToValue(String value, boolean setAsOriginalValue) {
        if (setAsOriginalValue) {
            this.originalValue = value;
        }
        int index = ValidationPreferencePage.indexOfStoredValueName(value);
        this.choiceCombo.select(index);
    }

    public String getValue(boolean nullIfUnchanged) {
        int index = this.choiceCombo.getSelectionIndex();
        String value = ValidationPreferencePage.STORED_VALUES[index];
        String changedValue = null;
        if (!nullIfUnchanged || !value.equals(this.originalValue)) {
            changedValue = value;
        }
        return changedValue;
    }

    public ValidationDescriptor getDescriptor() {
        return this.descriptor;
    }
}

