/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.properties.ITransientPropertyDescriptor;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

class EnumeratedValuesPropertyDescriptor
implements ITransientPropertyDescriptor,
UiConstants {
    static final String PREFIX = I18nUtil.getPropertyPrefix(EnumeratedValuesPropertyDescriptor.class);
    private EObject obj;
    private ILabelProvider labelProvider;
    List enumeratedValues;

    EnumeratedValuesPropertyDescriptor() {
    }

    public CellEditor createPropertyEditor(Composite theParent) {
        DialogCellEditor editor = new DialogCellEditor(theParent){

            protected Object openDialogBox(Control cellEditorWindow) {
                ListDialog dialog = new ListDialog(cellEditorWindow.getShell());
                dialog.setInput((Object)EnumeratedValuesPropertyDescriptor.this.enumeratedValues);
                dialog.setContentProvider((IStructuredContentProvider)new ListSCP());
                dialog.setLabelProvider(EnumeratedValuesPropertyDescriptor.this.getLabelProvider());
                dialog.setTitle(Util.getStringOrKey(String.valueOf(PREFIX) + "displayName"));
                dialog.open();
                return null;
            }
        };
        return editor;
    }

    public String getCategory() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "category");
    }

    public String getDescription() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "description");
    }

    public String getDisplayName() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "displayName");
    }

    public String[] getFilterFlags() {
        return null;
    }

    @Override
    public Object getPropertyValue() {
        SqlColumnAspect colAspect;
        EObject originalValue;
        if (this.obj == null) {
            throw new IllegalStateException(Util.getStringOrKey(String.valueOf(PREFIX) + "errorMsg.objectNotSet"));
        }
        MetamodelAspect mmAspect = ModelObjectUtilities.getSqlAspect(this.obj);
        if (mmAspect instanceof SqlColumnAspect && (originalValue = (colAspect = (SqlColumnAspect)mmAspect).getDatatype(this.obj)) instanceof XSDSimpleTypeDefinition) {
            this.enumeratedValues = new ArrayList();
            EList enums = ((XSDSimpleTypeDefinition)originalValue).getEnumerationFacets();
            for (XSDEnumerationFacet ef : enums) {
                EList value = ef.getValue();
                if (value.size() > 1) {
                    this.enumeratedValues.addAll(value);
                    continue;
                }
                if (value.size() == 1) {
                    this.enumeratedValues.add(value.get(0));
                    continue;
                }
                this.enumeratedValues.add(ef.getLexicalValue());
            }
        }
        if (this.enumeratedValues != null && !this.enumeratedValues.isEmpty()) {
            return this.enumeratedValues.get(0);
        }
        return null;
    }

    public Object getHelpContextIds() {
        return null;
    }

    public Object getId() {
        return Util.getStringOrKey(String.valueOf(PREFIX) + "id");
    }

    public ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider();
        }
        return this.labelProvider;
    }

    public boolean isCompatibleWith(IPropertyDescriptor theAnotherProperty) {
        return false;
    }

    @Override
    public void setObject(Object theObject) {
        if (theObject == null || !this.supports(theObject)) {
            throw new IllegalArgumentException(Util.getString(String.valueOf(PREFIX) + "errorMsg.objectNotSupported", (Object)this.obj));
        }
        this.obj = (EObject)theObject;
    }

    @Override
    public boolean supports(Object theObject) {
        EList enums;
        SqlColumnAspect colAspect;
        EObject originalValue;
        EObject eObj;
        MetamodelAspect mmAspect;
        return theObject != null && theObject instanceof EObject && (mmAspect = ModelObjectUtilities.getSqlAspect(eObj = (EObject)theObject)) instanceof SqlColumnAspect && (originalValue = (colAspect = (SqlColumnAspect)mmAspect).getDatatype(eObj)) instanceof XSDSimpleTypeDefinition && (enums = ((XSDSimpleTypeDefinition)originalValue).getEnumerationFacets()) != null && !enums.isEmpty();
    }

    class ListSCP
    implements IStructuredContentProvider {
        ListSCP() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

