/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.teiid.designer.metamodels.relational.RelationalPackage;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.properties.IPropertyEditorFactory;

public class FloatAsIntPropertyEditorFactory
implements IPropertyEditorFactory {
    private static final Collection<EStructuralFeature> FLOAT_AS_INT_FEATURES = Collections.unmodifiableCollection(Arrays.asList(RelationalPackage.eINSTANCE.getTable_Cardinality(), RelationalPackage.eINSTANCE.getColumn_DistinctValueCount(), RelationalPackage.eINSTANCE.getColumn_NullValueCount()));
    public static final LabelProvider LABEL_PROVIDER = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof Integer) {
                int value = (Integer)element;
                if (value >= -1) {
                    return Integer.toString(value);
                }
                float floatValue = Float.intBitsToFloat(value & Integer.MAX_VALUE);
                return String.valueOf(floatValue);
            }
            return super.getText(element);
        }
    };

    public static boolean supports(EStructuralFeature feature) {
        return FLOAT_AS_INT_FEATURES.contains(feature);
    }

    @Override
    public CellEditor createPropertyEditor(Composite composite, IItemPropertyDescriptor itemPropertyDescriptor, IPropertyDescriptor propertyDescriptor, Object object) {
        EStructuralFeature feature = (EStructuralFeature)itemPropertyDescriptor.getFeature(object);
        EDataType dataType = (EDataType)feature.getEType();
        return new Editor(dataType, composite);
    }

    @Override
    public boolean supportsStructuralFeature(EStructuralFeature feature) {
        return FloatAsIntPropertyEditorFactory.supports(feature);
    }

    private class Editor
    extends PropertyDescriptor.EDataTypeCellEditor {
        private Editor(EDataType dataType, Composite parent) {
            super(dataType, parent);
            this.setValidator(new Validator());
        }

        public Object doGetValue() {
            String valueAsText = this.text.getText();
            long value = Long.parseLong(valueAsText);
            if (value == -1L || value < 0L) {
                return -1;
            }
            if (value <= Integer.MAX_VALUE) {
                return (int)value;
            }
            return Float.floatToRawIntBits(value) | Integer.MIN_VALUE;
        }

        public void doSetValue(Object value) {
            String valueAsText = LABEL_PROVIDER.getText(value);
            super.doSetValue((Object)valueAsText);
        }
    }

    private static class Validator
    implements ICellEditorValidator,
    IInputValidator {
        private Validator() {
        }

        public String isValid(String newText) {
            return this.isValid((Object)newText);
        }

        public String isValid(Object object) {
            try {
                long value = Long.parseLong(object.toString());
                if (value < -1L) {
                    return UiConstants.Util.getString("FloatAsIntPropertyEditorFactory.invalidValue", new Object[0]);
                }
                return null;
            }
            catch (Exception e) {
                String message = e.getClass().getName();
                int index = message.lastIndexOf(46);
                if (index >= 0) {
                    message = message.substring(index + 1);
                }
                if (e.getLocalizedMessage() != null) {
                    message = String.valueOf(message) + ": " + e.getLocalizedMessage();
                }
                return message;
            }
        }
    }
}

