/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.PropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.event.EventSourceException;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.notification.util.SourcedNotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.properties.ModelObjectPropertySource;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelObjectPropertySheetPage
extends PropertySheetPage
implements INotifyChangedListener,
EventObjectListener {
    private ISelection currentSelection;
    private Control control;
    private boolean handlingNotification = false;

    public ModelObjectPropertySheetPage() {
        try {
            UiPlugin.getDefault().getEventBroker().addListener(ModelResourceEvent.class, (EventObjectListener)this);
        }
        catch (EventSourceException e) {
            UiConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.control != null && !this.control.isDisposed()) {
            if (selection != null && !selection.isEmpty()) {
                try {
                    this.currentSelection = selection;
                    super.selectionChanged(part, selection);
                }
                catch (Exception e) {
                    UiConstants.Util.log(4, (Throwable)e, e.getClass().getName());
                }
            } else if (selection != null) {
                try {
                    super.selectionChanged(part, selection);
                }
                catch (Exception e) {
                    UiConstants.Util.log(4, (Throwable)e, e.getClass().getName());
                }
            }
        }
    }

    private boolean isModelExtensionDefinitionRelated(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof AnnotationContainer || notifier instanceof Annotation) {
            ArrayList<Notification> notifications = new ArrayList<Notification>();
            if (notification instanceof SourcedNotification) {
                notifications.addAll(((SourcedNotification)notification).getNotifications());
            } else {
                notifications.add(notification);
            }
            for (Notification event : notifications) {
                Object modelObject = null;
                if (event.getEventType() == 3) {
                    modelObject = event.getNewValue();
                } else if (event.getEventType() == 4) {
                    modelObject = event.getOldValue();
                }
                if (modelObject == null || !ExtensionPlugin.getInstance().isModelExtensionDefinitionRelated(modelObject)) continue;
                return true;
            }
        }
        return false;
    }

    public void notifyChanged(Notification notification) {
        Object source;
        if (this.handlingNotification) {
            return;
        }
        if (notification instanceof SourcedNotification && ((source = ((SourcedNotification)notification).getSource()) == this || source instanceof ModelObjectPropertySource)) {
            return;
        }
        if (this.currentSelection != null) {
            EObject selectedObject = SelectionUtilities.getSelectedEObject((ISelection)this.currentSelection);
            if (selectedObject != null) {
                Set affectedObjects = SourcedNotificationUtilities.gatherNotifiers((Notification)notification, (boolean)true);
                Set annotatedObjects = this.getAnnotatedObjects(affectedObjects);
                if (affectedObjects.contains(selectedObject) || annotatedObjects.contains(selectedObject) || this.isModelExtensionDefinitionRelated(notification)) {
                    this.handlingNotification = true;
                    try {
                        try {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ModelObjectPropertySheetPage.this.refresh();
                                }
                            });
                        }
                        catch (SWTException sWTException) {
                            this.handlingNotification = false;
                        }
                    }
                    finally {
                        this.handlingNotification = false;
                    }
                }
            } else if (!SelectionUtilities.getSelectedIResourceObjects((ISelection)this.currentSelection).isEmpty()) {
                boolean isModelAnnotation = false;
                if (notification instanceof SourcedNotification) {
                    Iterator it = ((SourcedNotification)notification).getNotifications().iterator();
                    while (it.hasNext()) {
                        if (!(((Notification)it.next()).getNotifier() instanceof ModelAnnotation)) continue;
                        isModelAnnotation = true;
                        break;
                    }
                } else {
                    EObject target = NotificationUtilities.getEObject((Notification)notification);
                    isModelAnnotation = target instanceof ModelAnnotation;
                }
                if (isModelAnnotation) {
                    this.handlingNotification = true;
                    try {
                        try {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ModelObjectPropertySheetPage.this.refresh();
                                }
                            });
                        }
                        catch (SWTException sWTException) {
                            this.handlingNotification = false;
                        }
                    }
                    finally {
                        this.handlingNotification = false;
                    }
                }
            }
        }
    }

    private Set getAnnotatedObjects(Set objects) {
        HashSet<EObject> annotatedObjects = new HashSet<EObject>();
        if (objects != null) {
            for (Object obj : objects) {
                EObject annotatedObject;
                if (!(obj instanceof Annotation) || (annotatedObject = ((Annotation)obj).getAnnotatedObject()) == null) continue;
                annotatedObjects.add(annotatedObject);
            }
        }
        return annotatedObjects;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        ModelUtilities.addNotifyChangedListener(this);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.control = super.getControl();
        this.setupTooltip();
    }

    private void setupTooltip() {
        final Tree tree = (Tree)this.getControl();
        Listener listener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        if (this.tip != null) {
                            this.tip.dispose();
                            this.tip = null;
                            this.label = null;
                        }
                        String tooltip = null;
                        TreeItem item = tree.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        Object data = item.getData();
                        if (data instanceof PropertySheetEntry) {
                            tooltip = ((PropertySheetEntry)data).getDescription();
                        }
                        if (tooltip == null) break;
                        Shell shell = tree.getShell();
                        Display display = tree.getDisplay();
                        this.tip = new Shell(shell, 540676);
                        this.tip.setBackground(display.getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tip.setLayout((Layout)layout);
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(display.getSystemColor(28));
                        this.label.setBackground(display.getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        this.label.setText(tooltip);
                        this.label.addListener(7, (Listener)this);
                        this.label.addListener(3, (Listener)this);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = tree.toDisplay(event.x + 15, rect.y);
                        this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        tree.addListener(12, listener);
        tree.addListener(1, listener);
        tree.addListener(5, listener);
        tree.addListener(32, listener);
    }

    public void dispose() {
        ModelUtilities.removeNotifyChangedListener(this);
        try {
            UiPlugin.getDefault().getEventBroker().removeListener(ModelResourceEvent.class, (EventObjectListener)this);
        }
        catch (EventSourceException e) {
            UiConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
        super.dispose();
    }

    public void processEvent(EventObject obj) {
        ModelResourceEvent event = (ModelResourceEvent)obj;
        if (event.getType() == 6) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ModelObjectPropertySheetPage.this.selectionChanged(null, (ISelection)new StructuredSelection(Collections.EMPTY_LIST));
                }
            });
        }
    }
}

