/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.properties.ReadOnlyPropertyDescriptor;
import org.teiid.designer.ui.properties.udp.ExtensionPropertySource;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelPropertySource
implements IPropertySource {
    private static final AdapterFactoryContentProvider annotationPropertySourceProvider = ModelUtilities.getEmfAdapterFactoryContentProvider();
    private IFile modelFile;
    private ModelResource modelResource;
    private ModelAnnotation annotation;
    private IPropertySource delegate;
    private ExtensionPropertySource extensionDelegate;

    public ModelPropertySource(IFile modelFile) {
        block14: {
            this.modelFile = modelFile;
            IAdapterManager manager = Platform.getAdapterManager();
            this.delegate = (IPropertySource)manager.getAdapter((Object)modelFile, IPropertySource.class);
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Adapter Property Source", (Object)this);
            boolean succeeded = false;
            try {
                try {
                    this.modelResource = ModelUtil.getModelResource((IFile)modelFile, (boolean)false);
                    if (this.modelResource != null && this.modelResource.isOpen()) {
                        block13: {
                            try {
                                this.annotation = this.modelResource.getModelAnnotation();
                            }
                            catch (ModelWorkspaceException err) {
                                if (this.modelResource.hasErrors()) break block13;
                                UiConstants.Util.log((Throwable)err);
                            }
                        }
                        if (this.annotation != null) {
                            annotationPropertySourceProvider.getAdapterFactory().adapt((Notifier)this.annotation, IItemPropertySource.class);
                            this.extensionDelegate = new ExtensionPropertySource((EObject)this.annotation);
                        }
                    }
                    succeeded = true;
                }
                catch (ModelerCoreException e) {
                    UiConstants.Util.log((Throwable)e);
                    if (!requiredStart) break block14;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block14;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private IPropertyDescriptor[] getAnnotationPropertyDescriptors() {
        IPropertyDescriptor[] result = null;
        if (this.annotation != null) {
            result = this.extensionDelegate.getPropertyDescriptors();
        }
        return result;
    }

    public Object getEditableValue() {
        return this.delegate.getEditableValue();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.annotation == null) {
            return this.delegate.getPropertyDescriptors();
        }
        IPropertyDescriptor[] fileProperties = this.delegate.getPropertyDescriptors();
        IPropertyDescriptor[] annotationProperties = this.getAnnotationPropertyDescriptors();
        if (annotationProperties == null || annotationProperties.length == 0) {
            return fileProperties;
        }
        int index = 0;
        IPropertyDescriptor[] result = new IPropertyDescriptor[fileProperties.length + annotationProperties.length];
        int i = 0;
        while (i < fileProperties.length) {
            result[index++] = fileProperties[i];
            ++i;
        }
        boolean readOnly = ModelUtil.isIResourceReadOnly((IResource)this.modelFile);
        boolean editorOpen = ModelEditorManager.isOpen(this.modelFile);
        int i2 = 0;
        while (i2 < annotationProperties.length) {
            result[index++] = readOnly ? new ReadOnlyPropertyDescriptor(annotationProperties[i2], 1) : (!editorOpen ? new ReadOnlyPropertyDescriptor(annotationProperties[i2], 2, this.modelFile) : annotationProperties[i2]);
            ++i2;
        }
        return result;
    }

    public Object getPropertyValue(Object id) {
        if (this.extensionDelegate != null && this.extensionDelegate.isExtensionProperty(id)) {
            return this.extensionDelegate.getPropertyValue(id);
        }
        return this.delegate.getPropertyValue(id);
    }

    public boolean isPropertySet(Object id) {
        if (this.extensionDelegate != null && this.extensionDelegate.isExtensionProperty(id)) {
            return this.extensionDelegate.isPropertySet(id);
        }
        return this.delegate.isPropertySet(id);
    }

    public void resetPropertyValue(Object id) {
        if (this.extensionDelegate != null && this.extensionDelegate.isExtensionProperty(id)) {
            this.extensionDelegate.resetPropertyValue(id);
        } else {
            this.delegate.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (this.extensionDelegate != null && this.extensionDelegate.isExtensionProperty(id)) {
            this.extensionDelegate.setPropertyValue(id, value);
        } else {
            this.delegate.setPropertyValue(id, value);
        }
    }
}

