/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties.extension;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.util.VdbHelper;
import org.teiid.designer.ui.properties.extension.Messages;

public class ChooseVdbFileOptionsDialog
extends MessageDialog {
    private Button selectFromWorkspaceRadio;
    private Button selectFromFileSystemRadio;
    private Button copyToWorkspaceCheckbox;
    private boolean selectFromWorkspace = false;
    private boolean selectFromFileSystem = false;
    private boolean copyToWorkspace = false;
    private VdbHelper.VdbFolders vdbFolder = null;
    private boolean disableWorkspaceOption = false;

    public ChooseVdbFileOptionsDialog(Shell parentShell, String dialogTitle, String dialogMessage, VdbHelper.VdbFolders vdbFolder, boolean disableWorkspaceOption) {
        super(parentShell, dialogTitle, null, dialogMessage, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.vdbFolder = vdbFolder;
        this.disableWorkspaceOption = disableWorkspaceOption;
    }

    protected Control createMessageArea(Composite parent) {
        super.createMessageArea(parent);
        new Composite(parent, 0);
        return this.getControlsComposite(parent);
    }

    public Composite getControlsComposite(Composite parent) {
        Font font = parent.getFont();
        Composite radioComposite = new Composite(parent, 0);
        GridData data = new GridData(770);
        radioComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 6;
        layout.numColumns = 1;
        radioComposite.setLayout((Layout)layout);
        String selectFromWorkspaceRadioText = "";
        String selectFromFileSystemRadioText = "";
        if (VdbHelper.VdbFolders.UDF.equals((Object)this.vdbFolder)) {
            selectFromWorkspaceRadioText = Messages.chooseUdfFromWorkspaceRadioText;
            selectFromFileSystemRadioText = Messages.chooseUdfFromFileSystemRadioText;
        } else {
            selectFromWorkspaceRadioText = Messages.chooseFileFromWorkspaceRadioText;
            selectFromFileSystemRadioText = Messages.chooseFileFromFileSystemRadioText;
        }
        this.selectFromWorkspaceRadio = new Button(radioComposite, 16400);
        this.selectFromWorkspaceRadio.setFont(font);
        this.selectFromWorkspaceRadio.setText(selectFromWorkspaceRadioText);
        this.selectFromFileSystemRadio = new Button(radioComposite, 16400);
        this.selectFromFileSystemRadio.setFont(font);
        this.selectFromFileSystemRadio.setText(selectFromFileSystemRadioText);
        Composite checkboxComposite = new Composite(radioComposite, 16384);
        GridData gd = new GridData(768);
        checkboxComposite.setLayoutData((Object)gd);
        GridLayout layButtons = new GridLayout();
        layButtons.numColumns = 2;
        checkboxComposite.setLayout((Layout)layButtons);
        Label spacerLabel = new Label(checkboxComposite, 0);
        spacerLabel.setText("     ");
        this.copyToWorkspaceCheckbox = new Button(checkboxComposite, 16416);
        this.copyToWorkspaceCheckbox.setFont(font);
        this.copyToWorkspaceCheckbox.setText(Messages.copyToWorkspaceCheckboxText);
        this.setInitialDialogChoices();
        this.selectFromWorkspaceRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChooseVdbFileOptionsDialog.this.handleRadioSelectionChanged();
            }
        });
        this.selectFromFileSystemRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChooseVdbFileOptionsDialog.this.handleRadioSelectionChanged();
            }
        });
        this.copyToWorkspaceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChooseVdbFileOptionsDialog.this.handleCheckboxSelectionChanged();
            }
        });
        return radioComposite;
    }

    private void setInitialDialogChoices() {
        if (VdbHelper.VdbFolders.UDF.equals((Object)this.vdbFolder)) {
            if (this.disableWorkspaceOption) {
                this.selectFromWorkspaceRadio.setSelection(false);
                this.selectFromWorkspace = false;
                this.selectFromFileSystemRadio.setSelection(true);
                this.selectFromFileSystem = true;
                this.copyToWorkspaceCheckbox.setSelection(true);
                this.copyToWorkspace = true;
                this.selectFromWorkspaceRadio.setEnabled(false);
                this.copyToWorkspaceCheckbox.setEnabled(false);
            } else {
                this.selectFromWorkspaceRadio.setSelection(true);
                this.selectFromWorkspace = true;
                this.selectFromFileSystemRadio.setSelection(false);
                this.selectFromFileSystem = false;
                this.copyToWorkspaceCheckbox.setSelection(false);
                this.copyToWorkspace = false;
                this.selectFromWorkspaceRadio.setEnabled(true);
                this.copyToWorkspaceCheckbox.setEnabled(false);
            }
        } else {
            this.selectFromWorkspaceRadio.setSelection(false);
            this.selectFromWorkspace = false;
            this.selectFromFileSystemRadio.setSelection(true);
            this.selectFromFileSystem = true;
            this.copyToWorkspaceCheckbox.setSelection(false);
            this.copyToWorkspace = false;
            this.selectFromWorkspaceRadio.setEnabled(true);
            this.copyToWorkspaceCheckbox.setEnabled(true);
            if (this.disableWorkspaceOption) {
                this.selectFromWorkspaceRadio.setEnabled(false);
            }
        }
    }

    private void handleRadioSelectionChanged() {
        if (this.selectFromFileSystemRadio.getSelection()) {
            this.selectFromFileSystem = true;
            this.selectFromWorkspace = false;
            if (VdbHelper.VdbFolders.UDF.equals((Object)this.vdbFolder)) {
                this.copyToWorkspaceCheckbox.setSelection(true);
                this.copyToWorkspace = true;
                this.copyToWorkspaceCheckbox.setEnabled(false);
            } else {
                this.copyToWorkspaceCheckbox.setEnabled(true);
            }
        }
        if (this.selectFromWorkspaceRadio.getSelection()) {
            this.selectFromFileSystem = false;
            this.selectFromWorkspace = true;
            this.copyToWorkspaceCheckbox.setSelection(false);
            this.copyToWorkspace = false;
            this.copyToWorkspaceCheckbox.setEnabled(false);
        }
    }

    private void handleCheckboxSelectionChanged() {
        this.copyToWorkspace = this.copyToWorkspaceCheckbox.getSelection();
    }

    public boolean selectFromWorkspaceSelected() {
        return this.selectFromWorkspace;
    }

    public boolean selectFromFileSystemSelected() {
        return this.selectFromFileSystem;
    }

    public boolean copyToWorkspaceSelected() {
        return this.copyToWorkspace;
    }
}

