/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties.sdt;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.properties.ReadOnlyPropertyDescriptor;
import org.teiid.designer.ui.properties.sdt.NodePropertyDescriptor;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ModelResourceComboBoxPropertyDescriptor
extends ComboBoxPropertyDescriptor {
    private EObject owner;
    private boolean isEditable = true;
    private boolean showReadOnlyDialog = true;

    public ModelResourceComboBoxPropertyDescriptor(EObject owner, Object id, String displayName, String[] valuesArray) {
        this(id, displayName, valuesArray);
        this.owner = owner;
    }

    public ModelResourceComboBoxPropertyDescriptor(Object id, String displayName, String[] valuesArray) {
        super(id, displayName, valuesArray);
    }

    public void setShowReadOnlyDialog(boolean enable) {
        this.showReadOnlyDialog = enable;
    }

    public String getCategory() {
        return NodePropertyDescriptor.CATEGORY;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        if (!this.isEditable) {
            return null;
        }
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject(this.owner);
        if (modelResource == null) {
            return null;
        }
        if (ModelUtil.isIResourceReadOnly((IResource)modelResource.getResource())) {
            if (this.showReadOnlyDialog) {
                Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)ReadOnlyPropertyDescriptor.READ_ONLY_TITLE, (String)ReadOnlyPropertyDescriptor.READ_ONLY_MESSAGE);
            }
            return null;
        }
        IFile file = (IFile)modelResource.getResource();
        if (file != null && !ModelEditorManager.isOpen(file)) {
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)ModelEditorManager.OPEN_EDITOR_TITLE, (String)ModelEditorManager.OPEN_EDITOR_MESSAGE)) {
                ModelEditorManager.open(this.owner, true);
            }
            return null;
        }
        return super.createPropertyEditor(parent);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }
}

