/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties.sdt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.ComboBoxLabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeConstants;
import org.teiid.designer.core.types.EnterpriseDatatypeInfo;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.properties.ModelObjectPropertySource;
import org.teiid.designer.ui.properties.sdt.ModelResourceComboBoxPropertyDescriptor;
import org.teiid.designer.ui.properties.sdt.NodePropertyDescriptor;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleDatatypePropertySource
implements IPropertySource {
    private static final String TYPE_NAME = UiConstants.Util.getString("RuntimeTypePropertyDescriptor.runtimeTypeName", new Object[0]);
    private static final String TYPE_FIXED = UiConstants.Util.getString("RuntimeTypePropertyDescriptor.runtimeTypeFixed", new Object[0]);
    public static final String TYPE_NAME_DESCRIPTION = UiConstants.Util.getString("RuntimeTypePropertyDescriptor.runtimeTypeDescription", new Object[0]);
    public static final String TYPE_FIXED_DESCRIPTION = UiConstants.Util.getString("RuntimeTypePropertyDescriptor.runtimeTypeFixedDescription", new Object[0]);
    public static String[] runtimeTypeFixedArray = new String[2];
    public static String[] runtimeTypeArray;
    private XSDSimpleTypeDefinition datatype;
    private IPropertySource delegate;
    private List descriptorList;
    private ILabelProvider runtimeTypeLabelProvider;
    private ILabelProvider runtimeTypeFixedLabelProvider;

    static {
        SimpleDatatypePropertySource.runtimeTypeFixedArray[0] = Boolean.TRUE.toString();
        SimpleDatatypePropertySource.runtimeTypeFixedArray[1] = Boolean.FALSE.toString();
        runtimeTypeArray = DatatypeConstants.getRuntimeTypeNames().toArray(runtimeTypeFixedArray);
    }

    public SimpleDatatypePropertySource(XSDSimpleTypeDefinition datatype, IPropertySource emfPropertySource) {
        this.delegate = emfPropertySource;
        this.descriptorList = new ArrayList();
        this.runtimeTypeLabelProvider = new ComboBoxLabelProvider(runtimeTypeArray);
        this.runtimeTypeFixedLabelProvider = new ComboBoxLabelProvider(runtimeTypeFixedArray);
        this.datatype = datatype;
    }

    private void updateDescriptorList() {
        EnterpriseDatatypeInfo edtInfo = ModelerCore.getDatatypeManager((EObject)this.datatype, (boolean)true).getEnterpriseDatatypeInfo(this.datatype);
        Element element = this.datatype.getElement();
        Document doc = element.getOwnerDocument();
        Attr node = doc.createAttribute("UUID");
        String uuid = edtInfo != null && edtInfo.getUuid() != null ? edtInfo.getUuid() : ModelerCore.getDatatypeManager((EObject)this.datatype).getUuid((EObject)this.datatype);
        node.setNodeValue(uuid != null ? uuid.toString() : null);
        this.descriptorList.add(new NodePropertyDescriptor(this.datatype, node));
        boolean isEditable = !ModelerCore.getWorkspaceDatatypeManager().isBuiltInDatatype((EObject)this.datatype);
        node = doc.createAttribute("runtimeDataType");
        node.setNodeValue(edtInfo.getRuntimeType());
        ModelResourceComboBoxPropertyDescriptor descriptor = new ModelResourceComboBoxPropertyDescriptor((EObject)this.datatype, node, TYPE_NAME, runtimeTypeArray);
        descriptor.setEditable(isEditable);
        descriptor.setDescription(TYPE_NAME_DESCRIPTION);
        descriptor.setLabelProvider(this.runtimeTypeLabelProvider);
        this.descriptorList.add(descriptor);
        node = doc.createAttribute("runtimeDataTypeFixed");
        Boolean runtimeTypeFixed = edtInfo.getRuntimeTypeFixed();
        node.setNodeValue(runtimeTypeFixed != null ? runtimeTypeFixed.toString() : null);
        descriptor = new ModelResourceComboBoxPropertyDescriptor((EObject)this.datatype, node, TYPE_FIXED, runtimeTypeFixedArray);
        descriptor.setEditable(isEditable);
        descriptor.setDescription(TYPE_FIXED_DESCRIPTION);
        descriptor.setLabelProvider(this.runtimeTypeFixedLabelProvider);
        this.descriptorList.add(descriptor);
    }

    public Object getEditableValue() {
        return this.delegate.getEditableValue();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptorList.isEmpty()) {
            this.updateDescriptorList();
        }
        IPropertyDescriptor[] emfDescriptors = this.delegate.getPropertyDescriptors();
        IPropertyDescriptor[] result = new IPropertyDescriptor[emfDescriptors.length + this.descriptorList.size()];
        int index = 0;
        while (index < emfDescriptors.length) {
            result[index] = emfDescriptors[index];
            ++index;
        }
        Iterator nodeIter = this.descriptorList.iterator();
        while (nodeIter.hasNext()) {
            result[index] = (IPropertyDescriptor)nodeIter.next();
            ++index;
        }
        return result;
    }

    public Object getPropertyValue(Object id) {
        if (id instanceof Node) {
            Object value = ((Node)id).getNodeValue();
            String nodeName = ((Node)id).getNodeName();
            if (nodeName.equals("runtimeDataType")) {
                value = new Integer(this.findValueInArray(runtimeTypeArray, value));
            } else if (nodeName.equals("runtimeDataTypeFixed")) {
                value = new Integer(this.findValueInArray(runtimeTypeFixedArray, value));
            }
            return value;
        }
        return this.delegate.getPropertyValue(id);
    }

    private int findValueInArray(Object[] array, Object value) {
        if (array != null && value != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i].equals(value)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean isPropertySet(Object id) {
        if (id instanceof Node) {
            return ((Node)id).getNodeValue() != null;
        }
        return this.delegate.isPropertySet(id);
    }

    public void resetPropertyValue(Object id) {
        if (id instanceof Node) {
            this.setPropertyValue(id, null);
            ((Node)id).setNodeValue(null);
        } else {
            boolean started = ModelerCore.startTxn((String)(String.valueOf(ModelObjectPropertySource.SET) + id.toString()), (Object)this);
            boolean succeeded = false;
            try {
                this.delegate.resetPropertyValue(id);
                succeeded = true;
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public void setPropertyValue(Object id, Object value) {
        boolean started = ModelerCore.startTxn((String)(String.valueOf(ModelObjectPropertySource.SET) + id.toString()), (Object)this);
        boolean succeeded = false;
        try {
            if (id instanceof Node) {
                Object owner = this.delegate.getEditableValue();
                if (owner instanceof XSDSimpleTypeDefinition) {
                    XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)ModelObjectUtilities.getRealEObject((EObject)((XSDSimpleTypeDefinition)owner));
                    EnterpriseDatatypeInfo edtInfo = ModelerCore.getDatatypeManager((EObject)simpleType).getEnterpriseDatatypeInfo(simpleType);
                    String nodeName = ((Node)id).getNodeName();
                    boolean isValidSet = false;
                    String newValue = "";
                    if (nodeName.equals("runtimeDataType")) {
                        edtInfo.setRuntimeType(value != null ? this.runtimeTypeLabelProvider.getText(value) : "");
                        newValue = edtInfo.getRuntimeType();
                        isValidSet = true;
                    } else if (nodeName.equals("runtimeDataTypeFixed")) {
                        edtInfo.setRuntimeTypeFixed(Boolean.valueOf(value != null ? this.runtimeTypeFixedLabelProvider.getText(value) : ""));
                        newValue = edtInfo.getRuntimeTypeFixed().toString();
                        isValidSet = true;
                    }
                    if (isValidSet) {
                        ModelerCore.getModelEditor().setEnterpriseDatatypePropertyValue((EObject)simpleType, (Object)edtInfo);
                        ((Node)id).setNodeValue(newValue);
                    }
                }
            } else {
                this.delegate.setPropertyValue(id, value);
            }
            succeeded = true;
        }
        finally {
            if (started) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }
}

