/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties.udp;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.properties.PropertyEditorFactory;
import org.teiid.designer.ui.properties.ReadOnlyPropertyDescriptor;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ExtensionPropertyDescriptor
implements IPropertyDescriptor {
    private static final String EXTENSIONS_CATEGORY = UiConstants.Util.getString("ExtensionPropertyDescriptor.category", new Object[0]);
    public static final AdapterFactoryContentProvider extensionPropertySourceProvider = ModelUtilities.getEmfAdapterFactoryContentProvider();
    private EObject extension;
    private EObject extendedObject;
    private IPropertyDescriptor delegate;
    private boolean showReadOnlyDialog = true;

    public ExtensionPropertyDescriptor(EObject extensionObject, EObject extendedObject, IPropertyDescriptor delegate) {
        this.extension = extensionObject;
        this.extendedObject = extendedObject;
        this.delegate = delegate;
    }

    public void setShowReadOnlyDialog(boolean enable) {
        this.showReadOnlyDialog = enable;
    }

    public EObject getExtensionObject() {
        return this.extension;
    }

    public IPropertyDescriptor getDelegate() {
        return this.delegate;
    }

    public Object getId() {
        return this;
    }

    public Object getDelegateId() {
        return this.delegate.getId();
    }

    public String toString() {
        return this.delegate.getId().toString();
    }

    public CellEditor createPropertyEditor(Composite parent) {
        IItemPropertyDescriptor itemDescriptor;
        AdapterFactory factory;
        IItemPropertySource itemPropertySource;
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject(this.extendedObject);
        if (modelResource == null) {
            return null;
        }
        if (ModelUtil.isIResourceReadOnly((IResource)modelResource.getResource())) {
            if (this.showReadOnlyDialog) {
                Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)ReadOnlyPropertyDescriptor.READ_ONLY_TITLE, (String)ReadOnlyPropertyDescriptor.READ_ONLY_MESSAGE);
            }
            return null;
        }
        IFile file = (IFile)modelResource.getResource();
        if (file != null && !ModelEditorManager.isOpen(file)) {
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)ModelEditorManager.OPEN_EDITOR_TITLE, (String)ModelEditorManager.OPEN_EDITOR_MESSAGE)) {
                ModelEditorManager.open(this.extendedObject, true);
            }
            return null;
        }
        CellEditor result = null;
        if (this.extension instanceof ModelAnnotation && (itemPropertySource = (IItemPropertySource)(factory = extensionPropertySourceProvider.getAdapterFactory()).adapt((Notifier)this.extension, IItemPropertySource.class)) != null && (itemDescriptor = itemPropertySource.getPropertyDescriptor((Object)this.extension, this.delegate.getId())) != null) {
            if (!itemDescriptor.canSetProperty((Object)this.extension)) {
                return null;
            }
            Object feature = itemDescriptor.getFeature((Object)this.extension);
            if (feature instanceof EStructuralFeature) {
                result = PropertyEditorFactory.createPropertyEditor(parent, itemDescriptor, this, this.extension);
            }
        }
        if (result == null) {
            result = this.delegate.createPropertyEditor(parent);
        }
        return result;
    }

    public String getCategory() {
        if (this.delegate.getCategory() == null) {
            return EXTENSIONS_CATEGORY;
        }
        return this.delegate.getCategory();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public String[] getFilterFlags() {
        return this.delegate.getFilterFlags();
    }

    public Object getHelpContextIds() {
        return this.delegate.getFilterFlags();
    }

    public ILabelProvider getLabelProvider() {
        return this.delegate.getLabelProvider();
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return this.delegate.isCompatibleWith(anotherProperty);
    }
}

