/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.properties.udp;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.properties.ReadOnlyPropertyDescriptor;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class UserDefinedPropertyDescriptor
extends TextPropertyDescriptor {
    public static final String CATEGORY = UiConstants.Util.getString("UserDefinedPropertyDescriptor.category", new Object[0]);
    private boolean showReadOnlyDialog = true;
    private EObject entry;

    public UserDefinedPropertyDescriptor(EObject entry, String displayName) {
        super((Object)entry, displayName);
        this.entry = entry;
    }

    public void setShowReadOnlyDialog(boolean enable) {
        this.showReadOnlyDialog = enable;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject(this.entry);
        if (modelResource == null) {
            return null;
        }
        if (ModelUtil.isIResourceReadOnly((IResource)modelResource.getResource())) {
            if (this.showReadOnlyDialog) {
                Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)ReadOnlyPropertyDescriptor.READ_ONLY_TITLE, (String)ReadOnlyPropertyDescriptor.READ_ONLY_MESSAGE);
            }
            return null;
        }
        IFile file = (IFile)modelResource.getResource();
        if (file != null && !ModelEditorManager.isOpen(file)) {
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)ModelEditorManager.OPEN_EDITOR_TITLE, (String)ModelEditorManager.OPEN_EDITOR_MESSAGE)) {
                ModelEditorManager.open(this.entry, true);
            }
            return null;
        }
        return super.createPropertyEditor(parent);
    }

    public String getCategory() {
        return CATEGORY;
    }
}

