/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.KeyInValueHashMap;
import org.teiid.designer.ui.refactor.RefactorResourcesUtils;
import org.teiid.designer.vdb.refactor.VdbResourceChange;

public abstract class AbstractResourcesRefactoring
extends Refactoring {
    private final List<IResource> resources;
    private Set<IResource> resourcesAndChildren;
    private Map<IResource, Collection<Change>> changes = new LinkedHashMap<IResource, Collection<Change>>();
    private final KeyInValueHashMap<String, VdbResourceChange> vdbChanges;
    private String name;

    public AbstractResourcesRefactoring(String name, List<IResource> resources) {
        this.name = name;
        this.resources = resources;
        this.vdbChanges = new KeyInValueHashMap((KeyInValueHashMap.KeyFromValueAdapter)new VdbResourceChangeAdapter());
    }

    public String getName() {
        return this.name;
    }

    public List<IResource> getResources() {
        return this.resources;
    }

    public Set<IResource> getResourcesAndChildren(RefactoringStatus status) {
        if (this.resourcesAndChildren == null) {
            this.resourcesAndChildren = new HashSet<IResource>();
            for (IResource resource : this.resources) {
                try {
                    resource.accept(new IResourceVisitor(){

                        public boolean visit(IResource visitedResource) {
                            AbstractResourcesRefactoring.this.resourcesAndChildren.add(visitedResource);
                            return true;
                        }
                    }, 2, false);
                }
                catch (Exception err) {
                    ModelerCore.Util.log(4, (Throwable)err, err.getMessage());
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)err.getMessage()));
                }
            }
        }
        return this.resourcesAndChildren;
    }

    protected abstract void checkResource(IResource var1, IProgressMonitor var2, RefactoringStatus var3);

    protected void addVdbChange(VdbResourceChange change) {
        VdbResourceChange mappedChange = (VdbResourceChange)this.vdbChanges.get((Object)(String.valueOf(change.getParentFolder()) + change.getVdbName()));
        if (mappedChange == null) {
            this.vdbChanges.add((Object)change);
            return;
        }
        mappedChange.addReplacements(change.getReplacedResources());
    }

    protected void addVdbChange(IFile vdbFile, IPath invalidResourcePath, IPath newResourcePath) {
        VdbResourceChange change = (VdbResourceChange)this.vdbChanges.get((Object)(String.valueOf(vdbFile.getParent().getName()) + vdbFile.getName()));
        if (change == null) {
            change = new VdbResourceChange(vdbFile);
        }
        change.addReplacement(invalidResourcePath.toOSString(), newResourcePath.toOSString());
        this.vdbChanges.add((Object)change);
    }

    protected void addChange(IResource resource, Change change) {
        if (change instanceof VdbResourceChange) {
            this.addVdbChange((VdbResourceChange)change);
            return;
        }
        Collection<Change> collection = this.changes.get(resource);
        if (collection == null) {
            collection = new ArrayList<Change>();
            this.changes.put(resource, collection);
        }
        collection.add(change);
    }

    protected boolean addTextChange(IFile file, TextFileChange textFileChange) {
        if (textFileChange == null) {
            return false;
        }
        if (textFileChange.getEdit() == null || !textFileChange.getEdit().hasChildren()) {
            return false;
        }
        this.addChange((IResource)file, (Change)textFileChange);
        return true;
    }

    protected Collection<Change> getChanges() {
        ArrayList<Change> changeCollection = new ArrayList<Change>();
        for (Map.Entry<IResource, Collection<Change>> entry : this.changes.entrySet()) {
            changeCollection.addAll(entry.getValue());
        }
        changeCollection.addAll(this.vdbChanges.values());
        return changeCollection;
    }

    protected void clearChanges() {
        this.changes.clear();
        this.vdbChanges.clear();
    }

    protected boolean checkResourcesNotEmpty(RefactoringStatus status) {
        if (this.getResources() == null || this.getResources().isEmpty()) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactorResourcesUtils.getString("ResourcesRefactoring.noResourceError", new Object[0])));
            return false;
        }
        return true;
    }

    public class VdbResourceCallback
    extends RefactorResourcesUtils.AbstractResourceCallback {
        @Override
        public void indexVdb(IResource resource, IFile vdbFile, RefactoringStatus status) {
            AbstractResourcesRefactoring.this.addChange((IResource)vdbFile, (Change)new VdbResourceChange(vdbFile));
        }
    }

    private class VdbResourceChangeAdapter
    implements KeyInValueHashMap.KeyFromValueAdapter<String, VdbResourceChange> {
        private VdbResourceChangeAdapter() {
        }

        public String getKey(VdbResourceChange value) {
            return String.valueOf(value.getParentFolder()) + value.getVdbName();
        }
    }
}

