/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.refactor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.plugin.PluginUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.refactor.RefactorCommand;
import org.teiid.designer.core.refactor.ReferenceUpdator;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ConcurrentModelVisitorProcessor;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.CoreValidationRulesUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.transformation.aspects.sql.SqlTransformationMappingRootSqlAspect;
import org.w3c.dom.Element;

public class ModelCopyCommand
implements RefactorCommand {
    public static final int ERROR_MISSING_RESOURCE = 1800;
    public static final int ERROR_MISSING_DESTINATION = 1801;
    public static final int ERROR_MISSING_NAME = 1802;
    public static final int ERROR_PROJECT_CLOSED = 1805;
    public static final int ERROR_PROJECT_NATURE = 1806;
    public static final int EXCEPTION_PROJECT_NATURE = 1807;
    public static final int ERROR_FILE_ALREADY_EXISTS = 1808;
    public static final int ERROR_CREATING_FILE = 1809;
    public static final int READY_TO_EXECUTE = 1810;
    public static final int ERROR_COPYING_RESOURCE = 1811;
    public static final int EXECUTE_WITH_NO_PROBLEMS = 1812;
    public static final int EXECUTE_WITH_WARNINGS = 1813;
    public static final int EXECUTE_WITH_ERRORS = 1814;
    public static final int EXECUTE_WITH_WARNINGS_AND_ERRORS = 1815;
    public static final int EXECUTE_WITH_NO_WARNINGS_AND_ERRORS = 1816;
    static final String PID = "org.teiid.designer.core";
    private static final String UUID_ATTRIBUTE_NAME = "UUID";
    private static Collection REFERENCE_UPDATORS;
    private ModelResource resourceToCopy;
    private IContainer destination;
    private String newModelName;
    private String extension;
    private IFile newIFile;
    private ArrayList problemList = new ArrayList();
    private Collection referencingResources;

    public void setModelToCopy(ModelResource modelResource) {
        this.resourceToCopy = modelResource;
        this.extension = modelResource.getResource().getFileExtension();
    }

    public void setNewModelDestination(IContainer destination, String name) {
        this.newModelName = name;
        this.destination = destination;
    }

    public void setModelsToRedirect(Collection modelResourceList) {
        this.referencingResources = modelResourceList;
    }

    public IStatus canExecute() {
        if (this.newModelName.length() == 0) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.No_new_model_name", new Object[0]);
            return new Status(4, PID, 1802, msg, null);
        }
        if (this.resourceToCopy == null) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.No_resource_has_been_selected", new Object[0]);
            return new Status(4, PID, 1800, msg, null);
        }
        if (this.destination == null) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.No_destination_has_been_selected", new Object[0]);
            return new Status(4, PID, 1002, msg, null);
        }
        if (!this.destination.getProject().isOpen()) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.Error_project_closed", new Object[0]);
            return new Status(4, PID, 1805, msg, null);
        }
        try {
            if (this.destination.getProject().getNature("org.teiid.designer.core.modelNature") == null) {
                String msg = ModelerCore.Util.getString("ModelCopyCommand.Cannot_move_to_non_model_project", new Object[0]);
                return new Status(4, PID, 1806, msg, null);
            }
        }
        catch (CoreException e) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.Cannot_determine_project_nature", new Object[0]);
            return new Status(4, PID, 1807, msg, (Throwable)e);
        }
        ValidationResultImpl result = new ValidationResultImpl((Object)this.newModelName);
        CoreValidationRulesUtil.validateStringNameChars((ValidationResult)result, (String)this.newModelName, null);
        if (result.hasProblems()) {
            ValidationProblem problem = result.getProblems()[0];
            return new Status(problem.getSeverity(), PID, problem.getCode(), problem.getMessage(), null);
        }
        if (this.fileAlreadyExists(this.newModelName)) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.Name_already_exists_in_container", new Object[0]);
            return new Status(4, PID, 1808, msg, null);
        }
        String msg = ModelerCore.Util.getString("ModelCopyCommand.Ready_to_execute", new Object[0]);
        return new Status(0, PID, 1000, msg, null);
    }

    public IStatus execute(IProgressMonitor monitor) {
        this.problemList.clear();
        this.newIFile = this.destination.getFile((IPath)new Path(String.valueOf(this.newModelName) + '.' + this.extension));
        if (this.isXsdResource(this.newIFile)) {
            this.executeXsdCopy(monitor);
        } else {
            this.executeXmiCopy(monitor);
        }
        IStatus resultStatus = null;
        if (this.problemList.isEmpty()) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.Model_copy_complete_1", new Object[0]);
            Status status = new Status(0, PID, 1812, msg, null);
            resultStatus = status;
        } else if (this.problemList.size() == 1) {
            resultStatus = (IStatus)this.problemList.get(0);
        } else {
            Object[] params;
            int numErrors = 0;
            int numWarnings = 0;
            for (IStatus aStatus : this.problemList) {
                if (aStatus.getSeverity() == 2) {
                    ++numWarnings;
                    continue;
                }
                if (aStatus.getSeverity() != 4) continue;
                ++numErrors;
            }
            IStatus[] statusArray = this.problemList.toArray(new IStatus[this.problemList.size()]);
            if (numWarnings != 0 && numErrors == 0) {
                params = new Object[]{new Integer(numWarnings)};
                String msg = ModelerCore.Util.getString("ModelCopyCommand.Model_copy_with_warnings_8", params);
                resultStatus = new MultiStatus(PID, 1813, statusArray, msg, null);
            } else if (numWarnings == 0 && numErrors != 0) {
                params = new Object[]{new Integer(numErrors)};
                String msg = ModelerCore.Util.getString("ModelCopyCommand.Model_copy_with_errors_9", params);
                resultStatus = new MultiStatus(PID, 1814, statusArray, msg, null);
            } else if (numWarnings != 0 && numErrors != 0) {
                params = new Object[]{new Integer(numWarnings), new Integer(numErrors)};
                String msg = ModelerCore.Util.getString("ModelCopyCommand.Model_copy_with_warnings_and_errors_10", params);
                resultStatus = new MultiStatus(PID, 1815, statusArray, msg, null);
            } else {
                String msg = ModelerCore.Util.getString("ModelCopyCommand.Model_copy_with_no_warnings_or_errors_11", new Object[0]);
                resultStatus = new MultiStatus(PID, 1816, statusArray, msg, null);
            }
        }
        return resultStatus;
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    public IStatus undo(IProgressMonitor monitor) {
        return null;
    }

    public IStatus redo(IProgressMonitor monitor) {
        return null;
    }

    public Collection getResult() {
        return null;
    }

    public Collection getAffectedObjects() {
        return null;
    }

    public String getLabel() {
        return ModelerCore.Util.getString("ModelCopyCommand.label", new Object[0]);
    }

    public String getDescription() {
        return ModelerCore.Util.getString("ModelCopyCommand.description", new Object[0]);
    }

    public Collection getPostExecuteMessages() {
        return this.problemList;
    }

    public IFile getNewIFile() {
        return this.newIFile;
    }

    protected void executeXsdCopy(IProgressMonitor monitor) {
        ModelResource modelResource;
        String msg;
        Object[] params;
        boolean modifiedState;
        boolean incrementalBuildState;
        Resource source;
        block32: {
            source = null;
            try {
                source = this.resourceToCopy.getEmfResource();
                if (source == null) {
                    Object[] params2 = new Object[]{this.resourceToCopy};
                    String msg2 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_for_2", params2);
                    this.problemList.add(new Status(4, PID, 1811, msg2, null));
                    return;
                }
            }
            catch (Throwable e) {
                String msg3 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_references_4", new Object[0]);
                this.problemList.add(new Status(4, PID, 1811, msg3, e));
            }
            incrementalBuildState = this.getXsdIncrementalBuild(source);
            this.setXsdIncrementalBuild(source, false);
            modifiedState = source.isModified();
            IPath newFilePath = this.newIFile.getLocation();
            File newFile = newFilePath.toFile();
            FileOutputStream fos = null;
            OutputStream bos = null;
            try {
                try {
                    fos = new FileOutputStream(newFile);
                    bos = new BufferedOutputStream(fos);
                    source.save(bos, Collections.EMPTY_MAP);
                }
                catch (Throwable t) {
                    params = new Object[]{newFile};
                    msg = ModelerCore.Util.getString("ModelCopyCommand.Exception_saving_XSD_resource_to_0_1", params);
                    this.problemList.add(new Status(4, PID, 1811, msg, t));
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fos != null) {
                        try {
                            ((OutputStream)fos).close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fos != null) {
                    try {
                        ((OutputStream)fos).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    ((OutputStream)fos).close();
                }
                catch (IOException iOException) {}
            }
        }
        if ((modelResource = ModelerCore.create((IFile)this.newIFile)) == null) {
            params = new Object[]{this.newModelName};
            msg = ModelerCore.Util.getString("ModelCopyCommand.Error_creating_ModelResource_for_1", params);
            this.problemList.add(new Status(4, PID, 1811, msg, null));
            return;
        }
        Resource target = null;
        try {
            target = modelResource.getEmfResource();
            if (target == null) {
                Object[] params3 = new Object[]{modelResource};
                String msg4 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_for_3", params3);
                this.problemList.add(new Status(4, PID, 1811, msg4, null));
                return;
            }
            this.resetXsdSimpleTypeUuids(target);
            target.save(Collections.EMPTY_MAP);
            target.setModified(false);
        }
        catch (Throwable e) {
            String msg5 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_references_4", new Object[0]);
            this.problemList.add(new Status(4, PID, 1811, msg5, e));
        }
        try {
            modelResource.save(monitor, true);
        }
        catch (Throwable e) {
            Object[] params4 = new Object[]{modelResource};
            String msg6 = ModelerCore.Util.getString("ModelCopyCommand.Error_saving_new_model_resource_7", params4);
            this.problemList.add(new Status(4, PID, 1811, msg6, e));
        }
        this.setXsdIncrementalBuild(source, incrementalBuildState);
        source.setModified(modifiedState);
        Map originalsToCopies = this.getOriginalToCopiesMap(source, target);
        this.updateReferencingResources(monitor, originalsToCopies, modelResource);
    }

    protected Map getOriginalToCopiesMap(Resource source, Resource target) {
        String uriFragment;
        int beginIndex;
        String uri;
        HashMap<EObject, EObject> originalToCopied = new HashMap<EObject, EObject>();
        HashMap<String, EObject> uriFragmentToObject = new HashMap<String, EObject>();
        TreeIterator iter = source.getAllContents();
        while (iter.hasNext()) {
            EObject originalObj = (EObject)iter.next();
            uri = EcoreUtil.getURI((EObject)originalObj).toString();
            beginIndex = uri.indexOf("#") + 1;
            String string = uriFragment = beginIndex > 0 ? uri.substring(beginIndex) : uri;
            if (uriFragment == null) continue;
            uriFragmentToObject.put(uriFragment.toUpperCase(), originalObj);
        }
        iter = target.getAllContents();
        while (iter.hasNext()) {
            EObject originalObject;
            EObject copiedObj = (EObject)iter.next();
            uri = EcoreUtil.getURI((EObject)copiedObj).toString();
            beginIndex = uri.indexOf("#") + 1;
            String string = uriFragment = beginIndex > 0 ? uri.substring(beginIndex) : uri;
            if (uriFragment == null || (originalObject = (EObject)uriFragmentToObject.get(uriFragment.toUpperCase())) == null) continue;
            originalToCopied.put(originalObject, copiedObj);
        }
        return originalToCopied;
    }

    protected void executeXmiCopy(IProgressMonitor monitor) {
        String msg;
        ModelResource modelResource = ModelerCore.create((IFile)this.newIFile);
        if (modelResource == null) {
            Object[] params = new Object[]{this.newModelName};
            String msg2 = ModelerCore.Util.getString("ModelCopyCommand.Error_creating_ModelResource_for_1", params);
            this.problemList.add(new Status(4, PID, 1811, msg2, null));
            return;
        }
        Resource source = null;
        Resource target = null;
        try {
            source = this.resourceToCopy.getEmfResource();
            if (source == null) {
                Object[] params = new Object[]{this.resourceToCopy};
                String msg3 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_for_2", params);
                this.problemList.add(new Status(4, PID, 1811, msg3, null));
                return;
            }
            target = modelResource.getEmfResource();
            if (target == null) {
                Object[] params = new Object[]{modelResource};
                String msg4 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_for_3", params);
                this.problemList.add(new Status(4, PID, 1811, msg4, null));
                return;
            }
        }
        catch (Throwable e) {
            String msg5 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_references_4", new Object[0]);
            this.problemList.add(new Status(4, PID, 1811, msg5, e));
        }
        HashMap<Object, Object> originalsToCopies = new HashMap<Object, Object>();
        try {
            if (source instanceof EmfResource && target instanceof EmfResource) {
                ModelAnnotation sourceAnnot = ((EmfResource)source).getModelAnnotation();
                ModelAnnotation targetAnnot = ((EmfResource)target).getModelAnnotation();
                if (targetAnnot == null) {
                    targetAnnot = (ModelAnnotation)this.copyEObject((EObject)sourceAnnot);
                    target.getContents().add((Object)targetAnnot);
                } else {
                    targetAnnot.setDescription(sourceAnnot.getDescription());
                    targetAnnot.setExtensionPackage(sourceAnnot.getExtensionPackage());
                    targetAnnot.setMaxSetSize(sourceAnnot.getMaxSetSize());
                    targetAnnot.setModelType(sourceAnnot.getModelType());
                    targetAnnot.setNameInSource(sourceAnnot.getNameInSource());
                    targetAnnot.setPrimaryMetamodelUri(sourceAnnot.getPrimaryMetamodelUri());
                    targetAnnot.setSupportsDistinct(sourceAnnot.isSupportsDistinct());
                    targetAnnot.setSupportsJoin(sourceAnnot.isSupportsJoin());
                    targetAnnot.setSupportsOrderBy(sourceAnnot.isSupportsOrderBy());
                    targetAnnot.setSupportsOuterJoin(sourceAnnot.isSupportsOuterJoin());
                    targetAnnot.setSupportsWhereAll(sourceAnnot.isSupportsWhereAll());
                    targetAnnot.setVisible(sourceAnnot.isVisible());
                    targetAnnot.eContents().clear();
                    for (EObject sourceImport : sourceAnnot.eContents()) {
                        if (sourceImport == null) continue;
                        EObject targetImport = this.copyEObject(sourceImport);
                        targetAnnot.getModelImports().add((Object)targetImport);
                        originalsToCopies.put(sourceImport, targetImport);
                    }
                    originalsToCopies.put(sourceAnnot, targetAnnot);
                }
            }
        }
        catch (Throwable e) {
            msg = ModelerCore.Util.getString("ModelCopyCommand.Error_copying_ModelAnnotation_information_5", new Object[0]);
            this.problemList.add(new Status(4, PID, 1811, msg, e));
        }
        try {
            ArrayList sourceRootsToCopy = new ArrayList(source.getContents());
            Iterator iter = sourceRootsToCopy.iterator();
            while (iter.hasNext()) {
                EObject sourceRoot = (EObject)iter.next();
                if (!(sourceRoot instanceof ModelAnnotation)) continue;
                iter.remove();
            }
            Collection targetRoots = this.copyEObject(sourceRootsToCopy, originalsToCopies);
            SqlTransformationMappingRootSqlAspect.replaceTransformationLiteral((Collection)targetRoots, (String)this.resourceToCopy.getItemName(), (String)modelResource.getItemName());
            for (EObject targetRoot : targetRoots) {
                ResetReferencesVisitor visitor = new ResetReferencesVisitor(originalsToCopies, false);
                ConcurrentModelVisitorProcessor processor = new ConcurrentModelVisitorProcessor((ModelVisitor)visitor);
                processor.walk(targetRoot, 2);
                target.getContents().add((Object)targetRoot);
            }
        }
        catch (Throwable e) {
            msg = ModelerCore.Util.getString("ModelCopyCommand.Error_copying_model_roots_6", new Object[0]);
            this.problemList.add(new Status(4, PID, 1811, msg, e));
        }
        try {
            ModelBuildUtil.rebuildImports((Resource)target, (boolean)true);
            modelResource.save(monitor, true);
        }
        catch (Throwable e) {
            Object[] params = new Object[]{modelResource};
            String msg6 = ModelerCore.Util.getString("ModelCopyCommand.Error_saving_new_model_resource_7", params);
            this.problemList.add(new Status(4, PID, 1811, msg6, e));
        }
        this.updateReferencingResources(monitor, originalsToCopies, modelResource);
    }

    public void updateReferencingResources(IProgressMonitor monitor, Map originalsToCopies, ModelResource referencedResource) {
        if (this.referencingResources == null || this.referencingResources.isEmpty()) {
            return;
        }
        ResetReferencesVisitor visitor = new ResetReferencesVisitor(originalsToCopies, true);
        try {
            for (ModelResource referenceResource : this.referencingResources) {
                ConcurrentModelVisitorProcessor processor = new ConcurrentModelVisitorProcessor((ModelVisitor)visitor);
                processor.walk(referenceResource, 2);
                referenceResource.save(monitor, true);
            }
        }
        catch (Throwable e) {
            Object[] params = new Object[]{referencedResource};
            String msg = ModelerCore.Util.getString("ModelCopyCommand.0", params);
            this.problemList.add(new Status(4, PID, 1811, msg, e));
        }
    }

    static Collection getReferenceUpdators() {
        if (REFERENCE_UPDATORS == null) {
            IExtension[] extensions = PluginUtilities.getExtensions((String)"org.teiid.designer.core.referenceUpdator");
            REFERENCE_UPDATORS = new ArrayList(extensions.length);
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                try {
                    Object instance = PluginUtilities.createExecutableExtension((IExtension)extension, (String)"class", (String)"name");
                    if (instance instanceof ReferenceUpdator) {
                        REFERENCE_UPDATORS.add(instance);
                    } else {
                        String message = ModelerCore.Util.getString("ModelCopyCommand.0", new Object[0]);
                        ModelerCore.Util.log((Object)message);
                    }
                }
                catch (CoreException e) {
                    ModelerCore.Util.log((Throwable)e);
                }
                ++i;
            }
        }
        return REFERENCE_UPDATORS;
    }

    private String getModifiedPathString(String proposedName) {
        String parentPath = this.destination.getFullPath().toString();
        String newPath = String.valueOf(parentPath) + '/' + proposedName;
        if (this.extension != null && this.extension.length() > 0) {
            newPath = String.valueOf(newPath) + '.' + this.extension;
        }
        return newPath;
    }

    private boolean fileAlreadyExists(String proposedName) {
        String newPath = this.getModifiedPathString(proposedName);
        IWorkspaceRoot workspaceRoot = this.resourceToCopy.getResource().getWorkspace().getRoot();
        return workspaceRoot.findMember(newPath) != null;
    }

    private EObject copyEObject(EObject eObject) {
        return EcoreUtil.copy((EObject)eObject);
    }

    private Collection copyEObject(List eObjects, Map originalsToCopies) throws Exception {
        return ModelerCore.getModelEditor().copyAll((Collection)eObjects, originalsToCopies);
    }

    private boolean isXsdResource(IFile resource) {
        return ModelUtil.isXsdFile((IResource)resource);
    }

    private boolean getXsdIncrementalBuild(Resource resource) {
        XSDResourceImpl xsdResource;
        XSDSchema schema;
        if (resource instanceof XSDResourceImpl && (schema = (xsdResource = (XSDResourceImpl)resource).getSchema()) != null) {
            return schema.isIncrementalUpdate();
        }
        return false;
    }

    private void resetXsdSimpleTypeUuids(Resource resource) throws Exception {
        XSDResourceImpl xsdResource;
        XSDSchema schema;
        if (resource instanceof XSDResourceImpl && (schema = (xsdResource = (XSDResourceImpl)resource).getSchema()) != null) {
            for (EObject eObj : schema.getContents()) {
                XSDSimpleTypeDefinition type;
                XSDAnnotation annotation;
                if (!(eObj instanceof XSDSimpleTypeDefinition) || (annotation = (type = (XSDSimpleTypeDefinition)eObj).getAnnotation()) == null) continue;
                for (Element appInfo : annotation.getApplicationInformation()) {
                    String uuid = appInfo.getAttribute(UUID_ATTRIBUTE_NAME);
                    if (uuid == null) continue;
                    uuid = IDGenerator.getInstance().create().toString();
                    appInfo.setAttribute(UUID_ATTRIBUTE_NAME, uuid);
                    uuid = appInfo.getAttribute(UUID_ATTRIBUTE_NAME);
                }
            }
        }
    }

    private void setXsdIncrementalBuild(Resource resource, boolean isIncrementalUpdate) {
        XSDResourceImpl xsdResource;
        XSDSchema schema;
        if (resource instanceof XSDResourceImpl && (schema = (xsdResource = (XSDResourceImpl)resource).getSchema()) != null) {
            schema.setIncrementalUpdate(isIncrementalUpdate);
        }
    }

    private class ResetReferencesVisitor
    implements ModelVisitor {
        private final Map originalsToCopies;
        private final Collection updatedExternalObjects = new HashSet();
        private final boolean isExternalResource;

        public ResetReferencesVisitor(Map originalsToCopies, boolean isExternalResource) {
            this.originalsToCopies = originalsToCopies;
            this.isExternalResource = isExternalResource;
        }

        public boolean visit(EObject eObj) {
            EList refs = eObj.eClass().getEAllReferences();
            for (EReference eReference : refs) {
                if (eReference.isContainment() && eReference.isContainer() && eReference.isVolatile()) continue;
                Object value = eObj.eGet((EStructuralFeature)eReference);
                if (eReference.isMany()) {
                    List values = (List)value;
                    if (values.isEmpty()) continue;
                    ArrayList<EObject> newValues = new ArrayList<EObject>(values.size());
                    boolean resetList = false;
                    for (Object valueInList : values) {
                        if (valueInList == null || !(valueInList instanceof EObject)) continue;
                        EObject orig = (EObject)valueInList;
                        EObject copy = (EObject)this.originalsToCopies.get(orig);
                        if (copy != null) {
                            newValues.add(copy);
                            resetList = true;
                            continue;
                        }
                        this.updateReference(orig);
                        newValues.add(orig);
                    }
                    if (!resetList) continue;
                    ModelerCore.getModelEditor().setPropertyValue(eObj, newValues, (Object)eReference);
                    continue;
                }
                if (value == null || !(value instanceof EObject)) continue;
                EObject orig = (EObject)value;
                EObject copy = (EObject)this.originalsToCopies.get(orig);
                if (copy != null) {
                    eObj.eSet((EStructuralFeature)eReference, (Object)copy);
                    continue;
                }
                this.updateReference(orig);
            }
            return true;
        }

        private void updateReference(EObject eObject) {
            if (this.isExternalResource && !this.updatedExternalObjects.contains(eObject)) {
                for (ReferenceUpdator updator : ModelCopyCommand.getReferenceUpdators()) {
                    updator.updateEObject(eObject, this.originalsToCopies);
                }
                this.updatedExternalObjects.add(eObject);
            }
        }

        public boolean visit(Resource resource) {
            return resource != null;
        }
    }
}

